package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author licancan
 * @description 导出办理请求参数
 * @date 2022-07-21 14:21:06
 */
@Data
@Schema(description = "导出办理请求参数")
public class InsuranceExportListParam extends BaseEntity implements Serializable {
	private static final long serialVersionUID = 3623027153213352936L;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 商险id集合
	 */
	@Schema(description = "商险id集合")
	private List<String> idList;

	/**
	 * 购买类型， 1新增、3批增、4替换
	 */
	@Schema(description = " 购买类型(派单类型)， 1新增、3批增、4替换")
	private Integer buyType;

	/**
	 * 创建者-姓名
	 */
	@Schema(description = "派单人")
	private String createName;

	/**
	 * 派单开始时间
	 */
	@Schema(description = "派单开始时间")
	private String startDate;

	/**
	 * 派单结束时间
	 */
	@Schema(description = "派单结束时间")
	private String endDate;
}
