package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author zhaji
 * @description 已投保查询返回类
 * @date 2022-07-21 09:46:09
 */
@Data
@Tag(name = "已投保查询返回类")
public class InsuredListVo implements Serializable {
	private static final long serialVersionUID = -6673220061558171816L;
	//订单编号、姓名、身份证、投保类型、项目、岗位、保单起止日期、购买月数、保单生效日期、保险公司、是否出险、险种、购买标准 减员状态、
	/**
	 * 主键
	 */
	@Schema(description = "主键")
	private String id;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 减员状态 1待减员 2减员中3减员退回
	 */
	@Schema(description = "减员状态 1待减员 2减员中3减员退回")
	private Integer reduceHandleStatus;

	/**
	 * 投保类型， 1新增、3批增、4替换
	 */
	@Schema(description = " 投保类型， 1新增、3批增、4替换")
	private Integer buyType;

	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	private String projectName;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 投保岗位
	 */
	@Schema(description = "投保岗位")
	private String post;

	/**
	 * 保单开始时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单开始时间")
	private LocalDate policyStart;

	/**
	 * 保单结束时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单结束时间")
	private LocalDate policyEnd;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 医疗额度
	 */
	@Schema(description = "医疗额度")
	private String medicalQuota;

	/**
	 * 身故或残疾额度
	 */
	@Schema(description = "身故或残疾额度")
	private String dieDisableQuota;

	/**
	 * 预估保费
	 */
	@Schema(description = "预估保费")
	private BigDecimal estimatePremium;

	/**
	 * 实际保费
	 */
	@Schema(description = "实际保费")
	private BigDecimal actualPremium;

	/**
	 * 保单号
	 */
	@Schema(description = "保单号")
	private String policyNo;

	/**
	 * 发票号
	 */
	@Schema(description = "发票号")
	private String invoiceNo;

	/**
	 * 保单生效日期
	 */
	@Schema(description = "保单生效日期")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	private LocalDate policyEffect;

	/**
	 * 商险购买地省code
	 */
	@Schema(description = "商险购买地省code")
	private Integer insuranceProvince;

	/**
	 * 商险购买地省
	 */
	@Schema(description = "商险购买地省")
	private String insuranceProvinceName;

	/**
	 * 商险购买地市code
	 */
	@Schema(description = "商险购买地市code")
	private Integer insuranceCity;

	/**
	 * 商险购买地市
	 */
	@Schema(description = "商险购买地市")
	private String insuranceCityName;

	/**
	 * 商险办理省code
	 */
	@Schema(description = "商险办理省code")
	private Integer insuranceHandleProvince;

	/**
	 * 商险办理省
	 */
	@Schema(description = "商险办理省")
	private String insuranceHandleProvinceName;

	/**
	 * 商险办理城市code
	 */
	@Schema(description = "商险办理城市code")
	private Integer insuranceHandleCity;

	/**
	 * 商险办理城市
	 */
	@Schema(description = "商险办理城市")
	private String insuranceHandleCityName;

	/**
	 * 是否出险 0未出险 1已出险
	 */
	@Schema(description = "是否出险 0未出险 1已出险")
	private Integer isUse;

	/**
	 * 是否有效 0有效 1无效
	 */
	@Schema(description = "是否有效 0有效 1无效")
	private Integer isEffect;

	/**
	 * 是否过期 0未过期 1已过期
	 */
	@Schema(description = "是否过期 0未过期 1已过期")
	private Integer isOverdue;

	/**
	 * 派单日期
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "派单日期")
	private LocalDate createTime;

	/**
	 * 派单人
	 */
	@Schema(description = "创建人(派单人)")
	private String createName;

	/**
	 * 购买月数
	 */
	@Schema(description = "购买月数")
	private Long buyMonth;

	/**
	 * 创建人所在部门名称
	 */
	@Schema(description = "创建人所在部门名称")
	private String createUserDeptName;

	/**
	 * 封面抬头
	 */
	@Schema(description = "封面抬头")
	private String invoiceTitle;


}
