package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhaji
 * @description 已投保列表查询条件
 * @date 2022-07-21 09:25:34
 */
@Data
@Tag(name = "已投保列表查询条件")
public class InsuredParam extends BaseEntity implements Serializable {
	private static final long serialVersionUID = -2689686777914935788L;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 保单号
	 */
	@Schema(description = "保单号")
	private String policyNo;

	/**
	 * 保险公司ID
	 */
	@Schema(description = "保险公司ID")
	private String insuranceCompanyId;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 保单开始时间
	 */
	@Schema(description = "保单开始时间")
	private String policyStart;

	/**
	 * 保单结束时间
	 */
	@Schema(description = "保单结束时间")
	private String policyEnd;

	/**
	 * 发票号
	 */
	@Schema(description = "发票号")
	private String invoiceNo;

	/**
	 * 投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员
	 */
	@Schema(description = "投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员")
	private Integer buyHandleStatus;

	/**
	 * 是否出险 0未出险 1已出险
	 */
	@Schema(description = "是否出险 0未出险 1已出险")
	private Integer isUse;

	/**
	 * 是否有效 0有效 1无效
	 */
	@Schema(description = "是否有效 0有效 1无效")
	private Integer isEffect;

	/**
	 * 是否过期 0未过期 1已过期
	 */
	@Schema(description = "是否过期 0未过期 1已过期")
	private Integer isOverdue;

	/**
	 * 派单开始日期
	 */
	@Schema(description = "派单开始日期")
	private String createStartTime;

	/**
	 * 派单结束日期
	 */
	@Schema(description = "派单结束日期")
	private String createEndTime;

	/**
	 * 项目编码列表
	 */
	@Schema(description = "项目编码列表")
	private List<String> deptNoList;

	@Schema(description = " 投保类型， 1新增、3批增、4替换")
	private Integer buyType;

	@Schema(description = "减员状态 1待减员 2减员中3减员退回,4减员成功")
	private Integer reduceHandleStatus;

}
