/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ArrayUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CacheConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceAreaRes;
import com.yifu.cloud.plus.v1.yifu.insurances.mapper.insurances.TInsuranceAreaResMapper;
import com.yifu.cloud.plus.v1.yifu.insurances.service.TInsuranceAreaResService;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.TInsuranceAreaExportVo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.TInsuranceAreaResSearchVo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.TInsuranceAreaResVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
/**
 * 商险地市权限配置表
 *
 * @author fxj
 * @date 2022-11-01 10:32:05
 */
@Log4j2
@Service
public class TInsuranceAreaResServiceImpl extends ServiceImpl<TInsuranceAreaResMapper, TInsuranceAreaRes> implements TInsuranceAreaResService {

	@Autowired
	private RedisUtil redisUtil;
	/**
     * 商险地市权限配置表简单分页查询
     * @param tInsuranceAreaRes 商险地市权限配置表
     * @return
     */
    @Override
    public IPage<TInsuranceAreaRes> getTInsuranceAreaResPage(Page<TInsuranceAreaRes> page, TInsuranceAreaResSearchVo tInsuranceAreaRes){
        return baseMapper.getTInsuranceAreaResPage(page,tInsuranceAreaRes);
    }

    /**
     * 商险地市权限配置表批量导出
     * @param searchVo 商险地市权限配置表
     * @return
     */
    @Override
    public void listExport(HttpServletResponse response, TInsuranceAreaResSearchVo searchVo){
        String fileName = "商险办理权限批量导出" + DateUtil.getThisTime() + ".xlsx";
        //获取要导出的列表
        List<TInsuranceAreaExportVo> list = new ArrayList<>();
        long count =  noPageCountDiy(searchVo,null,Common.getList(searchVo.getIds()),null);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            response.setContentType(CommonConstants.MULTIPART_FORM_DATA);
            response.setCharacterEncoding("utf-8");
            response.setHeader(CommonConstants.CONTENT_DISPOSITION, CommonConstants.ATTACHMENT_FILENAME + URLEncoder.encode(fileName  , CommonConstants.UTF8));
            // 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
            //EasyExcel.write(out, TEmpBadRecord.class).sheet("不良记录").doWrite(list);
            ExcelWriter  excelWriter = EasyExcel.write(out, TInsuranceAreaExportVo.class).build();
            int index = 0;
            if (count >  CommonConstants.ZERO_INT){
                for (int i = 0; i <= count; ) {
                    // 获取实际记录
                    searchVo.setLimitStart(i);
                    searchVo.setLimitEnd(CommonConstants.EXCEL_EXPORT_LIMIT);
                    list = noPageDiy(searchVo,null,Common.getList(searchVo.getIds()),null);
                    if (Common.isNotNull(list)){
                        ExcelUtil<TInsuranceAreaExportVo> util = new ExcelUtil<>(TInsuranceAreaExportVo.class);
                        for (TInsuranceAreaExportVo vo:list){
                            util.convertEntity(vo,null,null,null);
                        }
                    }
                    if (Common.isNotNull(list)){
                        WriteSheet writeSheet = EasyExcel.writerSheet("商险办理权限配置表"+index).build();
                        excelWriter.write(list,writeSheet);
                        index++;
                    }
                    i = i + CommonConstants.EXCEL_EXPORT_LIMIT;
                    if (Common.isNotNull(list)){
                        list.clear();
                    }
                }
            }else {
                WriteSheet writeSheet = EasyExcel.writerSheet("商险办理权限配置表"+index).build();
                excelWriter.write(list,writeSheet);
            }
            if (Common.isNotNull(list)){
                list.clear();
            }
            out.flush();
            excelWriter.finish();
        }catch (Exception e){
            log.error("执行异常" ,e);
        }finally {
            try {
                if (null != out) {
                    out.close();
                }
            } catch (IOException e) {
                log.error("执行异常", e);
            }
        }
    }

	@Override
	public void removeAuthCache() {
		try{
			redisUtil.remove(CacheConstants.DATA_AUTH_DETAILS + CommonConstants.ONE_STRING);
			redisUtil.remove(CacheConstants.DATA_AUTH_DETAILS + CommonConstants.ZERO_STRING);
		} catch (Exception e) {
			log.error("清除权限配置缓存错误：",e);
		}
	}

	@Override
    public List<TInsuranceAreaExportVo> noPageDiy(TInsuranceAreaResSearchVo searchVo,
												  List<String> settleDomainIds,
												  List<String> ids,
												  String sql) {
		return baseMapper.noPageDiy(searchVo,settleDomainIds,ids,sql);
    }

    private  Integer noPageCountDiy(TInsuranceAreaResSearchVo searchVo,
								 List<String> settleDomainIds,
								 List<String> ids,
								 String sql) {
		return baseMapper.noPageCountDiy(searchVo,settleDomainIds,ids,sql);
    }

    @Override
    public R<List<ErrorMessage>> importDiy(InputStream inputStream) {
        List<ErrorMessage> errorMessageList = new ArrayList<>();
        ExcelUtil<TInsuranceAreaResVo> util1 = new ExcelUtil<>(TInsuranceAreaResVo.class);;
        // 写法2：
        // 匿名内部类 不用额外写一个DemoDataListener
        // 这里 需要指定读用哪个class去读，然后读取第一个sheet 文件流会自动关闭
        try {
            EasyExcel.read(inputStream, TInsuranceAreaResVo.class, new ReadListener<TInsuranceAreaResVo>() {
                /**
                 * 单次缓存的数据量
                 */
                public static final int BATCH_COUNT = CommonConstants.BATCH_COUNT;
                /**
                 *临时存储
                 */
                private List<TInsuranceAreaResVo> cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);

                @Override
                public void invoke(TInsuranceAreaResVo data, AnalysisContext context) {
                    ReadRowHolder readRowHolder = context.readRowHolder();
                    Integer rowIndex = readRowHolder.getRowIndex();
                    data.setRowIndex(rowIndex+1);
                    ErrorMessage errorMessage = util1.checkEntity(data, data.getRowIndex());
                    if (Common.isNotNull(errorMessage)){
                        errorMessageList.add(errorMessage);
                    }else {
                        cachedDataList.add(data);
                    }
                    if (cachedDataList.size() >= BATCH_COUNT) {
                        saveData();
                        // 存储完成清理 list
                        cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
                    }
                }
                @Override
                public void doAfterAllAnalysed(AnalysisContext context) {
                    saveData();
                }

                /**
                 * 加上存储数据库
                 */
                private void saveData() {
                    log.info("{}条数据，开始存储数据库！", cachedDataList.size());
                    importTInsuranceAreaRes(cachedDataList,errorMessageList);
                    log.info("存储数据库成功！");
                }
            }).sheet().doRead();
        }catch (Exception e){
            log.error(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR,e);
            return R.failed(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR);
        }
        return  R.ok(errorMessageList);
    }
    private void importTInsuranceAreaRes(List<TInsuranceAreaResVo> excelVOList, List<ErrorMessage> errorMessageList) {
        // 个性化校验逻辑
        ErrorMessage errorMsg;
        // 执行数据插入操作 组装
        for (int i = 0; i < excelVOList.size(); i++) {
            TInsuranceAreaResVo excel = excelVOList.get(i);
            // 数据合法情况 TODO

            // 插入
            insertExcel(excel);
            errorMessageList.add(new ErrorMessage(excel.getRowIndex(),CommonConstants.SAVE_SUCCESS));
        }
    }
    /**
     * 插入excel bad record
     */
    private void insertExcel(TInsuranceAreaResVo excel) {
        TInsuranceAreaRes insert = new TInsuranceAreaRes();
        BeanUtil.copyProperties(excel, insert);
        this.save(insert);
    }
}
