package com.yifu.cloud.plus.v1.job.compont;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprInsurancesProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.HttpDaprUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author licancan
 * @description 商险模块到期定时任务
 * @date 2022-08-03 10:39:14
 */
@Component(value = "updateOverdueTask")
@Slf4j
@EnableConfigurationProperties(DaprInsurancesProperties.class)
public class UpdateOverdueTask {
	@Resource
	private DaprInsurancesProperties daprInsurancesProperties;

	/**
	 * 更新商险到期定时任务
	 *
	 * @author licancan
	 * @param
	 * @return void
	 */
	public void updateOverdueTask() throws Exception {
		log.info("-------------更新商险到期-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprInsurancesProperties.getAppUrl(),daprInsurancesProperties.getAppId(),"/insuranceDetail/inner/updateOverdueByTask","", Void.class, SecurityConstants.FROM_IN);
		log.info("------------更新商险到期-定时任务结束------------");
	}

	/**
	 * 更新商险到期定时任务
	 *
	 * @author licancan
	 * @param
	 * @return void
	 */
	public void pushInsEkp() throws Exception {
		log.info("-------------推送商险待结算数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprInsurancesProperties.getAppUrl(),daprInsurancesProperties.getAppId(),"/insuranceDetail/inner/pushActualPremium","", Void.class, SecurityConstants.FROM_IN);
		log.info("------------推送商险待结算数据-定时任务结束------------");
	}
}
