package com.yifu.cloud.plus.v1.yifu.order.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author licancan
 * @description 订单表 t_order
 * @date 2022-08-26 17:20:16
 */
@Data
@TableName("t_order")
@Schema(description = "订单表")
public class TOrder implements Serializable {
    /**
     * 主键
     */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
    private String id;

    /**
     * 订单编号
     */
	@Schema(description = "订单编号")
    private String orderNo;

    /**
     * 客户名称
     */
	@Schema(description = "客户名称")
    private String customerName;

	/**
	 * 项目id
	 */
	@Schema(description = "项目id")
	private String deptId;

    /**
     * 项目名称
     */
	@Schema(description = "项目名称")
    private String deptName;

    /**
     * 项目编码
     */
	@Schema(description = "项目编码")
    private String deptNo;

    /**
     * 订单状态 0待办理 1办理中 2已办结
     */
	@Schema(description = "订单状态 0待办理 1办理中 2已办结")
    private Integer orderStatus;

    /**
     * 订单内容
     */
	@Schema(description = "订单内容")
    private String orderContent;

    /**
     * 创建人姓名（下单人）
     */
	@Schema(description = "创建人姓名（下单人）")
    private String createName;

    /**
     * 创建时间（下单时间）
     */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间（下单时间）")
    private LocalDateTime createTime;

    /**
     * 更新人
     */
	@Schema(description = "更新人")
    private String updateBy;

    /**
     * 更新人姓名
     */
	@Schema(description = "更新人姓名")
    private String updateName;

    /**
     * 更新时间
     */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "更新时间")
	@TableField(fill = FieldFill.UPDATE)
    private LocalDateTime updateTime;

    /**
     * 是否删除 0未删除/1删除
     */
	@Schema(description = "是否删除 0未删除/1删除")
    private Integer deleteFlag;

    private static final long serialVersionUID = 1L;

}