package com.yifu.cloud.plus.v1.yifu.order.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.web.multipart.MultipartFile;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author licancan
 * @description 订单新增vo
 * @date 2022-08-31 08:36:32
 */
@Data
public class OrderAddVO implements Serializable {
	private static final long serialVersionUID = 6620652346415180825L;

	/**
	 * 创建人姓名（下单人）
	 */
	@Schema(description = "创建人姓名（下单人）")
	private String createName;

	/**
	 * 创建时间（下单时间）
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间（下单时间）")
	private LocalDateTime createTime;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	private String deptName;

	/**
	 * 订单编号
	 */
	@Schema(description = "订单编号")
	private String orderNo;

	/**
	 * 客户名称
	 */
	@Schema(description = "客户名称")
	private String customerName;

	/**
	 * 订单状态 0待办理 1办理中 2已办结
	 */
	@Schema(description = "订单状态 0待办理 1办理中 2已办结")
	private Integer orderStatus;

	/**
	 * 订单内容
	 */
	@Schema(description = "订单内容")
	private String orderContent;

	/**
	 * 指派人（处理人）
	 */
	@Schema(description = "指派人（处理人）")
	private List<String> handleUserList;

	/**
	 * 附件
	 */
	@Schema(description = "附件")
	private MultipartFile[] file;
}
