package com.yifu.cloud.plus.v1.yifu.order.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.order.constants.OrderConstants;
import com.yifu.cloud.plus.v1.yifu.order.service.TOrderService;
import com.yifu.cloud.plus.v1.yifu.order.vo.OrderDetailVO;
import com.yifu.cloud.plus.v1.yifu.order.vo.OrderListParam;
import com.yifu.cloud.plus.v1.yifu.order.vo.OrderListVO;
import com.yifu.cloud.plus.v1.yifu.order.vo.OrderReplyListVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.List;

/**
 * @author licancan
 * @description 订单controller
 * @date 2022-08-29 09:05:23
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/order")
@Tag(name = "订单相关")
public class OrderController {
	@Resource
	private TOrderService tOrderService;

	/**
	 * 订单列表分页查询
	 *
	 * @author licancan
	 * @param page
	 * @param param
	 * @return {@link R<IPage<OrderListVO>>}
	 */
	@Operation(summary = "订单列表分页查询", description = "订单列表分页查询")
	@GetMapping("/getOrderPageList")
	public R<IPage<OrderListVO>> getOrderPageList(Page<OrderListParam> page, OrderListParam param) {
		return R.ok(tOrderService.getOrderPageList(page,param));
	}

	/**
	 * 订单列表不分页查询
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<List<OrderListVO>>}
	 */
	@Operation(summary = "订单列表不分页查询", description = "订单列表不分页查询")
	@GetMapping("/getOrderList")
	@PreAuthorize("@pms.hasPermission('order:order_getOrderList')")
	public R<List<OrderListVO>> getOrderList(OrderListParam param) {
		return tOrderService.getOrderList(param);
	}

	/**
	 * 变更订单状态
	 *
	 * @author licancan
	 * @param id
	 * @param status
	 * @return {@link R< String>}
	 */
	@GetMapping("/handleOrder")
	@Operation(summary = "变更订单状态", description = "变更订单状态")
	//@PreAuthorize("@pms.hasPermission('order:order_handleOrder')")
	public R<String> handleOrder(@RequestParam String id,@RequestParam Integer status) {
		return tOrderService.handleOrder(id,status);
	}

	/**
	 * 通过id查询详情
	 *
	 * @author licancan
	 * @param id 订单id
	 * @return {@link R<OrderDetailVO>}
	 */
	@Operation(summary = "通过id查询详情", description = "通过id查询详情")
	@GetMapping("/{id}")
	//@PreAuthorize("@pms.hasPermission('order:order_getOrderDetailById')")
	public R<OrderDetailVO> getOrderDetailById(@PathVariable("id") String id) {
		return tOrderService.getOrderDetailById(id);
	}

	/**
	 * 附件预览下载地址
	 *
	 * @author licancan
	 * @param id  附件表id
	 * @return {@link R}
	 */
	@Schema(description = "附件预览下载地址，附件表id")
	@GetMapping("/getEnclosureUrl/{id}")
	public R getEnclosureUrl(@PathVariable String id) {
		return tOrderService.getEnclosureUrl(id);
	}

	/**
	 * 添加回复
	 *
	 * @author licancan
	 * @param file 附件
	 * @param filePath 附件路径
	 * @param replyContent 回复内容
	 * @param orderNo 订单编号
	 * @return {@link R}
	 * @throws IOException
	 */
	@Schema(description = "添加回复")
	@PostMapping(value = "/uploadReplyEnclosure")
	@PreAuthorize("@pms.hasPermission('order:order_uploadReplyEnclosure')")
	public R uploadReplyEnclosure(@RequestBody MultipartFile[] file, String filePath, String replyContent,String orderNo) throws IOException {
		return tOrderService.uploadReplyEnclosure(file, filePath,replyContent,orderNo);
	}

	/**
	 * 订单回复列表分页查询
	 *
	 * @author licancan
	 * @param page
	 * @param orderNo
	 * @return {@link R<IPage< OrderReplyListVO>>}
	 */
	@Operation(summary = "订单回复列表分页查询", description = "订单回复列表分页查询")
	@GetMapping("/getOrderReplyPageList")
	public R<IPage<OrderReplyListVO>> getOrderReplyPageList(Page<OrderReplyListVO> page, String orderNo) {
		if (Common.isEmpty(orderNo)){
			return R.failed(OrderConstants.ORDER_NO_IS_EMPTY);
		}
		return R.ok(tOrderService.getOrderReplyPageList(page,orderNo));
	}

}
