/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * 审批记录表
 *
 * @author huyc
 * @date 2022-08-08 22:54:44
 */
@Data
@TableName("t_approval_record")
@EqualsAndHashCode()
@Schema(description = "审批记录表")
public class TApprovalRecord {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 实体id
	 */
	@ExcelAttribute(name = "实体id", isNotEmpty = true, errorInfo = "实体id不能为空", maxLength = 32)
	@NotBlank(message = "实体id不能为空")
	@Length(max = 32, message = "实体id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("实体id")
	private String salaryId;
	/**
	 * 节点id
	 */
	@ExcelAttribute(name = "节点id", maxLength = 32)
	@Length(max = 32, message = "节点id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("节点id")
	private String nodeId;
	/**
	 * 审核人id
	 */
	@ExcelAttribute(name = "审核人id", isNotEmpty = true, errorInfo = "审核人id不能为空", maxLength = 32)
	@NotBlank(message = "审核人id不能为空")
	@Length(max = 32, message = "审核人id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核人id")
	private String approvalMan;
	/**
	 * 审核人姓名
	 */
	@ExcelAttribute(name = "审核人姓名", isNotEmpty = true, errorInfo = "审核人姓名不能为空", maxLength = 50)
	@NotBlank(message = "审核人姓名不能为空")
	@Length(max = 50, message = "审核人姓名不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核人姓名")
	private String approvalManName;
	/**
	 * 审核时间
	 */
	@ExcelAttribute(name = "审核时间", isDate = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核时间")
	private Date approvalTime;
	/**
	 * 审核结果 0 通过 1不通过 2 待审核 3 已提交
	 */
	@ExcelAttribute(name = "审核结果 0 通过 1不通过 2 待审核 3 已提交", maxLength = 1)
	@Length(max = 1, message = "审核结果 0 通过 1不通过 2 待审核 3 已提交不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核结果 0 通过 1不通过 2 待审核 3 已提交")
	private String approvalResult;
	/**
	 * 审核意见
	 */
	@ExcelAttribute(name = "审核意见", maxLength = 500)
	@Length(max = 500, message = "审核意见不能超过500个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核意见")
	private String approvalOpinion;

}
