/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 统计-本期申报
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
@TableName("t_statistics_current_report")
@Schema(description = "统计-本期申报")
public class TStatisticsCurrentReport {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("id")
	private String id;
	/**
	 * 税务主体(封面抬头)
	 */
	@ExcelAttribute(name = "申报单位", maxLength = 50)
	@Length(max = 50, message = "申报单位不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报单位")
	private String invoiceTitle;
	/**
	 * 申报月份（YYYYMM）
	 */
	@ExcelAttribute(name = "申报月份", isNotEmpty = true, errorInfo = "申报月份（YYYYMM）不能为空", maxLength = 6)
	@NotBlank(message = "申报月份（YYYYMM）不能为空")
	@Length(max = 6, message = "申报月份（YYYYMM）不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报月份")
	private String declareMonth;
	/**
	 * 姓名
	 */
	@ExcelAttribute(name = "姓名", maxLength = 50)
	@Length(max = 50, message = "姓名不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号码", maxLength = 25)
	@Length(max = 25, message = "身份证号不能超过25个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号码")
	private String empIdcard;
	/**
	 * 本期收入
	 */
	@ExcelAttribute(name = "本期收入")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期收入")
	private BigDecimal realSalary;
	/**
	 * 本期应纳税额
	 */
	@ExcelAttribute(name = "本期应纳税额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期应纳税额")
	private BigDecimal salaryTax;
	/**
	 * 本期基本养老保险
	 */
	@ExcelAttribute(name = "本期基本养老保险")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期基本养老保险")
	private BigDecimal personalPensionMoney;
	/**
	 * 本期基本医疗保险
	 */
	@ExcelAttribute(name = "本期基本医疗保险")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期基本医疗保险")
	private BigDecimal personalMedicalMoney;
	/**
	 * 本期失业保险
	 */
	@ExcelAttribute(name = "本期失业保险")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期失业保险")
	private BigDecimal personalUnemploymentMoney;
	/**
	 * 本期住房公积金
	 */
	@ExcelAttribute(name = "本期住房公积金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期住房公积金")
	private BigDecimal personalProvidentFee;
	/**
	 * 本期企业年金
	 */
	@ExcelAttribute(name = "本期企业年金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期企业年金")
	private BigDecimal enterpriseAnnuity;
	/**
	 * 累计减除费用
	 */
	@ExcelAttribute(name = "累计减除费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计减除费用")
	private BigDecimal costReduction;
	/**
	 * 累计应纳税所得额
	 */
	@ExcelAttribute(name = "累计应纳税所得额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计应纳税所得额")
	private BigDecimal taxable;
	/**
	 * 累计子女教育
	 */
	@ExcelAttribute(name = "累计子女教育")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计子女教育")
	private BigDecimal childEduinfoMoney;
	/**
	 * 累计继续教育
	 */
	@ExcelAttribute(name = "累计继续教育")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计继续教育")
	private BigDecimal continuingEducationExpenseMoney;
	/**
	 * 累计住房贷款
	 */
	@ExcelAttribute(name = "累计住房贷款")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计住房贷款")
	private BigDecimal housingLoanInterestExpenseMoney;
	/**
	 * 累计住房租金
	 */
	@ExcelAttribute(name = "累计住房租金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计住房租金")
	private BigDecimal housingRentalinfoMoney;
	/**
	 * 累计赡养老人
	 */
	@ExcelAttribute(name = "累计赡养老人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计赡养老人")
	private BigDecimal supportElderlyExpenseMoney;
	/**
	 * 累计3岁以下婴幼儿照护
	 */
	@ExcelAttribute(name = "累计3岁以下婴幼儿照护")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计3岁以下婴幼儿照护")
	private BigDecimal sumBabyMoney;
	/**
	 * 是否当月新增人员
	 */
	@ExcelAttribute(name = "是否当月新增人员", readConverterExp = "0=否,1=是")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否当月新增人员")
	private String isNewEmployee;
	/**
	 * 入职年月
	 */
	@ExcelAttribute(name = "入职年月")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("入职年月")
	private String createMonth;
	/**
	 * 手机号码
	 */
	@ExcelAttribute(name = "手机号码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号码")
	private String empPhone;
	// 以下导出不需要

	/**
	 * 员工 ID
	 */
	@ExcelAttribute(name = "员工ID", maxLength = 32)
	@Length(max = 32, message = "员工 ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工ID")
	private String empId;
	/**
	 * 结算部门id
	 */
	@ExcelAttribute(name = "结算部门id", isNotEmpty = true, errorInfo = "结算部门id不能为空", maxLength = 32)
	@NotBlank(message = "结算部门id不能为空")
	@Length(max = 32, message = "结算部门id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算部门id")
	private String settleDepartId;
	/**
	 * 结算部门no
	 */
	@ExcelAttribute(name = "结算部门no", isNotEmpty = true, errorInfo = "结算部门no不能为空", maxLength = 50)
	@NotBlank(message = "结算部门no不能为空")
	@Length(max = 50, message = "结算部门no不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算部门no")
	private String settleDepartNo;
	/**
	 * 结算部门name
	 */
	@ExcelAttribute(name = "结算部门name", isNotEmpty = true, errorInfo = "结算部门name不能为空", maxLength = 50)
	@NotBlank(message = "结算部门name不能为空")
	@Length(max = 50, message = "结算部门name不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算部门name")
	private String settleDepartName;
	/**
	 * 个人社保
	 */
	@ExcelAttribute(name = "个人社保")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人社保")
	private BigDecimal personalSocial;

	/**
	 * 税率
	 */
	@ExcelAttribute(name = "税率")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("税率")
	private BigDecimal taxFee;
	/**
	 * 速算扣除
	 */
	@ExcelAttribute(name = "速算扣除")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("速算扣除")
	private BigDecimal quickDeducation;

	/**
	 * 单位id
	 */
	@ExcelAttribute(name = "单位id", maxLength = 32)
	@Length(max = 32, message = "单位id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位id")
	private String unitId;
	/**
	 * 单位no
	 */
	@ExcelAttribute(name = "单位no", maxLength = 50)
	@Length(max = 50, message = "单位no不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位no")
	private String unitNo;
	/**
	 * 单位name
	 */
	@ExcelAttribute(name = "单位name", maxLength = 50)
	@Length(max = 50, message = "单位name不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位name")
	private String unitName;
	/**
	 * 专项汇总
	 */
	@ExcelAttribute(name = "专项汇总")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("专项汇总")
	private BigDecimal specialDeduMoney;


}
