/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 全年一次性奖金申报表
 *
 * @author huyc
 * @date 2022-08-14 21:31:15
 */
@Data
public class TStatisticsBonusImportVo implements Serializable {

	/**
	 * 员工姓名
	 */
	@Length(max = 32, message = "员工姓名 不能超过32 个字符")
	@ExcelAttribute(name = "员工姓名", maxLength = 32)
	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@Length(max = 32, message = "身份证号 不能超过32 个字符")
	@ExcelAttribute(name = "身份证号", maxLength = 32)
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 待发年终奖
	 */
	@ExcelAttribute(name = "待发年终奖")
	@Schema(description = "待发年终奖")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("待发年终奖")
	private BigDecimal annualBonus;
	/**
	 * 待发12月工资
	 */
	@ExcelAttribute(name = "待发12月工资")
	@Schema(description = "待发12月工资")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("待发12月工资")
	private BigDecimal annualTSalary;
	/**
	 * 12月工资是否已经发放
	 */
	@ExcelAttribute(name = "12月工资是否已经发放")
	@Schema(description = "12月工资是否已经发放")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("12月工资是否已经发放")
	private String isTSend;
	/**
	 * 年终奖单独扣税12月税费
	 */
	@ExcelAttribute(name = "年终奖单独扣税12月税费")
	@Schema(description = "年终奖单独扣税12月税费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("年终奖单独扣税12月税费")
	private BigDecimal annualATax;
	/**
	 * 年终奖合并扣税12月税费
	 */
	@ExcelAttribute(name = "年终奖合并扣税12月税费")
	@Schema(description = "年终奖合并扣税12月税费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("年终奖合并扣税12月税费")
	private BigDecimal annualSTax;
	/**
	 * 最优方案-12月工资
	 */
	@ExcelAttribute(name = "最优方案-12月工资")
	@Schema(description = "最优方案-12月工资")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最优方案-12月工资")
	private BigDecimal bestPlanTSalary;
	/**
	 * 最优方案-年终奖
	 */
	@ExcelAttribute(name = "最优方案-年终奖")
	@Schema(description = "最优方案-年终奖")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最优方案-年终奖")
	private BigDecimal bestPlanBonus;
	/**
	 * 最优方案-12月扣税
	 */
	@ExcelAttribute(name = "最优方案-12月扣税")
	@Schema(description = "最优方案-12月扣税")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最优方案-12月扣税")
	private BigDecimal bestPlanTax;
	/**
	 * 12月份应纳税所得额扣除费用
	 */
	@ExcelAttribute(name = "12月份应纳税所得额扣除费用")
	@Schema(description = "12月份应纳税所得额扣除费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("12月份应纳税所得额扣除费用")
	private BigDecimal deductTaxSalary;


}
