/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * 申报对象表
 *
 * @author huyc
 * @date 2022-08-11 10:56:10
 */
@Data
public class TStatisticsDeclarerVo extends RowIndex implements Serializable {

	/**
	 * 申报月份
	 */
	@ExcelAttribute(name = "申报月份", isNotEmpty = true, errorInfo = "申报月份 不能为空", maxLength = 6,min = 6)
	@Schema(description = "申报月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报月份")
	private String declareMonth;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "姓名", maxLength = 20, isNotEmpty = true)
	@Schema(description = "姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", maxLength = 20, isNotEmpty = true)
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 本月是否申报
	 */
	@ExcelAttribute(name = "本期是否申报", maxLength = 1, isNotEmpty = true,readConverterExp = "0=是,1=否")
	@Schema(description = "本期是否申报")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期是否申报")
	private String isDeclare;
	/**
	 * 不申报原因
	 */
	@ExcelAttribute(name = "不申报原因", maxLength = 200)
	@Schema(description = "不申报原因")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("不申报原因")
	private String undeclareReason;

}
