/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 统计-工资薪金
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TStatisticsTaxSalaryVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("id")
	private String id;
	/**
	 * 税务主体(封面抬头)
	 */
	@Length(max = 50, message = "税务主体(封面抬头) 不能超过50 个字符")
	@ExcelAttribute(name = "税务主体(封面抬头)", maxLength = 50)
	@Schema(description = "税务主体(封面抬头)")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("税务主体(封面抬头)")
	private String invoiceTitle;
	/**
	 * 结算部门id
	 */
	@NotBlank(message = "结算部门id 不能为空")
	@Length(max = 32, message = "结算部门id 不能超过32 个字符")
	@ExcelAttribute(name = "结算部门id", isNotEmpty = true, errorInfo = "结算部门id 不能为空", maxLength = 32)
	@Schema(description = "结算部门id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算部门id")
	private String settleDepartId;
	/**
	 * 结算部门no
	 */
	@NotBlank(message = "结算部门no 不能为空")
	@Length(max = 50, message = "结算部门no 不能超过50 个字符")
	@ExcelAttribute(name = "结算部门no", isNotEmpty = true, errorInfo = "结算部门no 不能为空", maxLength = 50)
	@Schema(description = "结算部门no")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算部门no")
	private String settleDepartNo;
	/**
	 * 结算部门name
	 */
	@NotBlank(message = "结算部门name 不能为空")
	@Length(max = 50, message = "结算部门name 不能超过50 个字符")
	@ExcelAttribute(name = "结算部门name", isNotEmpty = true, errorInfo = "结算部门name 不能为空", maxLength = 50)
	@Schema(description = "结算部门name")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算部门name")
	private String settleDepartName;
	/**
	 * 申报月份（YYYYMM）
	 */
	@NotBlank(message = "申报月份（YYYYMM） 不能为空")
	@Length(max = 6, message = "申报月份（YYYYMM） 不能超过6 个字符")
	@ExcelAttribute(name = "申报月份（YYYYMM）", isNotEmpty = true, errorInfo = "申报月份（YYYYMM） 不能为空", maxLength = 6)
	@Schema(description = "申报月份（YYYYMM）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报月份（YYYYMM）")
	private String declareMonth;
	/**
	 * 员工 ID
	 */
	@Length(max = 32, message = "员工 ID 不能超过32 个字符")
	@ExcelAttribute(name = "员工 ID", maxLength = 32)
	@Schema(description = "员工 ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工 ID")
	private String empId;
	/**
	 * 姓名
	 */
	@Length(max = 50, message = "姓名 不能超过50 个字符")
	@ExcelAttribute(name = "姓名", maxLength = 50)
	@Schema(description = "姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@Length(max = 25, message = "身份证号 不能超过25 个字符")
	@ExcelAttribute(name = "身份证号", maxLength = 25)
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 累计减除费用
	 */
	@ExcelAttribute(name = "累计减除费用")
	@Schema(description = "累计减除费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计减除费用")
	private BigDecimal costReduction;
	/**
	 * 累计子女教育
	 */
	@ExcelAttribute(name = "累计子女教育")
	@Schema(description = "累计子女教育")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计子女教育")
	private BigDecimal childEduinfoMoney;
	/**
	 * 累计住房租金
	 */
	@ExcelAttribute(name = "累计住房租金")
	@Schema(description = "累计住房租金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计住房租金")
	private BigDecimal housingRentalinfoMoney;
	/**
	 * 累计住房贷款
	 */
	@ExcelAttribute(name = "累计住房贷款")
	@Schema(description = "累计住房贷款")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计住房贷款")
	private BigDecimal housingLoanInterestExpenseMoney;
	/**
	 * 累计赡养老人
	 */
	@ExcelAttribute(name = "累计赡养老人")
	@Schema(description = "累计赡养老人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计赡养老人")
	private BigDecimal supportElderlyExpenseMoney;
	/**
	 * 累计继续教育
	 */
	@ExcelAttribute(name = "累计继续教育")
	@Schema(description = "累计继续教育")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计继续教育")
	private BigDecimal continuingEducationExpenseMoney;
	/**
	 * 累计应发
	 */
	@ExcelAttribute(name = "累计应发")
	@Schema(description = "累计应发")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计应发")
	private BigDecimal realSalary;
	/**
	 * 累计基本养老
	 */
	@ExcelAttribute(name = "累计基本养老")
	@Schema(description = "累计基本养老")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计基本养老")
	private BigDecimal personalPensionMoney;
	/**
	 * 累计基本医疗
	 */
	@ExcelAttribute(name = "累计基本医疗")
	@Schema(description = "累计基本医疗")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计基本医疗")
	private BigDecimal personalMedicalMoney;
	/**
	 * 累计失业
	 */
	@ExcelAttribute(name = "累计失业")
	@Schema(description = "累计失业")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计失业")
	private BigDecimal personalUnemploymentMoney;
	/**
	 * 个人社保
	 */
	@ExcelAttribute(name = "个人社保")
	@Schema(description = "个人社保")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人社保")
	private BigDecimal personalSocial;
	/**
	 * 个人公积金
	 */
	@ExcelAttribute(name = "个人公积金")
	@Schema(description = "个人公积金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金")
	private BigDecimal personalFund;
	/**
	 * 累计企业年金
	 */
	@ExcelAttribute(name = "累计企业年金")
	@Schema(description = "累计企业年金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计企业年金")
	private BigDecimal enterpriseAnnuity;
	/**
	 * 累计应纳税所得
	 */
	@ExcelAttribute(name = "累计应纳税所得")
	@Schema(description = "累计应纳税所得")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计应纳税所得")
	private BigDecimal taxable;
	/**
	 * 税率
	 */
	@ExcelAttribute(name = "税率")
	@Schema(description = "税率")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("税率")
	private BigDecimal taxFee;
	/**
	 * 速算扣除
	 */
	@ExcelAttribute(name = "速算扣除")
	@Schema(description = "速算扣除")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("速算扣除")
	private BigDecimal quickDeducation;
	/**
	 * 累计应纳税额
	 */
	@ExcelAttribute(name = "累计应纳税额")
	@Schema(description = "累计应纳税额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计应纳税额")
	private BigDecimal salaryTax;
	/**
	 * 单位id
	 */
	@Length(max = 32, message = "单位id 不能超过32 个字符")
	@ExcelAttribute(name = "单位id", maxLength = 32)
	@Schema(description = "单位id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位id")
	private String unitId;
	/**
	 * 单位no
	 */
	@Length(max = 50, message = "单位no 不能超过50 个字符")
	@ExcelAttribute(name = "单位no", maxLength = 50)
	@Schema(description = "单位no")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位no")
	private String unitNo;
	/**
	 * 单位name
	 */
	@Length(max = 50, message = "单位name 不能超过50 个字符")
	@ExcelAttribute(name = "单位name", maxLength = 50)
	@Schema(description = "单位name")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位name")
	private String unitName;
	/**
	 * 专项汇总
	 */
	@ExcelAttribute(name = "专项汇总")
	@Schema(description = "专项汇总")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("专项汇总")
	private BigDecimal specialDeduMoney;
	/**
	 * 累计婴幼儿照护费用
	 */
	@ExcelAttribute(name = "累计婴幼儿照护费用")
	@Schema(description = "累计婴幼儿照护费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计婴幼儿照护费用")
	private BigDecimal sumBabyMoney;

}
