package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.service.SalaryUploadService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryDetailVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 标准薪酬上传
 *
 * @author hgw
 * @date 2019-9-4 11:59:33
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/salary")
@Tag(name = "标准薪酬上传")
public class SalaryUploadController {

	private final SalaryUploadService salaryUploadService;

	/**
	 * @param jsonString   Excel表-JsonString
	 * @param settleDepart 结算主体id
	 * @param configId     配置方案id
	 * @param salaryType   报表类型id
	 * @Description:
	 * @Author: hgw
	 * @Date: 2019/9/11 15:21
	 * @return: com.yifu.cloud.v1.common.core.util.R
	 **/
	@Operation(description = "上传：jsonString：表格json；settleDepart：结算主体id；configId：工资配置结算月等信息的id；salaryType：工资类型")
	@SysLog("上传薪资表")
	@PostMapping("/upload")
	public R<List<ErrorMessage>> upload(@RequestBody String jsonString, @RequestParam String settleDepart, @RequestParam(required = false) String configId
			, @RequestParam String salaryType, @RequestParam(required = false) String orderId) {
		return salaryUploadService.salaryUpload(jsonString, settleDepart, configId, salaryType, orderId);
	}

	@Operation(description = "打开结算单")
	@SysLog("打开结算单")
	@PostMapping("openBill")
	public R<TSalaryDetailVo> openBill(@RequestParam String salaryFormId) {
		return salaryUploadService.getBill(salaryFormId);
	}

}
