package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccountItem;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 工资报账表附加-工资明细
 *
 * @author hgw
 * @date 2019-07-30 15:00:05
 */
public interface TSalaryAccountItemService extends IService<TSalaryAccountItem> {
	/**
	 * @param settleDepartId
	 * @param settleMonth
	 * @param javaFiedName
	 * @param finallyYear  年终奖所在的结算年
	 * @Description: 获取报账详情信息
	 * @Author: hgw
	 * @Date: 2019/9/29 18:26
	 * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSalaryAccountItem>
	 **/
	List<TSalaryAccountItem> getAllTSalaryAccountItem(String settleDepartId, String settleMonth, String javaFiedName,
													  String finallyYear, String empIdcard, String accountId);

	/**
	 * @param idCardList
	 * @param invoiceTitle
	 * @Description: 获取所有报账，组装map，工资导入使用
	 * @Author: hgw
	 * @Date: 2022/1/27 17:25
	 * @return: java.util.Map<java.lang.String, java.util.List < com.yifu.cloud.v1.hrms.api.entity.TSalaryAccountItem>>
	 **/
	Map<String, List<TSalaryAccountItem>> getAllItemVoList(List<String> idCardList, String invoiceTitle);

	/**
	 * @param idCardList
	 * @param invoiceTitle
	 * @Description: 获取所有工资报账，组装map，计算年终奖使用
	 * @Author: huyc
	 * @Date: 2022/1/27 17:25
	 * @return: java.util.Map<java.lang.String, java.util.List < com.yifu.cloud.v1.hrms.api.entity.TSalaryAccountItem>>
	 **/
	Map<String, List<TSalaryAccountItem>> getSalaryItemVoList(List<String> idCardList, String invoiceTitle);

     /**
      * 工资报账表附加-工资明细简单分页查询
      *
      * @param tSalaryAccountItem 工资报账表附加-工资明细
      * @return
      */
     IPage<TSalaryAccountItem> getTSalaryAccountItemPage(Page<TSalaryAccountItem> page, TSalaryAccountItem tSalaryAccountItem);

     List<TSalaryAccountItem> getTSalaryAccountItemNoPage(TSalaryAccountItem tSalaryAccountItem);

     /**
      * @param idCard
      * @param maxYearMonth
      * @param invoiceTitle
      * @Description: 获取员工所有报账，累计扣税
      * @Author: hgw
      * @Date: 2019/9/30 18:19
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSalaryAccountItem>
      **/
     List<TSalaryAccountItem> getEmpAllSalaryAccountItem(String idCard, String maxYearMonth, String invoiceTitle);


     /**
      * @param settleDepartId 结算主体id
      * @param javaFiedName   属性名
      * @param salaryDate     工资月
      * @param empIdcard      身份证
      * @Description: 获取前几个月平均工资
      * @Author: hgw
      * @Date: 2019/10/29 16:51
      * @return: java.math.BigDecimal
      **/
     BigDecimal getAverageSalary(String settleDepartId, String javaFiedName, String salaryDate, String empIdcard);

     /**
      * @param accountId    结算主体id
      * @param javaFiedName 属性名
      * @Description: 获取前几个月平均工资
      * @Author: pwang
      * @Date: 2019/11/06 16:51
      * @return: java.math.BigDecimal
      **/
     BigDecimal getAllMoneyByAccountIdAndFiedName(String accountId, String javaFiedName);

     /**
      * @param accountId    报账id
      * @param javaFiedName 属性名
      * @Description: 获取报账表相关金额
      * @Author: hgw
      * @Date: 2019/11/22 18:19
      * @return: java.math.BigDecimal
      **/
     BigDecimal getMoneyByAccountIdAndJavaFiedName(String accountId, String javaFiedName);

     List<TSalaryAccountItem> getAccountItemList(TSalaryAccount tSalaryAccount, String createUserId, Integer userDeptId
             , String unitName, String idStr, String settleMonthStart, String settleMonthEnd);

     List<Map<String,Object>> getSumByAccountId(List<TSalaryAccount> account);

     /**
      * @param salaryId
      * @Description: 获取工资明细
      * @Author: hgw
      * @Date: 2021/9/30 18:05
      * @return: java.util.Set<java.lang.String>
      **/
     Set<String> getItemSet(String salaryId);

}