/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpSalaryParamVo;
import com.yifu.cloud.plus.v1.yifu.salary.entity.THaveSalaryNosocial;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryAccountSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 工资报账主表（工资条）
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
public interface TSalaryAccountService extends IService<TSalaryAccount> {
    /**
     * 工资报账主表（工资条）简单分页查询
     * @param tSalaryAccount 工资报账主表（工资条）
     * @return
     */
    IPage<TSalaryAccount> getTSalaryAccountPage(Page<TSalaryAccount> page, TSalaryAccountSearchVo tSalaryAccount);

    void listExport(HttpServletResponse response, TSalaryAccountSearchVo searchVo);

	/**
	 * @param salaryId
	 * @Description: 根据工资id，返回报账明细（字段较少且有计算，其他地方勿用）
	 * @Author: hgw
	 * @Date: 2022/9/2 16:48
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount>
	 **/
	List<TSalaryAccount> getListByIncome(String salaryId);

    List<TSalaryAccount> noPageDiy(TSalaryAccountSearchVo searchVo);

	/**
	 * @param searchVo
	 * @Description: 无需权限仅按照工资id查询报账
	 * @Author: hgw
	 * @Date: 2022/10/24 16:36
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount>
	 **/
	List<TSalaryAccount> getAccountListBySalaryId(TSalaryAccountSearchVo searchVo);

	/**
	 * @param settleId
	 * @param settleMonth
	 * @Description: 版本2.6.6判重：对同一“结算主体”、同一“结算月份”、同一“报表类型”、同一“工资月份”、同一“身份证号”、同一“应发金额”进行校验
	 *  校验导入数据重复的Map格式：#身份证号_工资月份_报表类型_应发金额
	 * @Author: hgw
	 * @Date: 2021/9/17 18:06
	 * @return: java.util.Map<java.lang.String, java.lang.Integer>
	 **/
	Map<String, Integer> getAccountCheckMap(String settleId, String settleMonth, String salaryType);

	Map<String, BigDecimal> getAccountSpecialMap(String invoiceTitle, String unitId, String salaryMonth);

	/**
	 * @param empIdCard
	 * @param nowYear
	 * @Description: 获取当前年最小计税月
	 * @Author: hgw
	 * @Date: 2022/1/19 17:57
	 * @return: java.lang.String
	 **/
	String getMinTaxMonthByNowYear(String empIdCard, int nowYear);

	/**
	 * @Author fxj
	 * @Description 获取有工资无社保数据  3个月的工资
	 * @Date 17:21 2022/8/16
	 * @Param
	 * @return
	**/
	List<THaveSalaryNosocial> getLastMonthTHaveSalaryNosocial(String month);

	/**
	 * @Description: 薪资类型互斥校验 获取本年度身份证号列表
	 * @Author: huyc
	 * @Date: 2022/8/18
	 * @return:
	 **/
	List<String> getAccountYearCheckMap();

	/**
	 * @param salaryId
	 * @Description: 获取薪资数据
	 * @Author: hgw
	 * @Date: 2022/8/29 16:54
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpSalaryParam>
	 **/
	List<EkpSalaryParamVo> getEkpSalaryParamList(String salaryId);
}
