package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TMinSalary;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TMinSalaryMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TMinSalaryService;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * @Author fxj
 * @Description 各地市最低工资标准
 * @Date 13:17 2022/8/6
 * @Param
 * @return
**/
@Service("tMinSalaryService")
public class TMinSalaryServiceImpl extends ServiceImpl<TMinSalaryMapper, TMinSalary> implements TMinSalaryService {

  /**
   * 各地市最低工资标准简单分页查询
   * @param tMinSalary 各地市最低工资标准
   * @return
   */
  @Override
  public IPage<TMinSalary> getTMinSalaryPage(Page<TMinSalary> page, TMinSalary tMinSalary){
      return baseMapper.getTMinSalaryPage(page,tMinSalary);
  }

	@Override
	public R<Boolean> saveDiy(TMinSalary tMinSalary) {
		YifuUser user = SecurityUtils.getUser();
		if (null == user || null == user.getId()) {
			return R.failed("获取登录用户信息失败！");
		}
		tMinSalary.setCreateTime(LocalDateTime.now());
		tMinSalary.setCreateBy(String.valueOf(user.getId()));
		LambdaQueryWrapper<TMinSalary> query = new LambdaQueryWrapper<>();
		if (Common.isNotNull(tMinSalary.getProvince())){
			query.eq(TMinSalary::getProvince,tMinSalary.getProvince());
		}
		if (Common.isNotNull(tMinSalary.getCity())){
			query.eq(TMinSalary::getCity,tMinSalary.getCity());
		}
		if (Common.isNotNull(tMinSalary.getTown())){
			query.eq(TMinSalary::getTown,tMinSalary.getTown());
		}
		if (Common.isEmpty(tMinSalary.getTown())){
			query.isNull(TMinSalary::getTown);
		}
		long res = baseMapper.selectCount(query);
		if (res >  CommonConstants.ZERO_INT){
			return R.failed("已存在对应区域在用的配置信息");
		}
		baseMapper.insert(tMinSalary);
		return R.ok(true,CommonConstants.SAVE_SUCCESS);
	}

	@Override
	public R<Boolean> updateByIdDIy(TMinSalary tMinSalary) {
		YifuUser user = SecurityUtils.getUser();
		if (null == user || null == user.getId()) {
			return R.failed("获取登录用户信息失败！");
		}
		TMinSalary entity = baseMapper.selectById(tMinSalary.getId());
		if (Common.isNotNull(entity)){
			LambdaQueryWrapper<TMinSalary> query = new LambdaQueryWrapper<>();
			if (Common.isNotNull(tMinSalary.getProvince())){
				query.eq(TMinSalary::getProvince,tMinSalary.getProvince());
			}
			if (Common.isNotNull(tMinSalary.getCity())){
				query.eq(TMinSalary::getCity,tMinSalary.getCity());
			}
			if (Common.isNotNull(tMinSalary.getTown())){
				query.eq(TMinSalary::getTown,tMinSalary.getTown());
			}
			if (Common.isEmpty(tMinSalary.getTown())){
				query.isNull(TMinSalary::getTown);
			}
			query.ne(TMinSalary::getId,tMinSalary.getId());
			long res = baseMapper.selectCount(query);
			if (res >  CommonConstants.ZERO_INT){
				return R.failed("已存在对应区域在用的配置信息");
			}
			baseMapper.updateById(tMinSalary);
			return R.ok(true,CommonConstants.UPDATE_SUCCESS);
		}else {
			return R.failed(false,CommonConstants.SAVE_FAILED);
		}
	}

}
