package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.salary.constants.SalaryConstants;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccountItem;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TSalaryAccountItemMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryAccountItemService;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * 工资报账表附加-工资明细
 *
 * @author hgw
 * @date 2019-07-30 15:00:05
 */
@Service("tSalaryAccountItemService")
public class TSalaryAccountItemServiceImpl extends ServiceImpl<TSalaryAccountItemMapper, TSalaryAccountItem> implements TSalaryAccountItemService {

     /**
      * 工资报账表附加-工资明细简单分页查询
      *
      * @param tSalaryAccountItem 工资报账表附加-工资明细
      * @return
      */
     @Override
     public IPage<TSalaryAccountItem> getTSalaryAccountItemPage(Page<TSalaryAccountItem> page, TSalaryAccountItem tSalaryAccountItem) {
          return baseMapper.getTSalaryAccountItemPage(page, tSalaryAccountItem);
     }

     /**
      * 工资报账表附加-工资明细简单分页查询
      *
      * @param tSalaryAccountItem 工资报账表附加-工资明细
      * @return
      */
     @Override
     public List<TSalaryAccountItem> getTSalaryAccountItemNoPage(TSalaryAccountItem tSalaryAccountItem) {
          return baseMapper.getTSalaryAccountItemPage(tSalaryAccountItem);
     }

     /**
      * @param settleDepartId
      * @param settleMonth
      * @param javaFiedName
      * @Description: 获取报账详情信息
      * @Author: hgw
      * @Date: 2019/9/29 18:26
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSalaryAccountItem>
      **/
     @Override
     public List<TSalaryAccountItem> getAllTSalaryAccountItem(String settleDepartId, String settleMonth, String javaFiedName,
                                                              String finallyYear, String empIdcard, String accountId) {
          return baseMapper.getAllTSalaryAccountItem(settleDepartId, settleMonth, javaFiedName, finallyYear, empIdcard, accountId);
     }

     /**
      * @param idCard       身份证
      * @param maxYearMonth 最大年月
      * @param invoiceTitle 封面抬头
      * @Description:
      * @Author: hgw
      * @Date: 2019/10/29 16:51
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSalaryAccountItem>
      **/
     @Override
     public List<TSalaryAccountItem> getEmpAllSalaryAccountItem(String idCard, String maxYearMonth, String invoiceTitle) {
          return baseMapper.getEmpAllSalaryAccountItem(idCard, maxYearMonth, invoiceTitle);
     }

     /**
      * @param idCardList
      * @param invoiceTitle
      * @Description: 获取所有报账，组装map，工资导入使用
      * @Author: hgw
      * @Date: 2022/1/27 17:25
      * @return: java.util.Map<java.lang.String, java.util.List < com.yifu.cloud.v1.hrms.api.entity.TSalaryAccountItem>>
      **/
     @Override
     public Map<String, List<TSalaryAccountItem>> getAllItemVoList(List<String> idCardList, String invoiceTitle) {
          List<TSalaryAccountItem> list = baseMapper.getAllItemVoList(idCardList, invoiceTitle);
          Map<String, List<TSalaryAccountItem>> itemMap = new HashMap<>();
          if (list != null && !list.isEmpty()) {
               List<TSalaryAccountItem> voList;
               for (TSalaryAccountItem item : list) {
                    voList = itemMap.get(item.getEmpIdcard());
                    if (voList == null) {
                         voList = new ArrayList<>();
                    }
                    voList.add(item);
                    itemMap.put(item.getEmpIdcard(), voList);
               }
          }
          return itemMap;
     }

	/**
	 * @param idCardList
	 * @param invoiceTitle
	 * @Description: 获取所有工资报账，组装map，计算年终奖使用
	 * @Author: hgw
	 * @Date: 2022/1/27 17:25
	 * @return: java.util.Map<java.lang.String, java.util.List < com.yifu.cloud.v1.hrms.api.entity.TSalaryAccountItem>>
	 **/
	@Override
	public Map<String, List<TSalaryAccountItem>> getSalaryItemVoList(List<String> idCardList, String invoiceTitle) {
		List<TSalaryAccountItem> list = baseMapper.getSalaryItemVoList(idCardList, invoiceTitle);
		Map<String, List<TSalaryAccountItem>> itemMap = new HashMap<>();
		if (list != null && !list.isEmpty()) {
			List<TSalaryAccountItem> voList;
			for (TSalaryAccountItem item : list) {
				voList = itemMap.get(item.getEmpIdcard());
				if (voList == null) {
					voList = new ArrayList<>();
				}
				voList.add(item);
				itemMap.put(item.getEmpIdcard(), voList);
			}
		}
		return itemMap;
	}

     /**
      * @param settleDepartId 结算主体id
      * @param javaFiedName   属性名
      * @param salaryDate     工资月
      * @param empIdcard      身份证
      * @Description: 获取前几个月平均工资
      * @Author: hgw
      * @Date: 2019/10/29 16:51
      * @return: java.math.BigDecimal
      **/
     @Override
     public BigDecimal getAverageSalary(String settleDepartId, String javaFiedName, String salaryDate, String empIdcard) {
          BigDecimal allMoney = baseMapper.getAllMoney(settleDepartId, javaFiedName, salaryDate, empIdcard);
          Integer monthNum = baseMapper.getAverageSalaryItemMonthCount(settleDepartId, javaFiedName, salaryDate, empIdcard);
          //工资报账明细里没找到，到工程工资里找
          if (allMoney == null || allMoney.compareTo(SalaryConstants.B_ZERO) == SalaryConstants.EQUAL
                  || monthNum == null || monthNum == 0) {
               allMoney = baseMapper.getEngineerAllMoney(settleDepartId, javaFiedName, salaryDate, empIdcard);
               monthNum = baseMapper.getEngineerAverageSalaryItemMonthCount(settleDepartId, javaFiedName, salaryDate, empIdcard);
          }
          //计算平均工资
          if (allMoney != null && allMoney.compareTo(SalaryConstants.B_ZERO) == SalaryConstants.MORE_THAN
                  && monthNum != null && monthNum > CommonConstants.ZERO_INT) {
               allMoney = allMoney.divide(new BigDecimal(monthNum), 2, BigDecimal.ROUND_HALF_UP);
          }
          return allMoney;
     }

     /**
      * @param accountId    结算主体id
      * @param javaFiedName 属性名
      * @Description: 获取前几个月平均工资
      * @Author: pwang
      * @Date: 2019/11/06 16:51
      * @return: java.math.BigDecimal
      **/
     @Override
     public BigDecimal getAllMoneyByAccountIdAndFiedName(String accountId, String javaFiedName) {
          return baseMapper.getAllMoneyByAccountIdAndFiedName(accountId, javaFiedName);
     }

     /**
      * @param accountId    报账id
      * @param javaFiedName 属性名
      * @Description: 获取报账表相关金额
      * @Author: hgw
      * @Date: 2019/11/22 18:19
      * @return: java.math.BigDecimal
      **/
     @Override
     public BigDecimal getMoneyByAccountIdAndJavaFiedName(String accountId, String javaFiedName) {
          return baseMapper.getMoneyByAccountIdAndJavaFiedName(accountId, javaFiedName);
     }

     @Override
     public List<TSalaryAccountItem> getAccountItemList(TSalaryAccount tSalaryAccount, String createUserId, Integer userDeptId
             , String unitName, String idStr, String settleMonthStart, String settleMonthEnd) {
          return baseMapper.getAccountItemList(tSalaryAccount, createUserId, userDeptId, unitName, idStr
                  , settleMonthStart, settleMonthEnd);
     }

     @Override
     public List<Map<String,Object>> getSumByAccountId(List<TSalaryAccount> account) {
          return baseMapper.getSumByAccountId(account);
     }


     /**
      * @param salaryId
      * @Description: 获取工资明细
      * @Author: hgw
      * @Date: 2021/9/30 18:05
      * @return: java.util.Set<java.lang.String>
      **/
     @Override
     public Set<String> getItemSet(String salaryId) {
          return baseMapper.getItemSet(salaryId);
     }
}
