package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryTaxConfig;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TSalaryTaxConfigMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryTaxConfigService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Author fxj
 * @Description 个税比例及速算扣除数的配置表
 * @Date 13:19 2022/8/6
 * @Param
 * @return
**/
@Service("tSalaryTaxConfigService")
public class TSalaryTaxConfigServiceImpl extends ServiceImpl<TSalaryTaxConfigMapper, TSalaryTaxConfig> implements TSalaryTaxConfigService {

     /**
      * 个税比例及速算扣除数的配置表简单分页查询
      *
      * @param tSalaryTaxConfig 个税比例及速算扣除数的配置表
      * @return
      */
     @Override
     public IPage<TSalaryTaxConfig> getTSalaryTaxConfigPage(Page<TSalaryTaxConfig> page, TSalaryTaxConfig tSalaryTaxConfig) {
          return baseMapper.getTSalaryTaxConfigPage(page, tSalaryTaxConfig);
     }

     /**
      * @param tSalaryTaxConfig
      * @Description: 获取个税配置
      * @Author: hgw
      * @Date: 2019/10/8 14:39
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSalaryTaxConfig>
      **/
     @Override
     public List<TSalaryTaxConfig> getTaxConfigByPersonList(TSalaryTaxConfig tSalaryTaxConfig) {
          return baseMapper.getTaxConfigByPersonList(tSalaryTaxConfig);
     }

     /**
      * @param tSalaryTaxConfig
      * @Description: 获取年终奖配置
      * @Author: hgw
      * @Date: 2019/10/8 14:40
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSalaryTaxConfig>
      **/
     @Override
     public List<TSalaryTaxConfig> getTaxConfigByAnnualBonusList(TSalaryTaxConfig tSalaryTaxConfig) {
          return baseMapper.getTaxConfigByAnnualBonusList(tSalaryTaxConfig);
     }

}
