/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ExcelUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsCurrentReport;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TStatisticsCurrentReportMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TStatisticsCurrentReportService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TStatisticsCurrentReportSearchVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

/**
 * 统计-本期申报
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Log4j2
@Service
public class TStatisticsCurrentReportServiceImpl extends ServiceImpl<TStatisticsCurrentReportMapper, TStatisticsCurrentReport> implements TStatisticsCurrentReportService {
	/**
	 * 统计-本期申报简单分页查询
	 *
	 * @param tStatisticsCurrentReport 统计-本期申报
	 * @return
	 */
	@Override
	public IPage<TStatisticsCurrentReport> getTStatisticsCurrentReportPage(Page<TStatisticsCurrentReport> page, TStatisticsCurrentReportSearchVo tStatisticsCurrentReport) {
		return baseMapper.getTStatisticsCurrentReportPage(page, tStatisticsCurrentReport);
	}

	/**
	 * 统计-本期申报批量导出
	 *
	 * @return
	 */
	@Override
	public void listExport(HttpServletResponse response, TStatisticsCurrentReportSearchVo searchVo) {
		String fileName = "本期申报批量导出" + DateUtil.getThisTime() + CommonConstants.XLSX;
		//获取要导出的列表
		List<TStatisticsCurrentReport> list = new ArrayList<>();
		long count = noPageCountDiy(searchVo);
		ServletOutputStream out = null;
		try {
			out = response.getOutputStream();
			response.setContentType(CommonConstants.MULTIPART_FORM_DATA);
			response.setCharacterEncoding("utf-8");
			response.setHeader(CommonConstants.CONTENT_DISPOSITION, CommonConstants.ATTACHMENT_FILENAME + URLEncoder.encode(fileName, "UTF-8"));
			// 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			ExcelWriter excelWriter = EasyExcel.write(out, TStatisticsCurrentReport.class).includeColumnFiledNames(searchVo.getExportFields()).build();
			int index = 0;
			if (count > CommonConstants.ZERO_INT) {
				for (int i = 0; i <= count; ) {
					// 获取实际记录
					searchVo.setLimitStart(i);
					searchVo.setLimitEnd(CommonConstants.EXCEL_EXPORT_LIMIT);
					list = noPageDiy(searchVo);
					if (Common.isNotNull(list)) {
						ExcelUtil<TStatisticsCurrentReport> util = new ExcelUtil<>(TStatisticsCurrentReport.class);
						for (TStatisticsCurrentReport vo : list) {
							util.convertEntity(vo, null, null, null);
						}
					}
					if (Common.isNotNull(list)) {
						WriteSheet writeSheet = EasyExcel.writerSheet("本期申报" + index).build();
						excelWriter.write(list, writeSheet);
						index++;
					}
					i = i + CommonConstants.EXCEL_EXPORT_LIMIT;
					if (Common.isNotNull(list)) {
						list.clear();
					}
				}
			} else {
				WriteSheet writeSheet = EasyExcel.writerSheet("本期申报" + index).build();
				excelWriter.write(list, writeSheet);
			}
			if (Common.isNotNull(list)) {
				list.clear();
			}
			out.flush();
			excelWriter.finish();
		} catch (Exception e) {
			log.error("执行异常", e);
		} finally {
			try {
				if (null != out) {
					out.close();
				}
			} catch (IOException e) {
				log.error("执行异常", e);
			}
		}
	}

	private List<TStatisticsCurrentReport> noPageDiy(TStatisticsCurrentReportSearchVo searchVo) {
		LambdaQueryWrapper<TStatisticsCurrentReport> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TStatisticsCurrentReport::getId, idList);
		}
		if (searchVo.getLimitStart() >= 0 && searchVo.getLimitEnd() > 0) {
			wrapper.last(" limit " + searchVo.getLimitStart() + "," + searchVo.getLimitEnd());
		}
		return baseMapper.selectList(wrapper);
	}

	private Long noPageCountDiy(TStatisticsCurrentReportSearchVo searchVo) {
		LambdaQueryWrapper<TStatisticsCurrentReport> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TStatisticsCurrentReport::getId, idList);
		}
		return baseMapper.selectCount(wrapper);
	}

	private LambdaQueryWrapper buildQueryWrapper(TStatisticsCurrentReportSearchVo entity) {
		LambdaQueryWrapper<TStatisticsCurrentReport> wrapper = Wrappers.lambdaQuery(entity);
		return wrapper;
	}

	@Override
	public int deleteByYearMonth(String yearMonth) {
		return baseMapper.deleteByYearMonth(yearMonth);
	}

	@Override
	public R<String> doRefreshStatisticsCurrentReport(String declareMonth, String lastMonth, String lastTwoMonth) {
		int firstDelete = baseMapper.deleteByYearMonth(declareMonth);
		if (firstDelete != -2) {
			String mons = declareMonth.substring(4, 6);
			String lastTwoYear = lastTwoMonth.substring(0, 4);
			if ("02".equals(mons)) {
				lastTwoYear = "-";
			}
			baseMapper.insertStatisticsCurrentReport(declareMonth, lastMonth, lastTwoMonth, lastTwoYear);
			return R.ok("已生成完毕！");
		} else {
			return R.failed("删除本期申报失败！");
		}
	}

}
