package com.yifu.cloud.plus.v1.yifu.salary.util;

import com.alibaba.fastjson.JSONObject;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CacheConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ValidityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.exception.ExcelException;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.insurances.util.ValidityUtil;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TConfigSalary;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryConfigStandard;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryEmployee;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryAccountService;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryEmployeeService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryAccountItemVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryAccountVo;
import lombok.Data;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;

import static com.yifu.cloud.plus.v1.yifu.salary.util.SalaryCommonUtil.setFields;

/**
 * @author hgw
 * @Description: EXCEL内容转化为TSalaryAccount
 */
@Data
@Log4j2
public class SalaryAccountUtil implements Serializable {

	/**
	 * 用于返回实体
	 */
	private List<TSalaryAccountVo> entityList;
	/**
	 * 用于返回错误信息
	 */
	private List<ErrorMessage> errorInfo;

	/**
	 * @param jsonStr         客户原表json内容
	 * @param dept            项目
	 * @param configSalary    当前项目下的配置（结算月等
	 * @param salaryConfigMap 客户原表-工资模板配置Map
	 * @param empIdCardMap    当前项目下的员工Map
	 * @param empNameMap      当前项目下的员工Map
	 * @param isDuplicateName false：有重名（当前项目下的员工），则不可用姓名查找，必须含有身份证号列
	 *                        repeatFlag      默认 0：不允许重复导入已存在系统内的数据；1：允许重复导入
	 * @param ownEmployeeMap  自有员工所在项目Map
	 * @Description: 将jsonStr数据源的数据导入到 List<TSalaryAccount>
	 * @Author: hgw
	 * @Date: 2019/9/16 17:26
	 * @return: void
	 **/
	public void getJsonStringToList(YifuUser user, String jsonStr, TSettleDomainSelectVo dept
			, TConfigSalary configSalary, Map<String, TSalaryConfigStandard> salaryConfigMap, Map<String, Boolean> isMustMap
			, Map<String, TSalaryEmployee> empIdCardMap, Map<String, TSalaryEmployee> empNameMap, boolean isDuplicateName
			, String salaryType, List<String> checkListY, String invoiceTitle, TSalaryEmployeeService tSalaryEmployeeService
			, Map<String, Integer> checkMap, Map<String, BigDecimal> specialMap, Map<String, Integer> ownEmployeeMap
			, Map<String, Integer> ownDeptMap, TSalaryAccountService tSalaryAccountService) {
		List<TSalaryAccountVo> tList = new ArrayList<>();
		List<HashMap> list = JSONObject.parseArray(jsonStr, HashMap.class);
		List<ErrorMessage> errorList = new ArrayList<>();
		try {
			// 得到数据的条数
			int rows = list.size();
			// 有数据时才处理
			if (rows > 0) {
				// 得到类的所有field
				Field[] allFields = TSalaryAccountVo.class.getDeclaredFields();
				// 从map中得到对应列的field
				Field field;
				// 将有注解的field存放到fieldsMap中
				Map<String, Field> fieldsMap = new HashMap<>();
				for (int i = 0; i < allFields.length; i++) {
					field = allFields[i];
					if (field.isAnnotationPresent(ExcelAttribute.class)) {
						// 设置类的私有字段属性可访问
						field.setAccessible(true);
						fieldsMap.put(field.getName(), field);
					}
				}
				String error;  //校验字段是否符合要求 返回错误信息
				TSalaryAccountVo entity;  // 从第1行开始取数据
				HashMap<String, Object> temp;  // 得到一行中的所有单元格对象.
				ExcelAttribute attr;  //获取属性对应的注解属性
				Object cellValueObj;  //单元格值
				String cellValueStr;  //单元格字符串值
				String dbFiedName;  //单元格值，对应的数据库中文名
				Class<?> fieldType;  // 取得类型,并根据对象类型设置值.
				TSalaryConfigStandard scs;
				TSalaryEmployee emp;
				TSalaryEmployee newEmp;  //新员工
				List<TSalaryAccountItemVo> saiList;
				TSalaryAccountItemVo sai;
				BigDecimal cellValueBig;
				Map<String, Integer> checkIdNumberMap = new HashMap<>();  //验证身份证重复性的Map
				boolean salaryGiveTimeFlag;  //salaryGiveTime == true :立即发；false：暂停发：则不考虑开户行等
				//是否新员工：是：true；否：false
				boolean isNewEmployee;
				String empName;
				String salaryStyle;//工资发放方式（0现金/1银行）/2线下
				BigDecimal relaySalary;  //应发工资
				BigDecimal relaySalarySum;  //应发工资合计，算3500与5000使用的
				BigDecimal money3500 = new BigDecimal("3500");  //特殊金额3500
				BigDecimal money5000 = new BigDecimal("5000");  //特殊金额5000
				BigDecimal actualSalarySum;  //实发工资
				// 当前年月
				String nowMonth = DateUtil.addMonth(CommonConstants.ZERO_INT);
				String must;
				// 当前年（用来获取已有薪资的计税月份，覆盖填写的计税月份2022-1-19 17:11:24hgw根据郭华照等人提出的需求
				int nowYear = Integer.parseInt(nowMonth.substring(0, 4));
				// 当前结算年，已有工资的最小计税月
				String minTaxMonth;
				// 开户行省市的区域暂存
				String areaStr;
				// 员工新建保存的反馈，null 保存成功，其他，保存失败，反馈原因
				String saveNewEmpReturn;
				// 每一行是否有错误 true : 无错误
				boolean errorFlag;
				// 是否含有年终奖 false 没有
				boolean annualBonusFlag;
				for (int i = 0; i < rows; i++) {
					annualBonusFlag = false;
					errorFlag = true;
					temp = list.get(i);
					entity = new TSalaryAccountVo();
					emp = null;
					newEmp = new TSalaryEmployee();
					salaryGiveTimeFlag = true;
					empName = null;
					isNewEmployee = false;
					saiList = new ArrayList<>();
					salaryStyle = SalaryConstants.SALARY_STYLE_BANK;
					relaySalary = null;
					actualSalarySum = null;
					entity.setSettlementMonth(nowMonth);
					for (Map.Entry<String, TSalaryConfigStandard> entry : salaryConfigMap.entrySet()) {
						cellValueObj = getFieldValueByName(entry.getKey(), temp);
						scs = entry.getValue();
						if (Common.isNotNull(cellValueObj) && scs != null) {
							cellValueStr = getStringValByObject(cellValueObj);
							if (!StringUtils.isNotBlank(cellValueStr)) {
								errorFlag = false;
								error = "第" + (i + 2) + "行：" + entry.getKey() + "列_不识别对象类型";
								errorList.add(new ErrorMessage((i + 2), error));
								continue;
							}
							dbFiedName = scs.getDbFiedName();
							if (isMustMap.get(dbFiedName) != null && Boolean.TRUE.equals(isMustMap.get(dbFiedName))) {
								isMustMap.put(dbFiedName, false);
							}
							if (SalaryConstants.ANNUAL_BONUS_JAVA.equals(scs.getJavaFiedName()) && Common.isNotNull(cellValueStr)) {
								annualBonusFlag = true;
							}
							if (SalaryConstants.ANNUAL_BONUS_TAX_TYPE.equals(scs.getJavaFiedName())) {
								if (SalaryConstants.ANNUAL_BONUS_ALONE.equals(cellValueStr)) {
									entity.setAnnualBonusType(SalaryConstants.ANNUAL_BONUS_TAX_TYPE_VALUE[1]);
								}
								if (SalaryConstants.ANNUAL_BONUS_MERGE.equals(cellValueStr)) {
									entity.setAnnualBonusType(SalaryConstants.ANNUAL_BONUS_TAX_TYPE_VALUE[0]);
								}
							}
							if (SalaryConstants.RELAY_SALARY_JAVA.equals(scs.getJavaFiedName())) {
								try {
									relaySalary = new BigDecimal(cellValueStr);
									sai = new TSalaryAccountItemVo();
									sai.setCnName(dbFiedName);
									sai.setJavaFiedName(scs.getJavaFiedName());
									sai.setIsTax(CommonConstants.ZERO_INT);
									sai.setSalaryMoney(relaySalary);
									saiList.add(sai);
								} catch (Exception e) {
									errorFlag = false;
									error = "第" + (i + 2) + "行：应发工资：'" + cellValueStr + "'错误，请检查数据";
									errorList.add(new ErrorMessage((i + 2), error));
									continue;
								}
							}
							if (SalaryConstants.ACTUAL_SALARY_SUM_JAVA.equals(scs.getJavaFiedName())) {
								try {
									actualSalarySum = new BigDecimal(cellValueStr);
									entity.setActualSalary(actualSalarySum);
								} catch (Exception e) {
									errorFlag = false;
									error = "第" + (i + 2) + "行：实发工资：'" + cellValueStr + "'错误，请检查数据";
									errorList.add(new ErrorMessage((i + 2), error));
									continue;
								}
							}
							if (SalaryConstants.PDEDUCTION_JAVA.equals(scs.getJavaFiedName())
									|| SalaryConstants.UDEDUCTION_JAVA.equals(scs.getJavaFiedName())) {
								try {
									new BigDecimal(cellValueStr);
								} catch (Exception ex) {
									errorFlag = false;
									error = "第" + (i + 2) + "行：个人、单位代扣，只能是金额！";
									errorList.add(new ErrorMessage((i + 2), error));
									continue;
								}
							}
							if (SalaryConstants.EMP_NAME.equals(dbFiedName)) {
								empName = cellValueStr = cellValueStr.replace(" ", "");
								if (isDuplicateName) {
									emp = empNameMap.get(empName);
								}
								newEmp.setEmpName(empName);
							}
							if ((SalaryConstants.IF_NEW_EMPLOYEE.equals(dbFiedName) || SalaryConstants.IS_NEW_EMPLOYEE.equals(dbFiedName))
									&& SalaryConstants.IS_NEW.equals(cellValueStr)) {
								isNewEmployee = true;
							}
							if (SalaryConstants.ID_NUMBER.equals(dbFiedName)) {
								if (checkIdNumberMap.get(cellValueStr) == null) {
									checkIdNumberMap.put(cellValueStr, (i + 2));
								} else {
									errorFlag = false;
									error = "第" + (i + 2) + "行与第：" + checkIdNumberMap.get(cellValueStr) + "行身份证重复:" + cellValueStr;
									errorList.add(new ErrorMessage((i + 2), error));
									break;
								}
								if (cellValueStr.contains("x")) {
									cellValueStr = cellValueStr.toUpperCase();
								}
								emp = empIdCardMap.get(cellValueStr);
								newEmp.setEmpIdcard(cellValueStr);
							}
							if (SalaryConstants.SALARY_GIVE_TIME.equals(cellValueStr)) {
								salaryGiveTimeFlag = false;
								entity.setSalaryGiveTime(CommonConstants.ONE_STRING);
							}
							field = fieldsMap.get(scs.getJavaFiedName());
							if (field == null) {
								sai = new TSalaryAccountItemVo();
								sai.setCnName(dbFiedName);
								sai.setJavaFiedName(scs.getJavaFiedName());
								if (scs.getIsTax() != null) {
									sai.setIsTax(scs.getIsTax());
								} else {
									sai.setIsTax(CommonConstants.ZERO_INT);
								}
								try {
									cellValueBig = new BigDecimal(cellValueStr);
									cellValueBig = cellValueBig.setScale(2, BigDecimal.ROUND_HALF_UP); //四舍五入
									if (cellValueBig.toString().length() > 11) {
										if (cellValueBig.toString().length() > 500) {
											errorFlag = false;
											errorList.add(new ErrorMessage((i + 2), "文本超长！"));
											continue;
										}
										sai.setTextValue(cellValueBig.toString());
									} else {
										sai.setSalaryMoney(cellValueBig);
									}
								} catch (NumberFormatException e) {
									if (cellValueStr.length() > 500) {
										errorFlag = false;
										errorList.add(new ErrorMessage((i + 2), "文本超长！"));
										continue;
									}
									sai.setTextValue(cellValueStr);
								}
								saiList.add(sai);
							} else {
								attr = field.getAnnotation(ExcelAttribute.class);
								fieldType = field.getType();
								if (fieldType == null) {
									continue;
								}
								setFields(field, cellValueStr, attr, fieldType, entity);
								error = validateUtil(cellValueStr, attr, (i + 2));
								if (null != error) {
									errorFlag = false;
									errorList.add(new ErrorMessage((i + 2), error));
								}
							}
						}
					}
					if (errorFlag) {
						must = null;
						for (Map.Entry<String, Boolean> entry : isMustMap.entrySet()) {
							if (Boolean.TRUE.equals(entry.getValue())) {
								if (Common.isEmpty(must)) {
									must = entry.getKey();
								} else {
									must = must.concat("、").concat(entry.getKey());
								}
							}
						}
						if (Common.isNotNull(must)) {
							error = "第" + (i + 2) + "行：" + must + "列_不可缺少";
							errorList.add(new ErrorMessage((i + 2), error));
							continue;
						}

						if (annualBonusFlag && Common.isEmpty(entity.getAnnualBonusType())) {
							error = "第" + (i + 2) + "行：年终奖有值，【年终奖扣税方式】需填写【单独】/【合并】";
							errorList.add(new ErrorMessage((i + 2), error));
							continue;
						}
						if ("3".equals(salaryType) && actualSalarySum == null) {
							error = "第" + (i + 2) + "行：【实发劳务费】列_不可缺少";
							errorList.add(new ErrorMessage((i + 2), error));
							continue;
						}
						if ("3".equals(salaryType) && Common.isEmpty(entity.getIsPersonTax())) {
							error = "第" + (i + 2) + "行：【是否个人承担部分税费】列_不可为空";
							errorList.add(new ErrorMessage((i + 2), error));
							continue;
						}
						if ("4".equals(salaryType) && actualSalarySum == null) {
							error = "第" + (i + 2) + "行：【稿酬】列_不可缺少";
							errorList.add(new ErrorMessage((i + 2), error));
							continue;
						}

						// 应发、实发、实发劳务费不可都为空
						if (relaySalary == null && actualSalarySum == null) {
							error = "第" + (i + 2) + "行：【应发工资】列_不可缺少";
							errorList.add(new ErrorMessage((i + 2), error));
							continue;
						}

						// 版本2.6.6判重：对同一“项目”、同一“结算月份”、同一“报表类型”、同一“工资月份”、同一“身份证号”、同一“应发金额”进行校验
						// 2.6.6:校验导入数据重复的Map格式：#身份证号_工资月份_报表类型_应发金额
						entity.setIsRepeat(CommonConstants.ZERO_INT);
						if (relaySalary != null) {
							relaySalary = relaySalary.setScale(2, BigDecimal.ROUND_HALF_UP);
							if (!checkMap.isEmpty() && checkMap.get(entity.getEmpIdcard() + CommonConstants.DOWN_LINE_STRING + DateUtil.addMonth(configSalary.getSalaryMonth())
									+ CommonConstants.DOWN_LINE_STRING + salaryType + CommonConstants.DOWN_LINE_STRING + relaySalary) != null) {
								entity.setIsRepeat(CommonConstants.ONE_INT);
							}
							if (!CommonConstants.THREE_STRING.equals(salaryType) && !CommonConstants.FOUR_STRING.equals(salaryType)) {
								relaySalarySum = BigDecimalUtils.safeAdd(relaySalary, specialMap.get(entity.getEmpIdcard()));
								if (money3500.compareTo(relaySalarySum) == CommonConstants.ZERO_INT
										|| money5000.compareTo(relaySalarySum) == CommonConstants.ZERO_INT) {
									entity.setHaveSpecialFlag(CommonConstants.ONE_INT);
								}
							}
						}
						if (actualSalarySum != null) {
							actualSalarySum = actualSalarySum.setScale(2, BigDecimal.ROUND_HALF_UP);
							if (!checkMap.isEmpty() && checkMap.get(entity.getEmpIdcard() + CommonConstants.DOWN_LINE_STRING + DateUtil.addMonth(configSalary.getSalaryMonth())
									+ CommonConstants.DOWN_LINE_STRING + salaryType + CommonConstants.DOWN_LINE_STRING + actualSalarySum) != null) {
								entity.setIsRepeat(CommonConstants.ONE_INT);
							}
						}
						if (Common.isNotNull(checkListY) && checkListY.contains(entity.getEmpIdcard())) {
							entity.setHaveSalaryFlag(CommonConstants.ONE_INT);
						}
						if (Common.isNotNull(entity.getSalaryStyle())) {
							salaryStyle = entity.getSalaryStyle();
						} else if (configSalary.getGrantType() != null) {
							salaryStyle = String.valueOf(configSalary.getGrantType());
						}
						// 2021-8-31 hgw2.6.5新增手机号校验
						if (newEmp != null && Common.isNotNull(entity.getEmpPhone()) && Common.isEmpty(newEmp.getEmpPhone())) {
							newEmp.setEmpPhone(entity.getEmpPhone());
						}
						if (emp == null) {
							if (isNewEmployee) {
								//增加工资人员档案：（临时使用）
								if (newEmp != null) {
									if (Common.isEmpty(newEmp.getEmpName())) {
										error = "第" + (i + 2) + "行：新员工-姓名-不可为空！";
										errorList.add(new ErrorMessage((i + 2), error));
										continue;
									}
									if (Common.isEmpty(newEmp.getEmpIdcard())) {
										error = "第" + (i + 2) + "行：新员工-身份证号-不可为空！";
										errorList.add(new ErrorMessage((i + 2), error));
										continue;
									}

									// 2021-8-31 hgw2.6.5新增手机号校验
									if (Common.isEmpty(newEmp.getEmpPhone())) {
										error = "第" + (i + 2) + "行：新员工-手机号码-不可为空！";
										errorList.add(new ErrorMessage((i + 2), error));
										continue;
									} else if (!ValidityUtil.validateEmpPhone(newEmp.getEmpPhone())) {
										error = "第" + (i + 2) + "行：新员工-手机号码格式错误：" + newEmp.getEmpPhone();
										errorList.add(new ErrorMessage((i + 2), error));
										continue;
									}
								}
								if (entity != null) {
									if (!"3".equals(salaryType) && !"4".equals(salaryType)) {
										if (Common.isEmpty(entity.getTaxMonth())) {
											error = "第" + (i + 2) + "行：新员工-计税月份-不可为空！";
											errorList.add(new ErrorMessage((i + 2), error));
											continue;
										} else if (entity.getTaxMonth().length() < CommonConstants.dingleDigitIntArray[6]) {
											error = "第" + (i + 2) + "行：新员工-计税月份-长度小于6：" + entity.getTaxMonth();
											errorList.add(new ErrorMessage((i + 2), error));
											continue;
										} else if (DateUtil.compareYearMonth(entity.getTaxMonth(), nowMonth)) {
											error = "第" + (i + 2) + "行：新员工-计税月份-大于当前年月或错误，请调整：" + entity.getTaxMonth();
											errorList.add(new ErrorMessage((i + 2), error));
											continue;
										} else {
											newEmp.setTaxMonth(entity.getTaxMonth());
										}
									}
									//工资发放方式（0现金/1银行）/2线下 && salaryGiveTime == true :立即发；false：暂停发：则不考虑开户行等
									//银行+立即发，则考虑和开户行卡号
									if (SalaryConstants.SALARY_STYLE_BANK.equals(salaryStyle) && salaryGiveTimeFlag) {
										if (Common.isEmpty(entity.getBankName())) {
											error = "第" + (i + 2) + "行：新员工-开户行总行-不可为空！";
											errorList.add(new ErrorMessage((i + 2), error));
											continue;
										} else {
											newEmp.setBankName(entity.getBankName());
										}
										if (Common.isEmpty(entity.getBankProvince()) || Common.isEmpty(entity.getBankCity())) {
											error = "第" + (i + 2) + "行：新员工-开户行省、市-不可为空！";
											errorList.add(new ErrorMessage((i + 2), error));
											continue;
										} else {
											areaStr = ExcelUtil.getRedisAreaValue(CacheConstants.AREA_VALUE + entity.getBankProvince().trim());
											if (Common.isNotNull(areaStr)) {
												newEmp.setBankProvince(areaStr);
											} else {
												error = "第" + (i + 2) + "行：新员工-开户行省错误：" + entity.getBankProvince();
												errorList.add(new ErrorMessage((i + 2), error));
												continue;
											}
											areaStr = ExcelUtil.getRedisAreaValue(CacheConstants.AREA_VALUE + entity.getBankCity().trim()
													+ CommonConstants.DOWN_LINE_STRING + entity.getBankProvince().trim());
											if (Common.isNotNull(areaStr)) {
												newEmp.setBankCity(areaStr);
											} else {
												error = "第" + (i + 2) + "行：新员工-开户行市错误：" + entity.getBankCity();
												errorList.add(new ErrorMessage((i + 2), error));
												continue;
											}
										}
										if (Common.isEmpty(entity.getBankNo())) {
											error = "第" + (i + 2) + "行：新员工-银行卡号-不可为空！";
											errorList.add(new ErrorMessage((i + 2), error));
											continue;
										} else {
											newEmp.setBankNo(entity.getBankNo());
										}
										if (Common.isNotNull(entity.getBankSubName())) {
											newEmp.setBankSubName(entity.getBankSubName());
										}
									} else {
										if (Common.isNotNull(entity.getBankName())) {
											newEmp.setBankName(entity.getBankName());
										}
										if (Common.isNotNull(entity.getBankNo())) {
											newEmp.setBankNo(entity.getBankNo());
										}
										if (Common.isNotNull(entity.getBankSubName())) {
											newEmp.setBankSubName(entity.getBankSubName());
										}
										if (Common.isNotNull(entity.getBankProvince())) {
											areaStr = ExcelUtil.getRedisAreaValue(CacheConstants.AREA_VALUE + entity.getBankProvince().trim());
											if (Common.isNotNull(areaStr)) {
												newEmp.setBankProvince(areaStr);
											}
											if (Common.isNotNull(entity.getBankCity())) {
												areaStr = ExcelUtil.getRedisAreaValue(CacheConstants.AREA_VALUE + entity.getBankCity().trim()
														+ CommonConstants.DOWN_LINE_STRING + entity.getBankProvince().trim());
												if (Common.isNotNull(areaStr)) {
													newEmp.setBankCity(areaStr);
												}
											}
										}
									}
								}
								newEmp.setFileStatus(CommonConstants.ZERO_STRING);  //临时
								newEmp.setDeptId(dept.getId());
								newEmp.setDeptName(dept.getDepartName());
								newEmp.setDeptNo(dept.getDepartNo());
								newEmp.setUnitId(dept.getCustomerId());
								newEmp.setUnitName(dept.getCustomerName());
								newEmp.setUnitNo(dept.getCustomerCode());
								newEmp.setCreateBy(String.valueOf(user.getId()));
								newEmp.setCreateName(user.getNickname());
								newEmp.setInvoiceTitle(invoiceTitle);
								if (!"3".equals(salaryType) && !"4".equals(salaryType)) {
									minTaxMonth = tSalaryAccountService.getMinTaxMonthByNowYear(newEmp.getEmpIdcard(), nowYear);
									if (Common.isNotNull(minTaxMonth)
											&& !minTaxMonth.equals(entity.getTaxMonth())) {
										error = "第" + (i + 2) + "行：该员工已有发薪记录，计税月份请填写：【" + minTaxMonth + "】" + "，你填写了计税月：【" + entity.getTaxMonth() + "】";
										errorList.add(new ErrorMessage((i + 2), error));
										continue;
									}
								}
								saveNewEmpReturn = tSalaryEmployeeService.saveNewSalaryEmployee(newEmp);
								if (Common.isNotNull(saveNewEmpReturn)) {
									error = "第" + (i + 2) + "行：该员工新建失败：【" + saveNewEmpReturn + "】";
									errorList.add(new ErrorMessage((i + 2), error));
									continue;
								}
								emp = newEmp;
							} else {
								if ("3".equals(salaryType) || "4".equals(salaryType)) {
									error = "第" + (i + 2) + "行：薪酬人员查询处中，该客户下无此员工，请添加<是否新员工>列，并录入身份证号、开户行总行、开户行省、开户行市、银行卡号、手机号码！";
								} else {
									error = "第" + (i + 2) + "行：薪酬人员查询处中，该客户下无此员工，请添加<是否新员工（默认否）>列，并录入身份证号、开户行总行、开户行省、开户行市、银行卡号、计税月份、手机号码！";
								}
								errorList.add(new ErrorMessage((i + 2), error));
								continue;
							}
						}
						if (emp != null) {
							if (Common.isEmpty(emp.getEmpName())) {
								error = "第" + (i + 2) + "行：薪酬人员查询处-员工姓名-为空，请去薪酬人员查询处更新！";
								errorList.add(new ErrorMessage((i + 2), error));
								continue;
							} else if (Common.isEmpty(empName)) {
								error = "第" + (i + 2) + "行：模板-员工姓名-为空，请添加员工姓名列！";
								errorList.add(new ErrorMessage((i + 2), error));
								continue;
							} else if (!empName.equals(emp.getEmpName())) {
								error = "第" + (i + 2) + "行：员工-姓名与身份证-不匹配，请确认薪酬人员查询处信息！";
								errorList.add(new ErrorMessage((i + 2), error));
								continue;
							}
							if (Common.isEmpty(emp.getEmpPhone())) {
								error = "第" + (i + 2) + "行：薪酬人员查询处-手机号码-为空，请去薪酬人员查询处更新！";
								errorList.add(new ErrorMessage((i + 2), error));
								continue;
							} else if (!ValidityUtil.validateEmpPhone(emp.getEmpPhone())) {
								error = "第" + (i + 2) + "行：薪酬人员查询处-手机号码格式错误，请去薪酬人员查询处更新:" + emp.getEmpPhone();
								errorList.add(new ErrorMessage((i + 2), error));
								continue;
							}
							if (Common.isEmpty(emp.getTaxMonth()) && !"3".equals(salaryType) && !"4".equals(salaryType)) {
								if (Common.isNotNull(entity.getTaxMonth())) {
									if (entity.getTaxMonth().length() > CommonConstants.dingleDigitIntArray[6]) {
										entity.setTaxMonth(emp.getTaxMonth().substring(0, 6));
									} else if (entity.getTaxMonth().length() < CommonConstants.dingleDigitIntArray[6]) {
										error = "第" + (i + 2) + "行：工资模板里-计税月份-长度小于6：" + entity.getTaxMonth() + "，请在工资模板修改！";
										errorList.add(new ErrorMessage((i + 2), error));
										continue;
									}
									if (DateUtil.compareYearMonth(entity.getTaxMonth(), nowMonth)) {
										error = "第" + (i + 2) + "行：工资模板里-计税月份-大于当前年月或错误，请调整：" + entity.getTaxMonth();
										errorList.add(new ErrorMessage((i + 2), error));
										continue;
									}
									emp.setTaxMonth(entity.getTaxMonth());
									tSalaryEmployeeService.updateById(emp);
								} else {
									error = "第" + (i + 2) + "行：薪酬人员查询处-计税月份-为空，请在工资模板填写-计税月份-列的内容！";
									errorList.add(new ErrorMessage((i + 2), error));
									continue;
								}
							}
							if (ownEmployeeMap.get(emp.getEmpIdcard()) != null
									|| (isNewEmployee && ownDeptMap.get(dept.getId()) != null)) {
								// 自有员工
								entity.setOwnFlag(CommonConstants.ONE_INT);
							} else {
								// 普通员工
								entity.setOwnFlag(CommonConstants.ZERO_INT);
							}
							entity.setProvince(dept.getProvince());
							entity.setCity(dept.getCity());
							entity.setTown(dept.getTown());

							entity.setEmpId(emp.getId());
							entity.setEmpIdcard(emp.getEmpIdcard());
							entity.setEmpName(emp.getEmpName());
							entity.setEmpPhone(emp.getEmpPhone());
							if (SalaryConstants.SALARY_STYLE_BANK.equals(salaryStyle) && salaryGiveTimeFlag) {
								if (Common.isEmpty(emp.getBankName())) {
									error = "第" + (i + 2) + SalaryConstants.LINE_EMP + emp.getEmpIdcard() + "-发放方式为银行发放，但是-开户行-为空，请去薪酬人员查询处更新！";
									errorList.add(new ErrorMessage((i + 2), error));
									continue;
								}
								if (Common.isEmpty(emp.getBankNo())) {
									error = "第" + (i + 2) + SalaryConstants.LINE_EMP + emp.getEmpIdcard() + "-发放方式为银行发放，但是-银行卡号-为空，请去薪酬人员查询处更新！";
									errorList.add(new ErrorMessage((i + 2), error));
									continue;
								}
								if (Common.isEmpty(emp.getBankProvince())) {
									error = "第" + (i + 2) + SalaryConstants.LINE_EMP + emp.getEmpIdcard() + "-发放方式为银行发放，但是-开户行省-为空，请去薪酬人员查询处更新！";
									errorList.add(new ErrorMessage((i + 2), error));
									continue;
								}
								if (Common.isEmpty(emp.getBankCity())) {
									error = "第" + (i + 2) + SalaryConstants.LINE_EMP + emp.getEmpIdcard() + "-发放方式为银行发放，但是-开户行市-为空，请去薪酬人员查询处更新！";
									errorList.add(new ErrorMessage((i + 2), error));
									continue;
								}
								entity.setBankName(emp.getBankName());
								entity.setBankNo(emp.getBankNo());
								entity.setBankProvince(String.valueOf(emp.getBankProvince()));
								entity.setBankCity(String.valueOf(emp.getBankCity()));
								entity.setBankSubName(emp.getBankSubName());
							} else {
								if (Common.isNotNull(emp.getBankName())) {
									entity.setBankName(emp.getBankName());
								} else {
									entity.setBankName(null);
								}
								if (Common.isNotNull(emp.getBankNo())) {
									entity.setBankNo(emp.getBankNo());
								} else {
									entity.setBankNo(null);
								}
								if (Common.isNotNull(emp.getBankSubName())) {
									entity.setBankSubName(emp.getBankSubName());
								} else {
									entity.setBankSubName(null);
								}
								if (Common.isNotNull(emp.getBankProvince())) {
									entity.setBankProvince(String.valueOf(emp.getBankProvince()));
								} else {
									entity.setBankProvince(null);
								}
								if (Common.isNotNull(emp.getBankCity())) {
									entity.setBankCity(String.valueOf(emp.getBankCity()));
								} else {
									entity.setBankCity(null);
								}
							}
							if (!"3".equals(salaryType) && !"4".equals(salaryType)) {
								if (emp.getTaxMonth().length() > CommonConstants.dingleDigitIntArray[6]) {
									entity.setTaxMonth(emp.getTaxMonth().substring(0, 6));
								} else if (emp.getTaxMonth().length() < CommonConstants.dingleDigitIntArray[6]) {
									error = "第" + (i + 2) + "行：薪酬人员查询处-计税月份-长度小于6：" + entity.getTaxMonth() + "，请去薪酬人员查询处更新！在工资模板修改无效！";
									errorList.add(new ErrorMessage((i + 2), error));
									continue;
								} else {
									entity.setTaxMonth(emp.getTaxMonth());
								}
								if (DateUtil.compareYearMonth(entity.getTaxMonth(), nowMonth)) {
									error = "第" + (i + 2) + "行：薪酬人员查询处-计税月份-大于当前年月或错误，请调整：" + entity.getTaxMonth();
									errorList.add(new ErrorMessage((i + 2), error));
									continue;
								}
								sai = new TSalaryAccountItemVo();
								sai.setCnName(SalaryConstants.COST_REDUCTION);
								sai.setJavaFiedName(SalaryConstants.COST_REDUCTION_JAVA);
								sai.setSalaryMoney(DateUtil.getTaxMonthMoney(entity.getTaxMonth()));
								sai.setIsTax(CommonConstants.ZERO_INT);
								saiList.add(sai);
							}
						} else {
							if ("3".equals(salaryType) || "4".equals(salaryType)) {
								error = "第" + (i + 2) + "行：薪酬人员查询处中，该客户下无此员工，请添加<是否新员工>列，并录入身份证号、开户行总行、开户行省、开户行市、银行卡号、手机号码！";
							} else {
								error = "第" + (i + 2) + "行：薪酬人员查询处中，该客户下无此员工，请添加<是否新员工（默认否）>列，并录入身份证号、开户行总行、开户行省、开户行市、银行卡号、计税月份、手机号码！";
							}
							errorList.add(new ErrorMessage((i + 2), error));
							continue;
						}
						if (saiList != null && !saiList.isEmpty()) {
							entity.setSaiList(saiList);
						}
						if (Common.isEmpty(entity.getSalaryStyle())) {
							entity.setSalaryStyle(salaryStyle);
						}
						SalaryCommonUtil.setConfigSalary(configSalary, entity);
						// 填充基本数据
						SalaryCommonUtil.setAccountBaseInfo(salaryType, dept, entity, salaryGiveTimeFlag);
						if ("3".equals(salaryType)) {
							if (CommonConstants.dingleDigitStrArray[1].equals(entity.getIsDeductSocial())
									|| CommonConstants.dingleDigitStrArray[1].equals(entity.getIsDeductFund())) {
								error = "第" + (i + 2) + "行：劳务费不可扣社保、公积金，请去除【是否扣除社保】列，或写【否】";
								errorList.add(new ErrorMessage((i + 2), error));
								continue;
							} else {
								entity.setIsDeductSocial("0");
								entity.setIsDeductFund("0");
							}
						}
						//验证扣社保以及扣公积金时的关联关系
						if (CommonConstants.dingleDigitStrArray[1].equals(entity.getIsDeductSocial()) && Common.isEmpty(entity.getDeduSocialMonth())) {
							error = "第" + (i + 2) + "行：扣社保无社保扣缴月份";
							errorList.add(new ErrorMessage((i + 2), error));
							continue;
						}
						if (CommonConstants.dingleDigitStrArray[1].equals(entity.getIsDeductFund()) && Common.isEmpty(entity.getDeduProvidentMonth())) {
							error = "第" + (i + 2) + "行：扣公积金无公积金扣缴月份";
							errorList.add(new ErrorMessage((i + 2), error));
							continue;
						}
						entity.setInvoiceTitle(invoiceTitle);
						if (entity != null) {
							tList.add(entity);
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			log.error("将jsonString数据源的数据导入到list异常!");
			throw new ExcelException("工资导入-将jsonString数据源的数据导入到list异常!", e);
		}
		this.setEntityList(tList);
		this.setErrorInfo(errorList);
	}

	/**
	 * 按类型统一返回String内容
	 *
	 * @param param
	 * @return
	 */
	private static String getStringValByObject(Object param) {
		if (null == param) {
			return null;
		} else if (param instanceof Integer) {
			return Integer.toString(((Integer) param).intValue());
		} else if (param instanceof String) {
			return (String) param;
		} else if (param instanceof Double) {
			return Double.toString(((Double) param).doubleValue());
		} else if (param instanceof Float) {
			return Float.toString(((Float) param).floatValue());
		} else if (param instanceof Long) {
			return Long.toString(((Long) param).longValue());
		} else if (param instanceof Boolean) {
			return Boolean.toString(((Boolean) param).booleanValue());
		} else if (param instanceof Date) {
			return DateUtil.dateToString((Date) param);
		} else if (param instanceof LocalDateTime) {
			return LocalDateTimeUtils.formatTime((LocalDateTime) param, DateUtil.DATETIME_PATTERN_SECOND);
		} else {
			return param.toString();
		}
	}

	/**
	 * 根据属性名获取属性值
	 *
	 * @param fieldName
	 * @param hashMap
	 * @return
	 */
	private static Object getFieldValueByName(String fieldName, HashMap<String, Object> hashMap) {
		try {
			return hashMap.get(fieldName);
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * 输出错误数据
	 *
	 * @param attr
	 * @param msg
	 * @param i
	 * @return
	 */
	private String errorInfo(ExcelAttribute attr, String msg, Integer i) {
		if (Common.isNotNull(msg)) {
			return "第" + i + "行：" + attr.name() + msg;
		} else if (Common.isNotNull(attr.errorInfo())) {
			return "第" + i + "行：" + attr.errorInfo();
		}
		return "";
	}

	/**
	 * 实现各种校验方式的错误返回新
	 *
	 * @param c
	 * @param attr
	 * @param i
	 * @return
	 */
	public String validateUtil(String c, ExcelAttribute attr, int i) {
		//非空校验
		if (attr.isNotEmpty() && Common.isEmpty(c)) {
			return errorInfo(attr, "_字段不可为空", i);
		}
		if (Common.isNotNull(c)) {
			//日期格式校验
			if (attr.isDate()) {
				DateUtil.stringToDate(c.trim(), attr.dateFormat());
			}
			//手机号码校验
			if (attr.isPhone() && getMatchRes(c, attr, ValidityConstants.MOBILE_PATTERN)) {
				return errorInfo(attr, "_手机号码有误", i);
			}
			//身份证校验
			if (attr.isIdCard() && getMatchRes(c, attr, ValidityConstants.IDCARD_PATTERN)) {
				return errorInfo(attr, "_身份证格式有误", i);
			}
			//邮箱验证
			if (attr.isEmail() && getMatchRes(c, attr, ValidityConstants.EMAIL_PATTERN)) {
				return errorInfo(attr, "_邮箱格式有误", i);
			}
			//integer 验证
			if (attr.isInteger() && getMatchRes(c, attr, ValidityConstants.INTEGER_PATTERN)) {
				return errorInfo(attr, "_整数格式有误", i);
			}
			//float、double 验证
			if (attr.isFloat() && getMatchRes(c, attr, ValidityConstants.FLOAT_PATTERN)) {
				return errorInfo(attr, "_数字格式有误", i);
			}
			//最大长度校验
			if (attr.maxLength() > 0 && c.length() > attr.maxLength()) {
				return errorInfo(attr, "_超出最大长度", i);
			}
			//最大值校验
			if (Integer.parseInt(attr.max()) > 0) {
				if (Common.isNumber(c)) {
					if (Integer.parseInt(c) > attr.maxLength()) {
						return errorInfo(attr, "_超出最大值", i);
					}
				} else {
					return "第" + i + "行：" + "_必须为数字";
				}
			}
			//最小值校验
			if (attr.min() > 0) {
				if (Common.isNumber(c)) {
					if (Integer.parseInt(c) > attr.maxLength()) {
						return errorInfo(attr, "_小于最小值", i);
					}
				} else {
					return "第" + (i + 2) + "行：" + "_必须为数字";
				}
			}
		}
		return null;
	}

	/**
	 * 正则匹配返回
	 *
	 * @param c
	 * @param attr
	 * @param pattern
	 * @return
	 * @Author fxj
	 * @Date 2019-08-06
	 **/
	private boolean getMatchRes(String c, ExcelAttribute attr, String pattern) {
		return !c.matches(Common.isEmpty(attr.pattern()) ? pattern : attr.pattern());
	}

	/**
	 * @param from 源
	 * @param to   反射后的目标
	 * @Description: 反射实体类
	 * @Author: hgw
	 * @Date: 2019/11/1 16:38
	 * @return: void
	 **/
	public static void reflectionAttr(Object from, Object to) {
		try {
			Class clazz1 = Class.forName(from.getClass().getName());
			Class clazz2 = Class.forName(to.getClass().getName());
			// 获取两个实体类的所有属性
			Field[] fields1 = clazz1.getDeclaredFields();
			Field[] fields2 = clazz2.getDeclaredFields();
			SalaryAccountUtil cr = new SalaryAccountUtil();
			// 遍历class1Bean，获取逐个属性值，然后遍历class2Bean查找是否有相同的属性，如有相同则赋值
			for (Field f1 : fields1) {
				if (f1.getName().equals("id"))
					continue;
				Object value = cr.invokeGetMethod(from, f1.getName(), null);
				for (Field f2 : fields2) {
					if (f1.getName().equals(f2.getName()) && !f2.getName().equals("serialVersionUID")
							&& !f2.getName().equals("saiList")) {
						Object[] obj = new Object[1];
						obj[0] = value;
						cr.invokeSetMethod(to, f2.getName(), obj);
					}
				}
			}
		} catch (Exception e) {
			log.error("反射失败", e);
			e.printStackTrace();
		}
	}

	/**
	 * 执行某个Field的getField方法
	 *
	 * @param clazz     类
	 * @param fieldName 类的属性名称
	 * @param args      参数，默认为null
	 * @return
	 */
	public Object invokeGetMethod(Object clazz, String fieldName, Object[] args) {
		String methodName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
		Method method = null;
		try {
			if (methodName.equals("SerialVersionUID")) {
				return "";
			}
			method = Class.forName(clazz.getClass().getName()).getDeclaredMethod("get" + methodName);
			return method.invoke(clazz);
		} catch (Exception e) {
			log.error("执行某个Field的getField方法异常!", e);
			return "";
		}
	}

	/**
	 * 执行某个Field的setField方法
	 *
	 * @param clazz     类
	 * @param fieldName 类的属性名称
	 * @param args      参数，默认为null
	 * @return
	 */
	@SuppressWarnings({"unchecked", "rawtypes"})
	private Object invokeSetMethod(Object clazz, String fieldName, Object[] args) {
		String methodName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
		Method method = null;
		try {
			Class[] parameterTypes = new Class[1];
			Class c = Class.forName(clazz.getClass().getName());
			Field field = c.getDeclaredField(fieldName);
			parameterTypes[0] = field.getType();
			method = c.getDeclaredMethod("set" + methodName, parameterTypes);
			return method.invoke(clazz, args);
		} catch (Exception e) {
			log.error("执行某个Field的setField方法异常!", e);
			return "";
		}
	}

}
