/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Date;

/**
 * 推送ekp报错的记录表
 *
 * @author hgw
 * @date 2022-9-7 16:11:24
 */
@Data
@TableName("t_send_ekp_error")
@Schema(description = "推送ekp报错的记录表（同类型仅1条记录，更新计数器）")
public class TSendEkpError {

	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;

	@ExcelAttribute(name = "内容")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("内容")
	private String title;

	@ExcelAttribute(name = "类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型（0:薪资代扣推送的社保公积金1薪资明细2预估明细3缴费明细4实时收入5定时收入）")
	private String type;

	@ExcelAttribute(name = "创建日")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建日")
	private String createDay;

	@ExcelAttribute(name = "关联ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("关联ID")
	private String linkId;

	@ExcelAttribute(name = "创建时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建时间")
	@JsonFormat(pattern = "yyyy-MM-dd  HH:mm:ss")
	private Date createTime;

	@ExcelAttribute(name = "创建人姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建人姓名")
	private String createUserName;

	@ExcelAttribute(name = "计数器")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("计数器")
	private Integer nums;

}
