/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 社保明细表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
@TableName("t_social_info" )
@EqualsAndHashCode(callSuper = true)
@Schema(description = "社保明细表" )
public class TSocialInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键" )
	private String id;
	/**
	 * 社保户
	 */
	@Length(max = 32, message = "社保户 不能超过32个字符" )
	@ExcelAttribute(name = "社保户", maxLength = 32)
	@Schema(description = "社保户" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户" )
	private String socialHousehold;
	/**
	 * 社保户名称
	 */
	@ExcelAttribute(name = "社保户名称", maxLength = 50)
	@Schema(description = "社保户名称" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户名称" )
	private String socialHouseholdName;
	/**
	 * 社保起缴日期
	 */
	@ExcelAttribute(name = "社保起缴日期", isDate = true)
	@Schema(description = "社保起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保起缴日期" )
	private Date socialStartDate;
	/**
	 * 单位养老基数
	 */
	@ExcelAttribute(name = "单位养老基数" )
	@Schema(description = "单位养老基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老基数" )
	private BigDecimal unitPensionCardinal;
	/**
	 * 单位医疗基数
	 */
	@ExcelAttribute(name = "单位医疗基数" )
	@Schema(description = "单位医疗基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗基数" )
	private BigDecimal unitMedicalCardinal;
	/**
	 * 单位失业基数
	 */
	@ExcelAttribute(name = "单位失业基数" )
	@Schema(description = "单位失业基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业基数" )
	private BigDecimal unitUnemploymentCardinal;
	/**
	 * 单位大病救助基数
	 */
	@ExcelAttribute(name = "单位大病救助基数" )
	@Schema(description = "单位大病救助基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病救助基数" )
	private BigDecimal unitBigailmentCardinal;
	/**
	 * 单位工伤基数
	 */
	@ExcelAttribute(name = "单位工伤基数" )
	@Schema(description = "单位工伤基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤基数" )
	private BigDecimal unitWorkInjuryCardinal;
	/**
	 * 单位生育基数
	 */
	@ExcelAttribute(name = "单位生育基数" )
	@Schema(description = "单位生育基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育基数" )
	private BigDecimal unitBirthCardinal;
	/**
	 * 个人养老基数
	 */
	@ExcelAttribute(name = "个人养老基数" )
	@Schema(description = "个人养老基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老基数" )
	private BigDecimal personalPensionCardinal;
	/**
	 * 个人医疗基数
	 */
	@ExcelAttribute(name = "个人医疗基数" )
	@Schema(description = "个人医疗基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗基数" )
	private BigDecimal personalMedicalCardinal;
	/**
	 * 个人大病救助基数
	 */
	@ExcelAttribute(name = "个人大病救助基数" )
	@Schema(description = "个人大病救助基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病救助基数" )
	private BigDecimal personalBigailmentCardinal;
	/**
	 * 个人失业基数
	 */
	@ExcelAttribute(name = "个人失业基数" )
	@Schema(description = "个人失业基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业基数" )
	private BigDecimal personalUnemploymentCardinal;

	/**
	 * 员工ID（数据引用）
	 */
	@Length(max = 32, message = "员工ID（数据引用） 不能超过32个字符" )
	@ExcelAttribute(name = "员工ID（数据引用）", maxLength = 32)
	@Schema(description = "员工ID（数据引用）" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工ID（数据引用）" )
	private String empId;
	/**
	 * 员工编码
	 */
	@Length(max = 50, message = "员工编码 不能超过50个字符" )
	@ExcelAttribute(name = "员工编码", maxLength = 50)
	@Schema(description = "员工编码" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工编码" )
	private String empNo;
	/**
	 * 员工姓名
	 */
	@Length(max = 50, message = "员工姓名 不能超过50个字符" )
	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Schema(description = "员工姓名" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名" )
	private String empName;
	/**
	 * 员工身份证
	 */
	@Length(max = 20, message = "员工身份证 不能超过20个字符" )
	@ExcelAttribute(name = "员工身份证", maxLength = 20)
	@Schema(description = "员工身份证" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工身份证" )
	private String empIdcard;
	/**
	 * 单位养老比例
	 */
	@ExcelAttribute(name = "单位养老比例" )
	@Schema(description = "单位养老比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老比例" )
	private BigDecimal unitPensionPer;
	/**
	 * 单位医疗比例
	 */
	@ExcelAttribute(name = "单位医疗比例" )
	@Schema(description = "单位医疗比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗比例" )
	private BigDecimal unitMedicalPer;
	/**
	 * 单位失业比例
	 */
	@ExcelAttribute(name = "单位失业比例" )
	@Schema(description = "单位失业比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业比例" )
	private BigDecimal unitUnemploymentPer;
	/**
	 * 单位工伤比例
	 */
	@ExcelAttribute(name = "单位工伤比例" )
	@Schema(description = "单位工伤比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤比例" )
	private BigDecimal unitWorkUnjuryPer;
	/**
	 * 单位生育比例
	 */
	@ExcelAttribute(name = "单位生育比例" )
	@Schema(description = "单位生育比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育比例" )
	private BigDecimal unitBirthPer;
	/**
	 * 个人养老比例
	 */
	@ExcelAttribute(name = "个人养老比例" )
	@Schema(description = "个人养老比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老比例" )
	private BigDecimal personalPensionPer;
	/**
	 * 个人医疗比例
	 */
	@ExcelAttribute(name = "个人医疗比例" )
	@Schema(description = "个人医疗比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗比例" )
	private BigDecimal personalMedicalPer;
	/**
	 * 个人失业比例
	 */
	@ExcelAttribute(name = "个人失业比例" )
	@Schema(description = "个人失业比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业比例" )
	private BigDecimal personalUnemploymentPer;
	/**
	 * 审核状态 0 未审核 1 审核通过 2审核不通过
	 */
	@NotBlank(message = "审核状态不能为空" )
	@Length(max = 32, message = "审核状态 不能超过32个字符" )
	@ExcelAttribute(name = "审核状态", isNotEmpty = true, errorInfo = "审核状态不能为空", maxLength = 32)
	@Schema(description = "审核状态:0 未审核 1 审核通过 2审核不通过" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核状态" )
	private String auditStatus;
	/**
	 * 办理状态：0待办理/1已办理2办理失败3已派减 4 办理中 5 部分办理失败
	 */
	@NotBlank(message = "办理状态不能为空" )
	@Length(max = 32, message = "办理状态 不能超过32个字符" )
	@ExcelAttribute(name = "办理状态", isNotEmpty = true, errorInfo = "办理状态不能为空", maxLength = 32)
	@Schema(description = "办理状态：0待办理/1已办理2办理失败3已派减4 办理中 5 部分办理失败" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("办理状态" )
	private String handleStatus;
	/**
	 * 草稿状态
	 */
	@NotBlank(message = "草稿状态不能为空" )
	@Length(max = 1, message = "草稿状态 不能超过1个字符" )
	@ExcelAttribute(name = "草稿状态", isNotEmpty = true, errorInfo = "草稿状态不能为空", maxLength = 1)
	@Schema(description = "草稿状态" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("草稿状态" )
	private String draftStatus;
	/**
	 * 社保基数配置ID（数据引用）
	 */
	@Length(max = 32, message = "社保基数配置ID（数据引用） 不能超过32个字符" )
	@ExcelAttribute(name = "社保基数配置ID（数据引用）", maxLength = 32)
	@Schema(description = "社保基数配置ID（数据引用）" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保基数配置ID（数据引用）" )
	private String cardinalId;
	/**
	 * 原ID（数据迁移）
	 */
	@ExcelAttribute(name = "原ID（数据迁移）" )
	@Schema(description = "原ID（数据迁移）" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("原ID（数据迁移）" )
	private Integer oldId;
	/**
	 * 项目
	 */
	@Length(max = 32, message = "项目 不能超过32个字符" )
	@ExcelAttribute(name = "项目", maxLength = 32)
	@Schema(description = "项目" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目" )
	private String settleDomain;
	/**
	 * 缴纳地-省
	 */
	@Length(max = 32, message = "缴纳地-省 不能超过32个字符" )
	@ExcelAttribute(name = "缴纳地-省", maxLength = 32)
	@Schema(description = "缴纳地-省" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-省" )
	private String socialProvince;
	/**
	 * 缴纳地-市
	 */
	@Length(max = 32, message = "缴纳地-市 不能超过32个字符" )
	@ExcelAttribute(name = "缴纳地-市", maxLength = 32)
	@Schema(description = "缴纳地-市" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-市" )
	private String socialCity;
	/**
	 * 缴纳地-县
	 */
	@Length(max = 32, message = "缴纳地-县 不能超过32个字符" )
	@ExcelAttribute(name = "缴纳地-县", maxLength = 32)
	@Schema(description = "缴纳地-县" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳地-县" )
	private String socialTown;
	/**
	 * 备注
	 */
	@Length(max = 255, message = "备注 不能超过255个字符" )
	@ExcelAttribute(name = "备注", maxLength = 255)
	@Schema(description = "备注" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备注" )
	private String remark;
	/**
	 * 0为删除1删除
	 */
	@Length(max = 1, message = "0为删除1删除 不能超过1个字符" )
	@ExcelAttribute(name = "0为删除1删除", maxLength = 1)
	@Schema(description = "0为删除1删除" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("0为删除1删除" )
	private String deleteFlag;
	/**
	 * 单位养老金额
	 */
	@ExcelAttribute(name = "单位养老金额" )
	@Schema(description = "单位养老金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老金额" )
	private BigDecimal unitPersionMoney;
	/**
	 * 单位医疗金额
	 */
	@ExcelAttribute(name = "单位医疗金额" )
	@Schema(description = "单位医疗金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗金额" )
	private BigDecimal unitMedicalMoney;
	/**
	 * 单位失业
	 */
	@ExcelAttribute(name = "单位失业" )
	@Schema(description = "单位失业" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业" )
	private BigDecimal unitUnemploymentMoney;
	/**
	 * 单位工伤金额
	 */
	@ExcelAttribute(name = "单位工伤金额" )
	@Schema(description = "单位工伤金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤金额" )
	private BigDecimal unitInjuryMoney;
	/**
	 * 单位生育金额
	 */
	@ExcelAttribute(name = "单位生育金额" )
	@Schema(description = "单位生育金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育金额" )
	private BigDecimal unitBirthMoney;
	/**
	 * 单位大病救助金额  (按定时时此值有数据)
	 */
	@ExcelAttribute(name = "单位大病救助金额" )
	@Schema(description = "单位大病救助金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病救助金额" )
	private BigDecimal unitBigailmentMoney;
	/**
	 * 个人养老金额
	 */
	@ExcelAttribute(name = "个人养老金额" )
	@Schema(description = "个人养老金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老金额" )
	private BigDecimal personalPersionMoney;
	/**
	 * 个人医疗金额
	 */
	@ExcelAttribute(name = "个人医疗金额" )
	@Schema(description = "个人医疗金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗金额" )
	private BigDecimal personalMedicalMoney;
	/**
	 * 个人失业金额
	 */
	@ExcelAttribute(name = "个人失业金额" )
	@Schema(description = "个人失业金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业金额" )
	private BigDecimal personalUnemploymentMoney;
	/**
	 * 个人大病金额(按定时时此值有数据)
	 */
	@ExcelAttribute(name = "个人大病金额" )
	@Schema(description = "个人大病金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病金额" )
	private BigDecimal personalBigailmentMoney;
	/**
	 * 大病取值方式 0.按定值1比例
	 */
	@Length(max = 1, message = "大病取值方式 0.按定值1比例 不能超过1个字符" )
	@ExcelAttribute(name = "大病取值方式 0.按定值1比例", maxLength = 1)
	@Schema(description = "大病取值方式 0.按定值1比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病取值方式 0.按定值1比例" )
	private String valueType;
	/**
	 * 个人大病比例
	 */
	@ExcelAttribute(name = "个人大病比例" )
	@Schema(description = "个人大病比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病比例" )
	private BigDecimal personalBigailmentPer;
	/**
	 * 单位大病救助比例
	 */
	@ExcelAttribute(name = "单位大病救助比例" )
	@Schema(description = "单位大病救助比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病救助比例" )
	private BigDecimal unitBigailmentPer;
	/**
	 * 是否收取大病费用: 0收取；1不收取
	 */
	@Length(max = 1, message = "是否收取大病费用0收取；1不收取 不能超过1个字符" )
	@ExcelAttribute(name = "是否收取大病费用0收取；1不收取", maxLength = 1)
	@Schema(description = "是否收取大病费用0收取；1不收取" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否收取大病费用0收取；1不收取" )
	private String isIllness;
	/**
	 * 大病按年收收取月份1-12月
	 */
	@ExcelAttribute(name = "大病按年收收取月份1-12月" )
	@Schema(description = "大病按年收收取月份1-12月" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病按年收收取月份1-12月" )
	private Integer collectMoth;
	/**
	 * 0按年1按月
	 */
	@Length(max = 1, message = "0按年1按月 不能超过1个字符" )
	@ExcelAttribute(name = "0按年1按月", maxLength = 1)
	@Schema(description = "0按年1按月" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("0按年1按月" )
	private String collectType;
	/**
	 * 流程实例ID
	 */
	@Length(max = 20, message = "流程实例ID 不能超过20个字符" )
	@ExcelAttribute(name = "流程实例ID", maxLength = 20)
	@Schema(description = "流程实例ID" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("流程实例ID" )
	private String processInstId;
	/**
	 * 审核人
	 */
	@Length(max = 32, message = "审核人 不能超过32个字符" )
	@ExcelAttribute(name = "审核人", maxLength = 32)
	@Schema(description = "审核人" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核人" )
	private String auditUser;
	/**
	 * 审核时间
	 */
	@ExcelAttribute(name = "审核时间", isDate = true)
	@Schema(description = "审核时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核时间" )
	private Date auditTime;
	/**
	 * 办理人
	 */
	@Length(max = 32, message = "办理人 不能超过32个字符" )
	@ExcelAttribute(name = "办理人", maxLength = 32)
	@Schema(description = "办理人" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("办理人" )
	private String handleUser;
	/**
	 * 办理时间
	 */
	@ExcelAttribute(name = "办理时间", isDate = true)
	@Schema(description = "办理时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("办理时间" )
	private Date handleTime;
	/**
	 * 所属单位
	 */
	@Length(max = 32, message = "所属单位 不能超过32个字符" )
	@ExcelAttribute(name = "所属单位", maxLength = 32)
	@Schema(description = "所属单位" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所属单位" )
	private String belongUnit;
	/**
	 * 社保停缴日期
	 */
	@ExcelAttribute(name = "社保停缴日期", isDate = true)
	@Schema(description = "社保停缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保停缴日期" )
	private Date socialReduceDate;
	/**
	 * 是否可补缴 0：是，1：否
	 */
	@Length(max = 1, message = "是否可补缴 0：是，1：否 不能超过1个字符" )
	@ExcelAttribute(name = "是否可补缴 0：是，1：否", maxLength = 1)
	@Schema(description = "是否可补缴 0：是，1：否" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否可补缴 0：是，1：否" )
	private String canOverpay;
	/**
	 * 补缴期限
	 */
	@ExcelAttribute(name = "补缴期限" )
	@Schema(description = "补缴期限" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("补缴期限" )
	private Integer overpayNumber;
	/**
	 * 是否含当月 0：是，1：否
	 */
	@Length(max = 1, message = "是否含当月 0：是，1：否 不能超过1个字符" )
	@ExcelAttribute(name = "是否含当月 0：是，1：否", maxLength = 1)
	@Schema(description = "是否含当月 0：是，1：否" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否含当月 0：是，1：否" )
	private String haveThisMonth;
	/**
	 * 是否能补缴养老0是1否
	 */
	@Length(max = 1, message = "是否能补缴养老0是1否 不能超过1个字符" )
	@ExcelAttribute(name = "是否能补缴养老0是1否", maxLength = 1)
	@Schema(description = "是否能补缴养老0是1否" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否能补缴养老0是1否" )
	private String insurancePension;
	/**
	 * 是否能补缴医疗0是1否
	 */
	@Length(max = 1, message = "是否能补缴医疗0是1否 不能超过1个字符" )
	@ExcelAttribute(name = "是否能补缴医疗0是1否", maxLength = 1)
	@Schema(description = "是否能补缴医疗0是1否" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否能补缴医疗0是1否" )
	private String insuranceMedical;
	/**
	 * 是否能补缴失业0是1否
	 */
	@Length(max = 1, message = "是否能补缴失业0是1否 不能超过1个字符" )
	@ExcelAttribute(name = "是否能补缴失业0是1否", maxLength = 1)
	@Schema(description = "是否能补缴失业0是1否" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否能补缴失业0是1否" )
	private String insuranceUnemployment;
	/**
	 * 是否能补缴工伤0是1否
	 */
	@Length(max = 1, message = "是否能补缴工伤0是1否 不能超过1个字符" )
	@ExcelAttribute(name = "是否能补缴工伤0是1否", maxLength = 1)
	@Schema(description = "是否能补缴工伤0是1否" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否能补缴工伤0是1否" )
	private String insuranceInjury;
	/**
	 * 是否能补缴生育0是1否
	 */
	@Length(max = 1, message = "是否能补缴生育0是1否 不能超过1个字符" )
	@ExcelAttribute(name = "是否能补缴生育0是1否", maxLength = 1)
	@Schema(description = "是否能补缴生育0是1否" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否能补缴生育0是1否" )
	private String insuranceBirth;
	/**
	 * 是否能补缴大病0是1否
	 */
	@Length(max = 1, message = "是否能补缴大病0是1否 不能超过1个字符" )
	@ExcelAttribute(name = "是否能补缴大病0是1否", maxLength = 1)
	@Schema(description = "是否能补缴大病0是1否" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否能补缴大病0是1否" )
	private String insuranceBigailment;
	/**
	 * 补缴是否采用最新基数0是1否
	 */
	@Length(max = 1, message = "补缴是否采用最新基数0是1否 不能超过1个字符" )
	@ExcelAttribute(name = "补缴是否采用最新基数0是1否", maxLength = 1)
	@Schema(description = "补缴是否采用最新基数0是1否" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("补缴是否采用最新基数0是1否" )
	private String insuranceIsLatestCardinality;

	/**
	 * 补缴政策
	 */
	@Length(max = 255, message = "补缴政策不能超过255个字符" )
	@ExcelAttribute(name = "补缴政策", maxLength = 255)
	@Schema(description = "补缴政策" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("补缴政策" )
	private String payPolicy;
	/**
	 * 派减办理人
	 */
	@Length(max = 32, message = "派减办理人 不能超过32个字符" )
	@ExcelAttribute(name = "派减办理人", maxLength = 32)
	@Schema(description = "派减办理人" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("派减办理人" )
	private String reduceHandleUser;
	/**
	 * 派减办理时间
	 */
	@ExcelAttribute(name = "派减办理时间", isDate = true)
	@Schema(description = "派减办理时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("派减办理时间" )
	private Date reduceHandleTime;
	/**
	 * 收费模式：0立即收1次年收
	 */
	@Length(max = 1, message = "收费模式 不能超过1个字符" )
	@ExcelAttribute(name = "收费模式", maxLength = 1)
	@Schema(description = "收费模式：0立即收1次年收" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收费模式" )
	private String isChargePersonal;
	/**
	 * 委托备注
	 */
	@Length(max = 100, message = "委托备注 不能超过100个字符" )
	@ExcelAttribute(name = "委托备注", maxLength = 100)
	@Schema(description = "委托备注" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("委托备注" )
	private String trustRemark;
	/**
	 * 是否可派减 0:是1：否
	 */
	@NotBlank(message = "是否可派减 0:是1：否不能为空" )
	@Length(max = 1, message = "是否可派减 0:是1：否 不能超过1个字符" )
	@ExcelAttribute(name = "是否可派减 0:是1：否", isNotEmpty = true, errorInfo = "是否可派减 0:是1：否不能为空", maxLength = 1)
	@Schema(description = "是否可派减 0:是1：否" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否可派减 0:是1：否" )
	private String reduceCan;
	/**
	 * 就职班组
	 */
	@Length(max = 50, message = "就职班组 不能超过50个字符" )
	@ExcelAttribute(name = "就职班组", maxLength = 50)
	@Schema(description = "就职班组" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("就职班组" )
	private String inauguralTeam;
	/**
	 * 电信编号
	 */
	@Length(max = 50, message = "电信编号 不能超过50个字符" )
	@ExcelAttribute(name = "电信编号", maxLength = 50)
	@Schema(description = "电信编号" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("电信编号" )
	private String telecomNumber;
	/**
	 * 缴纳类型（0最低、1自定义、2最高）
	 */
	@Length(max = 1, message = "缴纳类型（0最低、1自定义、2最高） 不能超过1个字符" )
	@ExcelAttribute(name = "缴纳类型（0最低、1自定义、2最高）", maxLength = 1)
	@Schema(description = "缴纳类型（0最低、1自定义、2最高）" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳类型（0最低、1自定义、2最高）" )
	private String paymentType;
	/**
	 * 备案基数
	 */
	@Length(max = 255, message = "备案基数 不能超过255个字符" )
	@ExcelAttribute(name = "备案基数", maxLength = 255)
	@Schema(description = "备案基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备案基数" )
	private String recordBase;
	/**
	 * 社保类型区分（0五险、1单独兼职工伤）
	 */
	@ExcelAttribute(name = "社保类型区分（0五险、1单独兼职工伤）" )
	@Schema(description = "社保类型区分（0五险、1单独兼职工伤）" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保类型区分（0五险、1单独兼职工伤）" )
	private Integer socialType;

	/**
	 * 养老起缴日期
	 */
	@ExcelAttribute(name = "养老起缴日期", isDate = true)
	@Schema(description = "养老起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老起缴日期" )
	private Date pensionStart;
	/**
	 * 医疗起缴日期
	 */
	@ExcelAttribute(name = "医疗起缴日期", isDate = true)
	@Schema(description = "医疗起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗起缴日期" )
	private Date medicalStart;
	/**
	 * 失业起缴日期
	 */
	@ExcelAttribute(name = "失业起缴日期", isDate = true)
	@Schema(description = "失业起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业起缴日期" )
	private Date unemployStart;
	/**
	 * 工伤起缴日期
	 */
	@ExcelAttribute(name = "工伤起缴日期", isDate = true)
	@Schema(description = "工伤起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤起缴日期" )
	private Date workInjuryStart;
	/**
	 * 生育起缴日期
	 */
	@ExcelAttribute(name = "生育起缴日期", isDate = true)
	@Schema(description = "生育起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育起缴日期" )
	private Date birthStart;
	/**
	 * 大病起缴日期
	 */
	@ExcelAttribute(name = "大病起缴日期", isDate = true)
	@Schema(description = "大病起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病起缴日期" )
	private Date bigailmentStart;
	/**
	 * 养老办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "养老办理状态：0待办理1办理成功2办理失败3已派减 不能超过1个字符" )
	@ExcelAttribute(name = "养老办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "养老办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老办理状态：0待办理1办理成功2办理失败3已派减" )
	private String pensionHandle;
	/**
	 * 医疗办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "医疗办理状态：0待办理1办理成功2办理失败3已派减 不能超过1个字符" )
	@ExcelAttribute(name = "医疗办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "医疗办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗办理状态：0待办理1办理成功2办理失败3已派减" )
	private String medicalHandle;
	/**
	 * 失业办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "失业办理状态：0待办理1办理成功2办理失败3已派减 不能超过1个字符" )
	@ExcelAttribute(name = "失业办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "失业办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业办理状态：0待办理1办理成功2办理失败3已派减" )
	private String unemployHandle;
	/**
	 * 工伤办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "工伤办理状态：0待办理1办理成功2办理失败3已派减 不能超过1个字符" )
	@ExcelAttribute(name = "工伤办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "工伤办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤办理状态：0待办理1办理成功2办理失败3已派减" )
	private String workInjuryHandle;
	/**
	 * 生育办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "生育办理状态：0待办理1办理成功2办理失败3已派减 不能超过1个字符" )
	@ExcelAttribute(name = "生育办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "生育办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育办理状态：0待办理1办理成功2办理失败3已派减" )
	private String birthHandle;
	/**
	 * 大病办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "大病办理状态：0待办理1办理成功2办理失败3已派减 不能超过1个字符" )
	@ExcelAttribute(name = "大病办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "大病办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病办理状态：0待办理1办理成功2办理失败3已派减" )
	private String bigailmentHandle;
	/**
	 * 基数上限（社保或公积金）
	 */
	@ExcelAttribute(name = "基数上限（社保或公积金）")
	@Schema(description = "基数上限（社保或公积金）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("基数上限（社保或公积金）")
	private BigDecimal upperLimit;

	/**
	 * 基数下限（社保或公积金）
	 */
	@ExcelAttribute(name = "基数下限（社保或公积金）")
	@Schema(description = "基数下限（社保或公积金）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("基数下限（社保或公积金）")
	private BigDecimal lowerLimit;


	/**
	 * 单位社保合计
	 */
	@ExcelAttribute(name = "单位社保合计" )
	@Schema(description ="单位社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位社保合计")
	private BigDecimal unitSocialSum;

	/**
	 * 个人社保合计
	 */
	@ExcelAttribute(name = "个人社保合计" )
	@Schema(description ="个人社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人社保合计")
	private BigDecimal personalSocialSum;
}
