package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author fxj
 * @Description 社保办理导出花名册
 * @Date 19:25 2022/7/27
 * @Param
 * @return
**/
@Data
public class FundHandleExportVo implements Serializable {


	/**
     * 派单类型：0派增1派减
     */
    @ExcelAttribute(name = "派单类型",  errorInfo = "派单类型不能为空", maxLength = 1,isDataId = true,readConverterExp = "0=派增,1=派减",needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("派单类型" )
	private String type;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名",  errorInfo = "员工姓名不能为空", maxLength = 50,needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名" )
	private String empName;

	/**
	 * 员工身份证
	 */
	@ExcelAttribute(name = "身份证号",  errorInfo = "身份证号不能为空", maxLength = 20,needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号" )
	private String empIdcard;
	/**
	 * 所属单位
	 */
	@ExcelAttribute(name = "客户名称", isNotEmpty = true,needExport = true)
	@Schema(description = "客户名称（所属单位）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称" )
	private String belongUnit;

	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称",  isNotEmpty = true,needExport = true)
	@Schema(description = "项目名称（项目）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称" )
	private String settleDomain;

	/**
	 * 手机号码
	 */
	@ExcelAttribute(name = "手机号码", maxLength = 20,needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号码" )
	private String empMobile;
	/**
	 * 创建人姓名
	 */
	@ExcelAttribute(name = "申请人",needExport = true)
	@Schema(description = "申请人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申请人" )
	private String createUserName;
    /**
     *  公积金缴纳地-省
     */
    @ExcelAttribute(name = "公积金缴纳地-省",   maxLength = 32,  isArea = true, needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-省" )
	private String fundProvince;
    /**
     *  公积金缴纳地-市
     */
    @ExcelAttribute(name = "公积金缴纳地-市",   maxLength = 32, isArea = true, parentField = "fundProvince",needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-市" )
	private String fundCity;
    /**
     *  公积金缴纳地-县
     */
    @ExcelAttribute(name = "公积金缴纳地-县", maxLength = 32,  isArea = true, parentField = "fundCity",needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-县" )
	private String fundTown;
    /**
     * 公积金起缴日期
     */
	@DateTimeFormat("yyyy-MM-dd")
    @ExcelAttribute(name = "公积金起缴日期",    errorInfo = "公积金起缴日期不能为空",needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金起缴日期" )
	private LocalDateTime providentStart;
    /**
     * 单位公积金缴纳基数
     */
    @ExcelAttribute(name = "单位公积金缴纳基数",   errorInfo = "单位公积金缴纳基数不能为空",needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金缴纳基数" )
	private BigDecimal unitProvidengCardinal;
    /**
     * 单位公积金缴纳比例
     */
    @ExcelAttribute(name = "单位公积金缴纳比例",  errorInfo = "单位公积金缴纳比例不能为空",needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金缴纳比例" )
	private BigDecimal unitProvidentPer;
    /**
     * 单位公积金缴纳费用
     */
    @ExcelAttribute(name = "单位公积金缴纳费用", isNotEmpty = true, errorInfo = "单位公积金缴纳费用不能为空",needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金缴纳费用" )
	private BigDecimal unitProvidentFee;
    /**
     * 个人公积金缴纳基数
     */
    @ExcelAttribute(name = "个人公积金缴纳基数",  errorInfo = "个人公积金缴纳基数不能为空",needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金缴纳基数" )
	private BigDecimal personalProvidentCardinal;
    /**
     * 个人公积金缴纳比例
     */
    @ExcelAttribute(name = "个人公积金缴纳比例",  errorInfo = "个人公积金缴纳比例不能为空",needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金缴纳比例" )
	private BigDecimal personalProvidentPer;
    /**
     * 个人公积金缴纳费用
     */
    @ExcelAttribute(name = "个人公积金缴纳费用", isNotEmpty = true, errorInfo = "个人公积金缴纳费用不能为空",needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金缴纳费用" )
	private BigDecimal personalProvidentFee;
    /**
     * 公积金户
     */
    @ExcelAttribute(name = "公积金户",    errorInfo = "公积金户不能为空", maxLength = 50,needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户" )
	private String providentHouseholdName;
    /**
     *
     *委托备注
     **/
    @ExcelAttribute(name = "委托备注",needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("委托备注" )
    private String fundTrustRemark;

/*******************************导出字段结束*************************************************/

}
