package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author fxj
 * @Description 社保办理导出花名册
 * @Date 15:21 2022/7/27
 * @Param 
 * @return 
**/
@Data
public class SocialHandleExportVo implements Serializable {

    /**
     * 派单类型：0派增1派减
     */
    @ExcelAttribute(name = "派单类型",  errorInfo = "派单类型不能为空", maxLength = 1,isDataId = true, readConverterExp = "0=派增,1=派减",needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("派单类型" )
    private String type;

    /**
     * 社保办理状态 0 未办理 1 全部办理成功(原-已办理) 2 全部办理失败（原-办理失败） 3已派减 4办理中 （20210609派单拆分新增fxj） 5部分办理失败
     */
    @Schema(description = "社保办理状态")
    @ExcelAttribute(name = "社保办理状态", readConverterExp = "0=未办理,1=全部办理成功,2=全部办理失败,3=已派减,4=办理中,5=部分办理失败", needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保办理状态" )
    private String socialHandleStatus;

    /**
     * 养老办理状态：0待办理1办理成功2办理失败3已派减
     */
    @ExcelAttribute(name = "养老状态" , maxLength = 1 , readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减,null=——", needExport = true)
    @Schema(description="养老办理状态：0待办理1办理成功2办理失败3已派减")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老状态" )
    private String pensionHandle;
    /**
     * 医疗办理状态：0待办理1办理成功2办理失败3已派减
     */
    @ExcelAttribute(name = "医疗状态" , maxLength = 1 , readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减,null=——", needExport = true)
    @Schema(description="医疗办理状态：0待办理1办理成功2办理失败3已派减")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗状态" )
	private String medicalHandle;
    /**
     * 失业办理状态：0待办理1办理成功2办理失败3已派减
     */
    @ExcelAttribute(name = "失业状态" , maxLength = 1 , readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减,null=——", needExport = true)
    @Schema(description="失业办理状态：0待办理1办理成功2办理失败3已派减")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业状态" )
    private String unemployHandle;
    /**
     * 工伤办理状态：0待办理1办理成功2办理失败3已派减
     */
    @ExcelAttribute(name = "工伤状态" , maxLength = 1 , readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减,null=——", needExport = true)
    @Schema(description="工伤办理状态：0待办理1办理成功2办理失败3已派减")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤状态" )
    private String workInjuryHandle;
    /**
     * 生育办理状态：0待办理1办理成功2办理失败3已派减
     */
    @ExcelAttribute(name = "生育状态" , maxLength = 1 , readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减,null=——", needExport = true)
    @Schema(description="生育办理状态：0待办理1办理成功2办理失败3已派减")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育状态" )
    private String birthHandle;
    /**
     * 大病办理状态：0待办理1办理成功2办理失败3已派减
     */
    @ExcelAttribute(name = "大病状态" , maxLength = 1 , readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减,null=——", needExport = true)
    @Schema(description="大病办理状态：0待办理1办理成功2办理失败3已派减")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病状态" )
    private String bigailmentHandle;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名",  errorInfo = "员工姓名不能为空", maxLength = 50,needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名" )
	private String empName;

	/**
	 * 员工身份证
	 */
	@ExcelAttribute(name = "员工身份证",  errorInfo = "员工身份证不能为空", maxLength = 20,needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工身份证" )
	private String empIdcard;

	/**
	 * 学历
	 */
	@ExcelAttribute(name = "学历", maxLength = 32,needExport = true)
	@Schema(description = "学历")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("学历" )
	private String educationName;

	/**
	 * 所属单位
	 */
	@ExcelAttribute(name = "客户名称", isNotEmpty = true,needExport = true)
	@Schema(description = "客户名称（所属单位）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称" )
	private String belongUnit;

	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称",  isNotEmpty = true,needExport = true)
	@Schema(description = "项目名称（项目）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称" )
	private String settleDomain;
	/**
	 * 员工类型
	 */
	@ExcelAttribute(name = "员工类型",  errorInfo = "员工类型不能为空",  isDataId = true,dataType = ExcelAttributeConstants.EMP_NATRUE,needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工类型" )
	private String empType;
	/**
	 * 就职岗位
	 */
	@ExcelAttribute(name = "岗位", maxLength = 50,needExport = true)
	@Schema(description = "岗位")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("岗位" )
	private String post;

	/**
	 * 员工电话
	 */
	@ExcelAttribute(name = "手机号码", maxLength = 20,needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号码" )
	private String empMobile;
	/**
	 * 户口性质
	 */
	@ExcelAttribute(name = "户口性质", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.EMP_REGISTYPE,needExport = true)
	@Schema(description = "户口性质")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("户口性质" )
	private String empRegisType;

	/**
	 * 民族
	 */
	@ExcelAttribute(name = "民族", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.EMP_NATIONAL,needExport = true)
	@Schema(description = "民族")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("民族" )
	private String empNational;

	/**
	 * 工时制（数据字典） 1标准工时 2 综合工时 3不定时工时制
	 */
	@ExcelAttribute(name = "工时制", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.WORKING_HOURS,needExport = true)
	@Schema(description = "工时制")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工时制" )
	private String workingHours;

	/**
	 * 合同年限
	 */
	@ExcelAttribute(name = "合同年限",  errorInfo = "合同年限不能为空",needExport = true)
	@Schema(description = "合同年限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同年限" )
	private Double contractTerm;
	/**
	 * 合同起始时间
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "合同起始时间",  errorInfo = "合同起始时间不能为空",dateFormat = DateUtil.ISO_DATE_FORMAT,needExport = true)
	@Schema(description = "合同起始时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同起始时间" )
	private Date contractStart;
	/**
	 * 合同到期时间
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "合同到期时间",needExport = true,dateFormat = DateUtil.ISO_DATE_FORMAT)
	@Schema(description = "合同到期时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同到期时间" )
	private Date contractEnd;
	/**
	 * 创建人姓名
	 */
	@ExcelAttribute(name = "申请人",needExport = true)
	@Schema(description = "申请人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申请人" )
	private String createUserName;

	/**
	 * 备案基数
	 */
	@ExcelAttribute(name = "备案基数",needExport = true)
	@Schema(description = "备案基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备案基数" )
	private String recordBase;

	/**
	 * 缴纳类型（0最低、1自定义、2最高）
	 */
	@ExcelAttribute(name = "缴纳类型",isDataId = true,readConverterExp = "0=最低,1=自定义,2=最高",needExport = true)
	@Schema(description = "缴纳类型（0最低、1自定义、2最高）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳类型" )
	private String paymentType;
	/**
	 * 社保户
	 */
	@ExcelAttribute(name = "社保户", needExport = true)
	@Schema(description = "社保户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户" )
	private String socialHouseholdName;
	/**
	 *  缴纳地-省
	 */
	@ExcelAttribute(name = "社保缴纳地-省",  maxLength = 32,isArea = true,needExport = true)
	@Schema(description = "社保缴纳地-省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-省" )
	private String socialProvince;
	/**
	 *  缴纳地-市
	 */
	@ExcelAttribute(name = "社保缴纳地-市",    maxLength = 32, isArea = true, parentField = "socialProvince",needExport = true)
	@Schema(description = "社保缴纳地-市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-市" )
	private String socialCity;
	/**
	 *  缴纳地-县
	 */
	@ExcelAttribute(name = "社保缴纳地-县",   maxLength = 32, isArea = true, parentField = "socialCity",needExport = true)
	@Schema(description = "社保缴纳地-县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-县" )
	private String socialTown;
	/**
	 * 养老起缴日期
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "养老起缴日期", needExport = true)
	@Schema(description="养老起缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老起缴日期" )
	private Date pensionStart;;

	/**
	 * 养老基数
	 */
	@ExcelAttribute(name = "养老基数", isFloat = true,needExport = true)
	@Schema(description = "养老基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老基数" )
	private BigDecimal unitPensionCardinal;

    /**
     * 医疗起缴日期
     */
	@DateTimeFormat("yyyy-MM-dd")
    @ExcelAttribute(name = "医疗起缴日期", needExport = true)
    @Schema(description="医疗起缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗起缴日期" )
    private Date medicalStart;
	/**
	 * 医疗基数
	 */
	@ExcelAttribute(name = "医疗基数",isFloat = true,needExport = true)
	@Schema(description = "医疗基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗基数" )
	private BigDecimal unitMedicalCardinal;
    /**
     * 失业起缴日期
     */
	@DateTimeFormat("yyyy-MM-dd")
    @ExcelAttribute(name = "失业起缴日期", needExport = true)
    @Schema(description="失业起缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业起缴日期" )
    private Date unemployStart;
	/**
	 * 失业基数
	 */
	@ExcelAttribute(name = "失业基数", isFloat = true,needExport = true)
	@Schema(description = "失业基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业基数" )
	private BigDecimal unitUnemploymentCardinal;
    /**
     * 工伤起缴日期
     */
	@DateTimeFormat("yyyy-MM-dd")
    @ExcelAttribute(name = "工伤起缴日期", needExport = true)
    @Schema(description="工伤起缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤起缴日期" )
    private Date workInjuryStart;
	/**
	 * 工伤基数
	 */
	@ExcelAttribute(name = "工伤基数", isFloat = true,needExport = true)
	@Schema(description = "工伤基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤基数" )
	private BigDecimal unitWorkInjuryCardinal;
    /**
     * 生育起缴日期
     */
	@DateTimeFormat("yyyy-MM-dd")
    @ExcelAttribute(name = "生育起缴日期", needExport = true)
    @Schema(description="生育起缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育起缴日期" )
    private Date birthStart;
	/**
	 * 生育基数
	 */
	@ExcelAttribute(name = "生育基数", isFloat = true,needExport = true)
	@Schema(description = "生育基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育基数" )
	private BigDecimal unitBirthCardinal;
    /**
     * 大病起缴日期
     */
	@DateTimeFormat("yyyy-MM-dd")
    @ExcelAttribute(name = "大病起缴日期", needExport = true)
    @Schema(description="大病起缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病起缴日期" )
    private Date bigailmentStart;
	/**
	 * 大病缴纳基数
	 */
	@ExcelAttribute(name = "大病缴纳基数" )
	@Schema(description="大病缴纳基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病缴纳基数" )
	private BigDecimal unitBigailmentCardinal;
	/**
	 * 单位大病缴纳金额
	 */
	@ExcelAttribute(name = "单位大病金额",needExport = true)
	@Schema(description = "单位大病金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病金额" )
	private BigDecimal unitBigailmentMoney;
	/**
	 * 个人大病金额
	 */
	@ExcelAttribute(name = "个人大病金额",needExport = true)
	@Schema(description = "个人大病金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病金额" )
	private BigDecimal personalBigailmentMoney;
	/**
	 *
	 *委托备注
	 **/
	@ExcelAttribute(name = "委托备注",needExport = true)
	@Schema(description = "委托备注")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("委托备注" )
	private String socailTrustRemark;
	/**
	 * 减少原因
	 */
	@ExcelAttribute(name = "减少原因" ,needExport = true , isDataId = true, dataType = ExcelAttributeConstants.REDUCE_SOCIAL_REASON)
	@Schema(description="减少原因")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("减少原因" )
	private String reduceReason;

}
