/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 派单导出Vo
 * @author hgw
 * @date 2022-7-28 10:40:34
 */
@Data
@Schema(description = "派单导出Vo")
public class TDispatchInfoExportVo {

	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;

	@ExcelAttribute(name = "申请编码", maxLength = 30)
	@Schema(description = "申请编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申请编码")
	private String applyNo;

	@ExcelAttribute(name = "员工编码", maxLength = 30)
	@Schema(description = "员工编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工编码")
	private String empNo;

	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;

	@ExcelAttribute(name = "身份证号", maxLength = 20)
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;

	@ExcelAttribute(name = "员工类型", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATRUE)
	@Schema(description = "员工类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工类型")
	private String empType;

	@ExcelAttribute(name = "社保公积金类型", readConverterExp = "0=社保,1=公积金")
	@Schema(description = "社保公积金类型：0社保1公积金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保公积金类型")
	private String typeSub;

	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Schema(description = "客户名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String belongUnitName;

	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Schema(description = "项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String settleDomainName;

	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Schema(description = "项目编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	private String settleDomainCode;

	@ExcelAttribute(name = "派单类型", readConverterExp = "0=增加派单,1=减少派单")
	@Schema(description = "派单类型：0派增1派减")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("派单类型")
	private String type;

	@ExcelAttribute(name = "派单项", maxLength = 50)
	@Schema(description = "派单项：如 养老、公积金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("派单项")
	private String dispatchItem;

	@ExcelAttribute(name = "社保户", maxLength = 50)
	@Schema(description = "社保户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户")
	private String socialHouseholdName;

	@ExcelAttribute(name = "公积金户", maxLength = 50)
	@Schema(description = "公积金户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户")
	private String providentHouseholdName;

	@ExcelAttribute(name = "审核状态", readConverterExp = "1=待审核,2=审核通过,3=审核不通过,4=已办结")
	@Schema(description = "审核状态：1待审核2审核通过3审核不通过4已办结")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核状态")
	private String status;

	@ExcelAttribute(name = "社保办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=部分办理成功,4=办理中")
	@Schema(description = "社保办理状态 0 待办理 1 办理成功 2 办理失败 3 部分办理成功 4 办理中")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保办理状态")
	private String socialHandleStatus;

	@ExcelAttribute(name = "养老状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "养老办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老状态" )
	private String pensionHandle;

	@ExcelAttribute(name = "医疗状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "医疗状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗状态" )
	private String medicalHandle;

	@ExcelAttribute(name = "失业状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "失业办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业状态" )
	private String unemployHandle;

	@ExcelAttribute(name = "工伤状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "工伤状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤状态" )
	private String workInjuryHandle;

	@ExcelAttribute(name = "生育状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "生育状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育状态" )
	private String birthHandle;

	@ExcelAttribute(name = "大病状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "大病状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病状态" )
	private String bigailmentHandle;

	@ExcelAttribute(name = "公积金办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "公积金办理状态:0 待办理 1办理成功 2 办理失败 3 已派减")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金办理状态")
	private String fundHandleStatus;

	@Schema(description = "申请人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申请人")
	private String createName;

	@ExcelAttribute(name = "申请人所在部门", maxLength = 50)
	@Schema(description = "申请人所在部门")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申请人所在部门")
	private String organName;

	@Schema(description = "申请时间")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申请时间")
	private LocalDateTime createTime;

}
