/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 收入明细表
 *
 * @author hgw
 * @date 2022-08-30 17:34:58
 */
@Data
public class TIncomeSearchVo extends BaseEntity implements Serializable {
	private static final long serialVersionUID = -4692341622141432288L;

	/**
	 * id
	 */
	@Schema(description = "id")
	private String id;

	/**
	 * 多选导出或删除等操作
	 */
	@Schema(description = "选中ID,多个逗号分割")
	private String ids;

	/**
	 * 创建时间区间 [开始时间，结束时间]
	 */
	@Schema(description = "创建时间区间")
	private LocalDateTime[] createTimes;
	/**
	 * @Author fxj
	 * 查询数据起
	 **/
	@Schema(description = "查询limit  开始")
	private int limitStart;
	/**
	 * @Author fxj
	 * 查询数据止
	 **/
	@Schema(description = "查询limit  数据条数")
	private int limitEnd;

	/**
	 * 菜单ID 获取查询权限使用
	 */
	@TableField(exist = false)
	private String mId;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@Schema(description = "身份证号")
	private String empIdcard;
	/**
	 * 客户id
	 */
	@Schema(description = "客户id")
	private String unitId;
	/**
	 * 客户名称
	 */
	@Schema(description = "客户名称")
	private String unitName;
	/**
	 * 客户编码
	 */
	@Schema(description = "客户编码")
	private String unitNo;
	/**
	 * 项目id
	 */
	@Schema(description = "项目id")
	private String deptId;
	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;
	/**
	 * 费用类型：1管理费2风险金
	 */
	@Schema(description = "费用类型：1管理费2风险金")
	private String feeType;
	/**
	 * 收费方式：1按比例2金额-人数3金额-人次
	 */
	@Schema(description = "收费方式：1按比例2金额-人数3金额-人次")
	private String feeMode;
	/**
	 * 收费标准
	 */
	@Schema(description = "收费标准")
	private String charges;
	/**
	 * 收入来源：1社保2公积金3商险4薪资
	 */
	@Schema(description = "收入来源")
	private String sourceType;
	/**
	 * 金额
	 */
	@Schema(description = "金额")
	private BigDecimal money;
	/**
	 * 生成月份
	 */
	@Schema(description = "生成月份")
	private String createMonth;
	/**
	 * 缴纳月份
	 */
	@Schema(description = "缴纳月份")
	private String payMonth;
	/**
	 * 数据生成月份
	 */
	@Schema(description = "数据生成月份")
	private String dataCreateMonth;

	/**
	 * 红冲：0否1是
	 */
	@Schema(description = "红冲：0否1是")
	private String redData;

	/**
	 * 推送状态：0未推送1已推送
	 */
	@Schema(description = "送状态：0未推送1已推送")
	private String sendStatus;

	@Schema(description = "发送月份")
	private String sendMonth;

	@Schema(description = "发送时间")
	private Date sendTime;

	@Schema(description = "发送返回的EKPID")
	private String ekpId;
}
