package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.social.entity.TPreDispatchInfo;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class TPreDispatchUpdateVo extends TPreDispatchInfo {
    /**
     *
     */
    @ExcelAttribute(name = "主键", maxLength = 32)
    private String id;
    /**
     *  派单类型：0 派增  1 派减
     */
    @ExcelAttribute(name = "派单类型", maxLength = 2)
    private String type;
    /**
     * 日期，格式：2020-12-25
     */
    @ExcelAttribute(name = "日期", isDate = true)
    private String date;
    /**
     * 接单分公司
     */
    @Length(max = 50, message = "接单分公司不能超过50个字符")
    @ExcelAttribute(name = "接单分公司", maxLength = 50)
    private String company;
    /**
     * 缴费地
     */
    @Length(max = 20, message = "缴费地不能超过20个字符")
    @ExcelAttribute(name = "缴费地", isNotEmpty = true,errorInfo = "缴费地不能为空", maxLength = 20)
    private String payAddress;
    /**
     * 客户名称
     */
    @Length(max = 50, message = "客户名称不能超过50个字符")
    @ExcelAttribute(name = "客户名称", errorInfo = "客户名称不能为空", maxLength = 50)
    private String customerName;
    /**
     * 身份证号
     */
    @Length(max = 20, message = "身份证号不能超过20个字符")
    @ExcelAttribute(name = "身份证号", isNotEmpty = true,errorInfo = "身份证号不能为空", maxLength = 20, isIdCard = true)
    private String empIdcard;
    /**
     * 员工姓名
     */
    @Length(max = 15, message = "员工姓名不能超过15个字符")
    @ExcelAttribute(name = "员工姓名", isNotEmpty = true, maxLength = 15)
    private String empName;
    /**
     * 联系电话1
     */
    @Length(max = 11, message = "联系电话1不能超过11个字符")
    @ExcelAttribute(name = "联系电话1", maxLength = 11)
    private String telOne;
    /**
     * 联系电话2
     */
    @Length(max = 11, message = "联系电话2不能超过11个字符")
    @ExcelAttribute(name = "联系电话2", maxLength = 11)
    private String telTwo;
    /**
     * 入职日期
     */
    @ExcelAttribute(name = "入职日期", isDate = true)
    private String entryDate;
    /**
     * 正式工资
     */
    @ExcelAttribute(name = "正式工资", maxLength = 20)
    private String formalSalary;
    /**
     * 派遣开始日期
     */
    @Length(max = 20, message = "派遣开始日期不能超过20个字符")
    @ExcelAttribute(name = "派遣开始日期", maxLength = 20, isDate = true)
    private String dispatchStart;
    /**
     * 派遣结束日期
     */
    @Length(max = 20, message = "派遣结束日期不能超过20个字符")
    @ExcelAttribute(name = "派遣结束日期", maxLength = 20, isDate = true)
    private String dispatchEnd;
    /**
     * 合同开始日期
     */
    @Length(max = 20, message = "合同开始日期不能超过20个字符")
    @ExcelAttribute(name = "合同开始日期", maxLength = 20, isDate = true)
    private String contractStart;
    /**
     * 合同终止日期
     */
    @Length(max = 20, message = "合同终止日期不能超过20个字符")
    @ExcelAttribute(name = "合同终止日期", maxLength = 20, isDate = true)
    private String contractEnd;
    /**
     * 试用开始日期
     */
    @Length(max = 20, message = "试用开始日期不能超过20个字符")
    @ExcelAttribute(name = "试用开始日期", maxLength = 20, isDate = true)
    private String trialStart;
    /**
     * 试用结束日期
     */
    @Length(max = 20, message = "试用结束日期不能超过20个字符")
    @ExcelAttribute(name = "试用结束日期", maxLength = 20, isDate = true)
    private String trialEnd;
    /**
     * 试用期工资
     */
    @ExcelAttribute(name = "试用期工资", maxLength = 20)
    private String trialSalary;
    /**
     * 工作制
     */
    @Length(max = 20, message = "工作制不能超过20个字符")
    @ExcelAttribute(name = "工作制", maxLength = 20)
    private String workingSystem;
    /**
     * 合同版本
     */
    @Length(max = 20, message = "合同版本不能超过20个字符")
    @ExcelAttribute(name = "合同版本", maxLength = 20)
    private String contractVersion;
    /**
     * 是否电话通知
     */
    @Length(max = 10, message = "是否电话通知不能超过10个字符")
    @ExcelAttribute(name = "是否电话通知", maxLength = 10)
    private String telNotice;
    /**
     * 实际工作地
     */
    @Length(max = 20, message = "实际工作地不能超过20个字符")
    @ExcelAttribute(name = "实际工作地", maxLength = 20)
    private String workingAddress;
    /**
     * 备注说明1
     */
    @Length(max = 250, message = "备注说明1不能超过250个字符")
    @ExcelAttribute(name = "备注说明1", maxLength = 250)
    private String remarkOne;
    /**
     * 备注说明2
     */
    @Length(max = 250, message = "备注说明2不能超过250个字符")
    @ExcelAttribute(name = "备注说明2", maxLength = 250)
    private String remarkTwo;
    /**
     * 养老城市
     */
    @Length(max = 15, message = "养老城市不能超过15个字符")
    @ExcelAttribute(name = "养老城市", maxLength = 15)
    private String pensionAddress;
    /**
     * 养老基数
     */
    @ExcelAttribute(name = "养老基数",isFloat = true,max = "99999999.99")
    private BigDecimal pensionBase;
    /**
     * 养老起缴月
     */
    @Length(max = 6, message = "养老起缴月不能超过6个字符")
    @ExcelAttribute(name = "养老起缴月", maxLength = 6, min = 6, isInteger = true)
    private String pensionStart;
    /**
     * 医疗城市
     */
    @Length(max = 15, message = "医疗城市不能超过15个字符")
    @ExcelAttribute(name = "医疗城市", maxLength = 15)
    private String medicalAddress;
    /**
     * 医疗基数
     */
    @ExcelAttribute(name = "医疗基数", isFloat = true,max = "99999999.99")
    private BigDecimal medicalBase;
    /**
     * 医疗起缴月
     */
    @Length(max = 6, message = "医疗起缴月不能超过6个字符")
    @ExcelAttribute(name = "医疗起缴月", maxLength = 6, min = 6, isInteger = true)
    private String medicalStart;
    /**
     * 工伤城市
     */
    @Length(max = 15, message = "工伤城市不能超过15个字符")
    @ExcelAttribute(name = "工伤城市", maxLength = 15)
    private String injuryAddress;
    /**
     * 工伤基数
     */
    @ExcelAttribute(name = "工伤基数", isFloat = true,max = "99999999.99")
    private BigDecimal injuryBase;
    /**
     * 工伤起缴月
     */
    @Length(max = 6, message = "工伤起缴月不能超过6个字符")
    @ExcelAttribute(name = "工伤起缴月", maxLength = 6, min = 6, isInteger = true)
    private String injuryStart;
    /**
     * 生育城市
     */
    @Length(max = 15, message = "生育城市不能超过15个字符")
    @ExcelAttribute(name = "生育城市", maxLength = 15)
    private String birthAddress;
    /**
     * 生育基数
     */
    @ExcelAttribute(name = "生育基数", isFloat = true,max = "99999999.99")
    private BigDecimal birthBase;
    /**
     * 生育起缴月
     */
    @Length(max = 6, message = "生育起缴月不能超过6个字符")
    @ExcelAttribute(name = "生育起缴月", maxLength = 6, min = 6, isInteger = true)
    private String birthStart;
    /**
     * 失业城市
     */
    @Length(max = 15, message = "失业城市不能超过15个字符")
    @ExcelAttribute(name = "失业城市", maxLength = 15)
    private String unemploymentAddress;
    /**
     * 失业基数
     */
    @ExcelAttribute(name = "失业基数", isFloat = true,max = "99999999.99")
    private BigDecimal unemploymentBase;
    /**
     * 失业起缴月
     */
    @Length(max = 6, message = "失业起缴月不能超过6个字符")
    @ExcelAttribute(name = "失业起缴月", maxLength = 6, min = 6, isInteger = true)
    private String unemploymentStart;
    /**
     * 公积金城市
     */
    @Length(max = 15, message = "公积金城市不能超过15个字符")
    @ExcelAttribute(name = "公积金城市", maxLength = 15)
    private String fundAddress;
    /**
     * 公积金基数
     */
    @ExcelAttribute(name = "公积金基数", isFloat = true,max = "99999999.99")
    private BigDecimal fundBase;
    /**
     * 公积金起缴月
     */
    @Length(max = 6, message = "公积金起缴月不能超过6个字符")
    @ExcelAttribute(name = "公积金起缴月", maxLength = 6, min = 6, isInteger = true)
    private String fundStart;
    /**
     * 公积金个人比例
     */
    @ExcelAttribute(name = "公积金个人比例", isFloat = true,max = "100.00")
    private BigDecimal fundPersonalPer;
    /**
     * 公积金企业比例
     */
    @ExcelAttribute(name = "公积金企业比例", isFloat = true,max = "100.00")
    private BigDecimal fundCompanyPer;
    /**
     * 派单分公司
     */
    @Length(max = 50, message = "派单分公司不能超过20个字符")
    @ExcelAttribute(name = "派单分公司", maxLength = 20)
    private String dispatchCompany;
    /**
     * 派单客服
     */
    @Length(max = 10, message = "派单客服不能超过10个字符")
    @ExcelAttribute(name = "派单客服", maxLength = 10)
    private String customerService;
    /**
     * 小合同名称
     */
    @Length(max = 50, message = "小合同名称不能超过50个字符")
    @ExcelAttribute(name = "小合同名称", maxLength = 50)
    private String contractMinorName;
    /**
     * 唯一号
     */
    @Length(max = 15, message = "唯一号不能超过15个字符")
    @ExcelAttribute(name = "唯一号", maxLength = 15)
    private String uniqueNumber;
    /**
     * 客户编号
     */
    @Length(max = 20, message = "客户编号不能超过20个字符")
    @ExcelAttribute(name = "客户编号", maxLength = 20)
    private String customerNumber;
    /**
     * 服务类别
     */
    @Length(max = 15, message = "服务类别不能超过15个字符")
    @ExcelAttribute(name = "服务类别", maxLength = 15)
    private String serviceType;
    /**
     * 养老截止城市
     */
    @Length(max = 15, message = "养老截止城市不能超过15个字符")
    @ExcelAttribute(name = "养老截止城市", maxLength = 15)
    private String pensionAddressReduce;
    /**
     * 养老截止时间
     */
    @Length(max = 6, message = "养老截止时间不能超过6个字符")
    @ExcelAttribute(name = "养老截止时间", maxLength = 6, isInteger = true)
    private String pensionEndReduce;

    /**
     * 医疗截止城市
     */
    @Length(max = 15, message = "医疗截止城市不能超过15个字符")
    @ExcelAttribute(name = "医疗截止城市", maxLength = 15)
    private String medicalAddressReduce;
    /**
     * 医疗截止时间
     */
    @Length(max = 6, message = "医疗截止时间不能超过6个字符")
    @ExcelAttribute(name = "医疗截止时间", maxLength = 6, min = 6, isInteger = true)
    private String medicalEndReduce;
    /**
     * 工伤截止城市
     */
    @Length(max = 15, message = "工伤截止城市不能超过15个字符")
    @ExcelAttribute(name = "工伤截止城市", maxLength = 15)
    private String injuryAddressReduce;
    /**
     * 工伤截止时间
     */
    @Length(max = 6, message = "工伤截止时间不能超过6个字符")
    @ExcelAttribute(name = "工伤截止时间", maxLength = 6, min = 6, isInteger = true)
    private String injuryEndReduce;
    /**
     * 生育截止城市
     */
    @Length(max = 15, message = "生育截止城市不能超过15个字符")
    @ExcelAttribute(name = "生育截止城市", maxLength = 15)
    private String birthAddressReduce;
    /**
     * 生育截止时间
     */
    @Length(max = 6, message = "生育截止时间不能超过6个字符")
    @ExcelAttribute(name = "生育截止时间", maxLength = 6, min = 6, isInteger = true)
    private String birthEndReduce;
    /**
     * 失业截止城市
     */
    @Length(max = 15, message = "失业截止城市不能超过15个字符")
    @ExcelAttribute(name = "失业截止城市", maxLength = 15)
    private String unemploymentAddressReduce;
    /**
     * 失业截止时间
     */
    @Length(max = 6, message = "失业截止时间不能超过6个字符")
    @ExcelAttribute(name = "失业截止时间", maxLength = 6, min = 6, isInteger = true)
    private String unemploymentEndReduce;
    /**
     * 公积金截止城市
     */
    @Length(max = 15, message = "公积金截止城市不能超过15个字符")
    @ExcelAttribute(name = "公积金截止城市", maxLength = 15)
    private String fundAddressReduce;
    /**
     * 公积金截止时间
     */
    @Length(max = 6, message = "公积金截止时间不能超过6个字符")
    @ExcelAttribute(name = "公积金截止时间", maxLength = 6, min = 6, isInteger = true)
    private String fundEndReduce;

    /**
     * 离职日期
     */
    @ExcelAttribute(name = "离职日期", isDate = true)
    private String leaveDate;
    /**
     * 离职原因
     */
    @Length(max = 100, message = "离职原因不能超过100个字符")
    @ExcelAttribute(name = "离职原因", maxLength = 100)
    private String leaveReason;

    /**
     * 离职原因ID
     */
    @Length(max = 32, message = "离职原因ID不能超过32个字符")
    @ExcelAttribute(name = "离职原因ID", maxLength = 32)
    private String leaveReasonAdd;

    /**
     * 合同类型
     */
    @Length(max = 20, message = "合同类型不能超过20个字符")
    @ExcelAttribute(name = "合同类型", maxLength = 20)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="合同类型")
    private String contractType;
    /**
     * 员工类型
     */
    @Length(max = 5, message = "员工类型不能超过2个字符")
    @ExcelAttribute(name = "员工类型", maxLength = 5)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="员工类型")
    private String empTypeAdd;
    /**
     * 所属单位ID
     */
    @Length(max = 32, message = "所属单位ID不能超过32个字符")
    @ExcelAttribute(name = "所属单位ID", maxLength = 32)
    private String unitIdAdd;
    /**
     * 所属项目ID
     */
    @Length(max = 32, message = "所属项目ID不能超过32个字符")
    @ExcelAttribute(name = "所属项目ID", maxLength = 32)
    private String departIdAdd;
    /**
     * 所属单位名称
     */
    @Length(max = 50, message = "所属单位名称不能超过50个字符")
    @ExcelAttribute(name = "所属单位名称", maxLength = 50)
    private String unitNameAdd;
    /**
     * 所属项目名称
     */
    @Length(max = 50, message = "所属项目名称不能超过50个字符")
    @ExcelAttribute(name = "所属项目名称", maxLength = 50)
    private String departNameAdd;
    /**
     * 社保户
     */
    @Length(max = 50, message = "社保户不能超过50个字符")
    @ExcelAttribute(name = "社保户", maxLength = 50)
    private String socialHouseAdd;
    /**
     * 公积金户
     */
    @Length(max = 50, message = "公积金户不能超过50个字符")
    @ExcelAttribute(name = "公积金户", maxLength = 50)
    private String fundHouseAdd;
    /**
     * 岗位
     */
    @Length(max = 50, message = "岗位不能超过50个字符")
    @ExcelAttribute(name = "岗位", maxLength = 50)
    private String positionAdd;

    /**
     * 备案基数
     */
    @ExcelAttribute(name = "备案基数", isFloat = true)
    private BigDecimal filingBaseAdd;
    /**
     * 派单状态：0:正常未派单1:异常未派单2:已派单
     */
    @Length(max = 20, message = "0:正常未派单1:异常未派单2:已派单不能超过1个字符")
    @ExcelAttribute(name = "派单状态", maxLength = 20)
    private String preStatus;
    /**
     * 预派单状态：0:正常1:作废
     */
    @Length(max = 1, message = "预派单状态：0:正常1:作废不能超过1个字符")
    @ExcelAttribute(name = "预派单状态", maxLength = 1)
    private String status;
    /**
     * 异常内容
     */
    @Length(max = 255, message = "异常内容不能超过255个字符")
    @ExcelAttribute(name = "异常内容", maxLength = 255)
    private String exceptionContent;
    /**
     * 社保-省
     */
    @Length(max = 5, message = "社保-省不能超过5个字符")
    @ExcelAttribute(name = "社保-省", maxLength = 5)
    private String socialProvince;
    /**
     * 社保-市
     */
    @Length(max = 5, message = "社保-市不能超过5个字符")
    @ExcelAttribute(name = "社保-市", maxLength = 5)
    private String socialCity;
    /**
     * 社保-县
     */
    @Length(max = 5, message = "社保-县不能超过5个字符")
    @ExcelAttribute(name = "社保-县", maxLength = 5)
    private String socialTown;
    /**
     * 公积金-省
     */
    @Length(max = 5, message = "公积金-省不能超过5个字符")
    @ExcelAttribute(name = "公积金-省", maxLength = 5)
    private String fundProvince;
    /**
     * 公积金-市
     */
    @Length(max = 5, message = "公积金-市不能超过5个字符")
    @ExcelAttribute(name = "公积金-市", maxLength = 5)
    private String fundCity;
    /**
     * 公积金-县
     */
    @Length(max = 5, message = "公积金-县不能超过5个字符")
    @ExcelAttribute(name = "公积金-县", maxLength = 5)
    private String fundTown;
    /**
     * 派单日期限制  如：在15日前包含15日可派单 15日及15后次月派单
     */
    @ExcelAttribute(name = "派单日期限制", isInteger = true)
    private Integer dayLimit;
    /**
     * 资料是否提交：0 是 1  否
     */
    @Length(max = 5, message = "资料是否提交不能超过2个字符")
    @ExcelAttribute(name = "资料是否提交", maxLength = 2)
    private String dataSubStatus;

    /**
     * 派单合同名称
     */
    @Length(max = 50, message = "派单合同名称不能超过50个字符")
    @ExcelAttribute(name = "派单合同名称", maxLength = 50)
    private String contractNameAdd;
    /**
     * 派单合同类型
     */
    @Length(max = 32, message = "派单合同类型不能超过32个字符")
    @ExcelAttribute(name = "派单合同类型", maxLength = 32)
    private String contractTypeAdd;
    /**
     * 派单合同开始时间
     */
    @Length(max = 20, message = "派单合同开始时间不能超过20个字符")
    @ExcelAttribute(name = "派单合同开始时间", maxLength = 20, isDate = true)
    private String contractStartAdd;
    /**
     * 派单合同截止时间
     */
    @Length(max = 20, message = "派单合同截止时间不能超过20个字符")
    @ExcelAttribute(name = "派单合同截止时间", maxLength = 20, isDate = true)
    private String contractEndAdd;
    /**
     * 派单合同期限
     */
    @Length(max = 2, message = "派单合同期限不能超过2个字符")
    @ExcelAttribute(name = "派单合同期限", maxLength = 2)
    private String contractTermAdd;

    /**
     * 工时制（数据字典） 1标准工时 2 综合工时 3不定时工时制
     */
    @Length(max = 32, message = "工时制不能超过32个字符")
    @ExcelAttribute(name = "工时制", maxLength = 32)
    private String workingHoursAdd;

    /**
     * 创建时间
     */
    @ExcelAttribute(name = "创建时间")
    private LocalDateTime createTime;

    /**
     * 创建人ID
     */
    @ExcelAttribute(name = "创建人ID", maxLength = 2)
    private String createUserId;

    /**
     * 创建人姓名
     */
    @ExcelAttribute(name = "创建人姓名")
    private String createUserName;

    /**
     * 备注
     */
    @ExcelAttribute(name = "备注", maxLength = 250)
	@Length(max = 250, message = "备注不能超过250个字符")
    private String remark;

    /**
     * 是否派单：0 是 1 否
     */
    @ExcelAttribute(name = "是否派单", maxLength = 2,isDataId = true,dataType = ExcelAttributeConstants.STATUS_FLAG)
    private String dispatchFlag;

    /**
     * 取消原因：不派单时填写
     */
    @ExcelAttribute(name = "取消原因", maxLength = 255)
    private String cancelRemark;
}
