/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialfundHouseRes;
import com.yifu.cloud.plus.v1.yifu.social.service.TSocialfundHouseResService;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 社保公积金户权限配置表
 *
 * @author huyc
 * @date 2022-11-02 09:13:07
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tsocialfundhouseres" )
@Tag(name = "社保公积金户权限配置表管理")
public class TSocialfundHouseResController {

    private final  TSocialfundHouseResService tSocialfundHouseResService;

    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tSocialfundHouseRes 社保公积金户权限配置表
     * @return
     */
    @Operation(description = "社保公积金审核简单分页查询")
    @GetMapping("/page")
    public R<IPage<TSocialfundHouseRes>> getTSocialfundHouseResPage(Page<TSocialfundHouseRes> page, TSocialfundHouseRes tSocialfundHouseRes) {
        return new R<>(tSocialfundHouseResService.getTSocialfundHouseResPage(page,tSocialfundHouseRes));
    }

    /**
     * 导出查询
     * @param tSocialfundHouseRes 社保公积金户权限配置表
     * @return
     */
    @Operation(summary = "导出查询", description = "导出查询")
    @PostMapping("/exportList" )
    public R<List<TSocialfundHouseRes>> getexportList(@RequestBody TSocialfundHouseRes tSocialfundHouseRes) {
        return R.ok(tSocialfundHouseResService.getexportList(tSocialfundHouseRes));
    }

    /**
     * 通过id查询社保公积金户权限配置表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('social_tsocialfundhouseres_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('social_tsocialfundhouseres_get')" )
    public R<TSocialfundHouseRes> getById(@PathVariable("id" ) String id) {
        return R.ok(tSocialfundHouseResService.getById(id));
    }

    /**
     * 新增社保公积金户权限配置表
     * @param tSocialfundHouseRes 社保公积金户权限配置表
     * @return R
     */
    @Operation(summary = "新增社保公积金户权限配置表", description = "新增社保公积金户权限配置表：hasPermission('social_tsocialfundhouseres_add')")
    @SysLog("新增社保公积金户权限配置表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('social_tsocialfundhouseres_add')" )
    public R save(@RequestBody TSocialfundHouseRes tSocialfundHouseRes) {
        return tSocialfundHouseResService.saveSocialAuth(tSocialfundHouseRes);
    }

    /**
     * 修改社保公积金户权限配置表
     * @param tSocialfundHouseRes 社保公积金户权限配置表
     * @return R
     */
    @Operation(summary = "修改社保公积金户权限配置表", description = "修改社保公积金户权限配置表：hasPermission('social_tsocialfundhouseres_edit')")
    @SysLog("修改社保公积金户权限配置表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('social_tsocialfundhouseres_edit')" )
    public R<Boolean> updateById(@RequestBody TSocialfundHouseRes tSocialfundHouseRes) {
        return R.ok(tSocialfundHouseResService.updateById(tSocialfundHouseRes));
    }

    /**
     * 通过id删除社保公积金户权限配置表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除社保公积金户权限配置表", description = "通过id删除社保公积金户权限配置表：hasPermission('social_tsocialfundhouseres_del')")
    @SysLog("通过id删除社保公积金户权限配置表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('social_tsocialfundhouseres_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tSocialfundHouseResService.removeById(id));
    }
}
