/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TPaymentBySalaryVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.UpdateSocialFoundVo;
import com.yifu.cloud.plus.v1.yifu.social.entity.TPaymentInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TPaymentInfoExportVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TPaymentInfoSearchVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TPaymentInfoVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 缴费库
 *
 * @author huyc
 * @date 2022-07-14 18:53:42
 */
@Mapper
public interface TPaymentInfoMapper extends BaseMapper<TPaymentInfo> {
    /**
     * 缴费库简单分页查询
     * @param tPaymentInfo 缴费库
     * @return
     */
    IPage<TPaymentInfo> getTPaymentInfoPage(Page<TPaymentInfo> page, @Param("tPaymentInfo") TPaymentInfo tPaymentInfo);

	/**
	 * 缴费库简单分页查询
	 * @param searchVo 缴费库
	 * @return
	 */
	Integer selectCountTPaymentInfo(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo);

	/**
	 * 缴费库简单分页查询
	 * @param searchVo 缴费库
	 * @return
	 */
	List<TPaymentInfo> getTPaymentInfoNoPage(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo);

	/**
	 * 缴费库合并导出查询
	 * @param searchVo 缴费库
	 * @return
	 */
	Integer selectCountSumPaymentInfo(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo);

	/**
	 * 缴费库简单分页查询
	 * @param searchVo 缴费库
	 * @return
	 */
	List<TPaymentInfoExportVo> getTPaymentInfoSumNoPage(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo);

	/**
	 * 更新社保或者公积金
	 * @param tPaymentInfo 缴费库
	 * @return
	 */
	int updateDeleteInfo(@Param("tPaymentInfo")TPaymentInfo tPaymentInfo);

	/**
	 * 通过ID获取缴费库 及社保、公积金明细
	 * @param id
	 * @return
	 **/
	TPaymentInfoVo getAllInfoById(String id);

	/**
	 * 查询要删除的数据
	 * @param queryEntity
	 * @return
	 **/
	List<TPaymentInfo> selectListForDelete(@Param("queryEntity")TPaymentInfo queryEntity);

	/*
	* 已存在社保缴费库数据  非删除状态
	* @param months
	* @param idcards
	* @return
	* */
	List<TPaymentInfo> selectListForPaymentImport(@Param("months")List<String> months, @Param("idcards")List<String> idcards);

	/*
	 * 已存在公积金缴费库数据  非删除状态
	 * @param months
	 * @param idcards
	 * @return
	 * */
	List<TPaymentInfo> selectListForPaymentImport1(@Param("months")List<String> months, @Param("idcards")List<String> idcards);

	/**
	 * 薪资获取缴费库
	 * @Author hgw
	 * @Date 2022-8-10 18:06:13
	 **/
	List<TPaymentBySalaryVo> selectTPaymentBySalaryVo(@Param("tPaymentInfo") TPaymentBySalaryVo tPaymentInfo);

	/**
	 * 更新社保结算状态
	 * @Author hgw
	 * @Date 2020-4-13 16:01:59
	 * @param idList
	 * @param status
	 * @return
	 **/
	int updatePaymentSocialStatusByIdList(@Param("idList") List<String> idList, @Param("status") String status);

	int updatePaymentFundStatusByIdList(@Param("idList")List<String> idList, @Param("status") String status);

	void updatePaymentSocialAndFound(@Param("infoVo") UpdateSocialFoundVo infoVo);

	void updateByIncome(@Param("id")String id);

	/**
	 * 更新社保推送
	 * @Author huyc
	 * @Date 2022-8-30
	 * @param idList
	 * @return
	 **/
	int updatePushStatus(@Param("idList") List<String> idList);

}
