/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialfundHouseRes;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 社保公积金户权限配置表
 *
 * @author huyc
 * @date 2022-11-02 09:13:07
 */
@Mapper
public interface TSocialfundHouseResMapper extends BaseMapper<TSocialfundHouseRes> {
    /**
     * 社保公积金户权限配置表简单分页查询
     * @param tSocialfundHouseRes 社保公积金户权限配置表
     * @return
     */
    IPage<TSocialfundHouseRes> getTSocialfundHouseResPage(Page<TSocialfundHouseRes> page, @Param("tSocialfundHouseRes") TSocialfundHouseRes tSocialfundHouseRes);

	/**
	 * 社保公积金户权限配置表导出查询
	 * @param tSocialfundHouseRes 社保公积金户权限配置表
	 * @return
	 */
	List<TSocialfundHouseRes> getexportList(@Param("tSocialfundHouseRes") TSocialfundHouseRes tSocialfundHouseRes);
}
