/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.TIncome;
import com.yifu.cloud.plus.v1.yifu.social.entity.TIncomeDetail;
import com.yifu.cloud.plus.v1.yifu.social.vo.TIncomeSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 收入明细表
 *
 * @author hgw
 * @date 2022-08-30 17:34:58
 */
public interface TIncomeService extends IService<TIncome> {
	/**
	 * 收入明细表简单分页查询
	 *
	 * @param tIncome 收入明细表
	 * @return
	 */
	IPage<TIncome> getTIncomePage(Page<TIncome> page, TIncomeSearchVo tIncome);

	R<List<ErrorMessage>> importDiy(InputStream inputStream);

	void listExport(HttpServletResponse response, TIncomeSearchVo searchVo);

	/**
	 * @Description: 新增收入明细-详情表，同时统计；
	 * @Author: hgw
	 * @Date: 2022/8/31 16:31
	 * @return: boolean
	 **/
	boolean saveDetail(TIncomeDetail tIncomeDetail);

	/**
	 * @Description: 新增收入明细-详情表，同时统计；
	 * @Author: huyc
	 * @Date: 2022/9/9 11:42
	 * @return:
	 **/
	void saveBathDetail(List<TIncomeDetail> tIncomeDetail);

	void pushDetail();

}
