/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.social.entity.TPreDispatchInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TPreDispatchReduceVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TPreDispatchUpdateVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 预派单记录
 *
 * @author huyc
 * @date 2022-07-14 18:53:42
 */
public interface TPreDispatchInfoService extends IService<TPreDispatchInfo> {
    /**
     * 预派单记录简单分页查询
     * @param tPreDispatchInfo 预派单记录
     * @return
     */
    IPage<TPreDispatchInfo> getTPreDispatchInfoPage(Page<TPreDispatchInfo> page, TPreDispatchInfo tPreDispatchInfo);

	/**
	 * 修改资料是否提交状态  0 是 1 否
	 * @Author huyc
	 * @Date 2022-07-18
	 * @param ids
	 * @param status
	 * @return
	 **/
	R<Boolean> modifyDataSubmitStatus(String ids, String status);

	/**
	 * 清空预派单默认的派单合同信息
	 * @Author huyc
	 * @Date 2022-07-18
	 * @param ids
	 * @return
	 **/
	R<Boolean> clearContractInfo(String ids);

	/**
	 * 更新预派单是否派单状态
	 * @Author huyc
	 * @Date 2022-07-18
	 * @param id
	 * @param dispatchFlag
	 * @param cancelRemark
	 * @return
	 **/
	R<Boolean> updateDispatchFlag(String id, String dispatchFlag, String cancelRemark);

	/**
	 * 单个派单
	 * @Author huyc
	 * @Date 2022-07-18
	 * @param id
	 * @return
	 **/
	R<Boolean> dispatchById(String id);

	/**
	 * 一键派单
	 * @Author huyc
	 * @Date 2022-07-18
	 * @return
	 **/
	R oneKeyToDispatch(String idStr);

	/**
	 * 修改预派单记录
	 * @Author huyc
	 * @Date 2022-07-18
	 * @return
	 **/
	R<Boolean> update(TPreDispatchInfo tPreDispatchInfo);

	/**
	 * 预派单批量新增派增
	 * @Author huyc
	 * @Date 2022-07-18
	 * @param listInfo
	 * @param user
	 * @param socialHouse
	 * @param departId
	 * @return
	 **/
	List<ErrorMessage> batchSavePreDisPatchAdd(List<TPreDispatchInfo> listInfo, YifuUser user, String socialHouse,
											   String fundHouse, String departId, List<ErrorMessage> errorInfo);

	/**
	 * 预派单批量新增派减
	 * @Author huyc
	 * @Date 2022-07-18
	 * @param listInfo
	 * @param user
	 * @return
	 **/
	List<ErrorMessage> batchSavePreDisPatchReduce(List<TPreDispatchReduceVo> listInfo, YifuUser user,
												  List<ErrorMessage> errorInfo);

	/**
	 * 预派单批量更新
	 * @Author huyc
	 * @Date 2022-07-18
	 * @param listInfo
	 * @param user
	 * @return
	 **/
	List<ErrorMessage> batchUpdatePreDisPatch(List<TPreDispatchUpdateVo> listInfo, YifuUser user,
											  List<ErrorMessage> messageList);

	/**
	 * 预派单导出
	 * @Author huyc
	 * @Date 2022-07-18
	 * @param response
	 * @param tPreDispatchInfo
	 * @return
	 **/
	void doexportPreDispatch(HttpServletResponse response, TPreDispatchInfo tPreDispatchInfo);
}
