package com.yifu.cloud.plus.v1.yifu.social.service.impl;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import cn.hutool.core.collection.CollUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysArea;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.AreaVo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TSettleDomain;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainListVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.exception.ErrorCodes;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.ArchivesDaprUtil;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.UpmsDaprUtils;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.ekp.util.EkpFundUtil;
import com.yifu.cloud.plus.v1.yifu.ekp.util.EkpSocialUtil;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpPushFundParam;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpPushSocialParam;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TPaymentBySalaryVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TPaymentVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.UpdateSocialFoundVo;
import com.yifu.cloud.plus.v1.yifu.social.concurrent.threadpool.YFSocialImportThreadPoolExecutor;
import com.yifu.cloud.plus.v1.yifu.social.constants.PaymentConstants;
import com.yifu.cloud.plus.v1.yifu.social.constants.SocialConstants;
import com.yifu.cloud.plus.v1.yifu.social.entity.*;
import com.yifu.cloud.plus.v1.yifu.social.mapper.*;
import com.yifu.cloud.plus.v1.yifu.social.service.TIncomeService;
import com.yifu.cloud.plus.v1.yifu.social.service.TPaymentInfoService;
import com.yifu.cloud.plus.v1.yifu.social.service.TSendEkpErrorService;
import com.yifu.cloud.plus.v1.yifu.social.vo.TPaymentHeFeiVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TPaymentInfoExportVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TPaymentInfoSearchVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TPaymentInfoVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * 缴费库
 *
 * @author huyc
 * @date 2022-07-22 17:01:22
 */
@Log4j2
@Service
public class TPaymentInfoServiceImpl extends ServiceImpl<TPaymentInfoMapper, TPaymentInfo> implements TPaymentInfoService {

	@Autowired
	private RedisUtil redisUtil;

	@Autowired
	private YFSocialImportThreadPoolExecutor yfSocialImportThreadPoolExecutor;

	@Autowired
	private UpmsDaprUtils upmsDaprUtils;

	@Autowired
	private TSocialFundInfoMapper socialFundInfoMapper;

	@Autowired
	private TSocialInfoMapper socialInfoMapper;

	@Autowired
	private TProvidentFundMapper providentFundMapper;

	private final int partSize = 30;

	@Autowired
	private SysHouseHoldInfoMapper sysHouseHoldInfoMapper;

	@Autowired
	private EkpFundUtil ekpFundUtil;

	@Autowired
	private EkpSocialUtil ekpSocialUtil;

	@Autowired
	private TIncomeDetailMapper detailMapper;

	@Autowired
	private TIncomeService incomeService;

	@Autowired
	private ArchivesDaprUtil archivesDaprUtil;

	@Autowired
	private TSendEkpErrorService tSendEkpErrorService;

	/**
	 * 缴费库简单分页查询
	 *
	 * @param tPaymentInfo 缴费库
	 * @return
	 */
	@Override
	public IPage<TPaymentInfo> getTPaymentInfoPage(Page<TPaymentInfo> page, TPaymentInfo tPaymentInfo) {
		return baseMapper.getTPaymentInfoPage(page, tPaymentInfo);
	}

	/**
	 * 缴费库批量导出
	 *
	 * @param searchVo 缴费库
	 * @return
	 */
	@Override
	public void listExport(HttpServletResponse response, TPaymentInfoSearchVo searchVo) {
		String fileName = "缴费库批量导出" + DateUtil.getThisTime() + CommonConstants.XLSX;
		//获取要导出的列表
		List<TPaymentInfo> list = new ArrayList<>();
		Integer count = baseMapper.selectCountTPaymentInfo(searchVo);
		ServletOutputStream out = null;
		try {
			out = response.getOutputStream();
			response.setContentType(CommonConstants.MULTIPART_FORM_DATA);
			response.setCharacterEncoding("utf-8");
			response.setHeader(CommonConstants.CONTENT_DISPOSITION, CommonConstants.ATTACHMENT_FILENAME + URLEncoder.encode(fileName, "UTF-8"));
			// 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			ExcelWriter excelWriter = EasyExcel.write(out, TPaymentInfo.class).includeColumnFiledNames(searchVo.getExportFields()).build();
			int index = 0;
			if (count > CommonConstants.ZERO_INT) {
				for (int i = 0; i <= count; ) {
					// 获取实际记录
					searchVo.setLimitStart(i);
					searchVo.setLimitEnd(CommonConstants.EXCEL_EXPORT_LIMIT);
					list = baseMapper.getTPaymentInfoNoPage(searchVo);
					if (Common.isNotNull(list)) {
						ExcelUtil<TPaymentInfo> util = new ExcelUtil<>(TPaymentInfo.class);
						for (TPaymentInfo vo : list) {
							util.convertEntity(vo, null, null, null);
						}
					}
					if (Common.isNotNull(list)) {
						WriteSheet writeSheet = EasyExcel.writerSheet("缴费库" + index).build();
						excelWriter.write(list, writeSheet);
						index++;
					}
					i = i + CommonConstants.EXCEL_EXPORT_LIMIT;
					if (Common.isNotNull(list)) {
						list.clear();
					}
				}
			} else {
				WriteSheet writeSheet = EasyExcel.writerSheet("缴费库" + index).build();
				excelWriter.write(list, writeSheet);
			}
			if (Common.isNotNull(list)) {
				list.clear();
			}
			out.flush();
			excelWriter.finish();
		} catch (Exception e) {
			log.error("执行异常", e);
		} finally {
			try {
				if (null != out) {
					out.close();
				}
			} catch (IOException e) {
				log.error("执行异常", e);
			}
		}
	}

	/**
	 * 缴费库批量导出
	 *
	 * @param searchVo 缴费库
	 * @return
	 */
	@Override
	public void listSumExport(HttpServletResponse response, TPaymentInfoSearchVo searchVo) {
		String fileName = "缴费库合并导出" + DateUtil.getThisTime() + CommonConstants.XLSX;
		//获取要导出的列表
		List<TPaymentInfoExportVo> list = new ArrayList<>();
		Integer count = baseMapper.selectCountSumPaymentInfo(searchVo);
		ServletOutputStream out = null;
		try {
			out = response.getOutputStream();
			response.setContentType(CommonConstants.MULTIPART_FORM_DATA);
			response.setCharacterEncoding("utf-8");
			response.setHeader(CommonConstants.CONTENT_DISPOSITION, CommonConstants.ATTACHMENT_FILENAME + URLEncoder.encode(fileName, "UTF-8"));
			// 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			ExcelWriter excelWriter = EasyExcel.write(out, TPaymentInfoExportVo.class).includeColumnFiledNames(searchVo.getExportFields()).build();
			int index = 0;
			if (count > CommonConstants.ZERO_INT) {
				for (int i = 0; i <= count; ) {
					// 获取实际记录
					searchVo.setLimitStart(i);
					searchVo.setLimitEnd(CommonConstants.EXCEL_EXPORT_LIMIT);
					list = baseMapper.getTPaymentInfoSumNoPage(searchVo);
					if (Common.isNotNull(list)) {
						ExcelUtil<TPaymentInfoExportVo> util = new ExcelUtil<>(TPaymentInfoExportVo.class);
						for (TPaymentInfoExportVo vo : list) {
							util.convertEntity(vo, null, null, null);
						}
					}
					if (Common.isNotNull(list)) {
						WriteSheet writeSheet = EasyExcel.writerSheet("缴费库合并导出" + index).build();
						excelWriter.write(list, writeSheet);
						index++;
					}
					i = i + CommonConstants.EXCEL_EXPORT_LIMIT;
					if (Common.isNotNull(list)) {
						list.clear();
					}
				}
			} else {
				WriteSheet writeSheet = EasyExcel.writerSheet("缴费库合并导出" + index).build();
				excelWriter.write(list, writeSheet);
			}
			if (Common.isNotNull(list)) {
				list.clear();
			}
			out.flush();
			excelWriter.finish();
		} catch (Exception e) {
			log.error("执行异常", e);
		} finally {
			try {
				if (null != out) {
					out.close();
				}
			} catch (IOException e) {
				log.error("执行异常", e);
			}
		}
	}

	@Override
	public R<Boolean> removeInFoById(String id) {
		YifuUser user = SecurityUtils.getUser();

		TPaymentInfo paymentInfo = baseMapper.selectById(id);
		if (!user.getId().equals(paymentInfo.getCreateBy()) && !CommonConstants.ONE_STRING.equals(user.getId())) {
			return R.failed("非本人创建的数据禁止删除！");
		}

		if (CommonConstants.ZERO_STRING.equals(paymentInfo.getPushStatus())) {
			return R.failed("已推送至结算平台禁止删除！");
		}

		if (CommonConstants.ONE_STRING.equals(paymentInfo.getSalaryFundFlag()) ||
				CommonConstants.ONE_STRING.equals(paymentInfo.getSalarySocialFlag())) {
			return R.failed("该数据已与薪资结算，禁止删除");
		}
		baseMapper.deleteById(id);
		return R.ok();
	}

	@Override
	public R<Boolean> removeAllInfoById(String ids) {
		YifuUser user = SecurityUtils.getUser();
		if (Common.isEmpty(ids)) {
			return R.failed(CommonConstants.NO_DATA_TO_HANDLE);
		}
		List<String> idList = Common.initStrToList(ids, CommonConstants.COMMA_STRING);
		TPaymentInfo paymentInfo;

		if (idList != null) {
			for (String id : idList) {
				paymentInfo = baseMapper.selectById(id);
				if ((!user.getId().equals(paymentInfo.getCreateBy()) &&
						!CommonConstants.ONE_STRING.equals(user.getId())) ||
						CommonConstants.ZERO_STRING.equals(paymentInfo.getPushStatus())) {
					return R.failed("存在不符合条件的数据(已推送至结算平台或非本人创建),禁止删除！");
				}
				if (CommonConstants.ONE_STRING.equals(paymentInfo.getSalaryFundFlag()) ||
						CommonConstants.ONE_STRING.equals(paymentInfo.getSalarySocialFlag())) {
					return R.failed("存在不符合条件的数据(已与薪资结算)，禁止删除");
				}
				baseMapper.deleteById(id);
			}
		}
		return R.ok();
	}
	/**
	 * 通过ID获取缴费库 及社保、公积金明细
	 *
	 * @param id
	 * @Author huyc
	 * @Date 2022-07-24
	 **/
	@Override
	public R<TPaymentInfoVo> getAllInfoById(String id) {
		TPaymentInfoVo vo = baseMapper.getAllInfoById(id);
		return R.ok(vo, "查询成功！");
	}

	@Override
	public R<Boolean> removeBatchByInfo(String empIdCard, String socialHouseId, String fundHouseId,
										String socialCreateMonth, String socialPayMonth) {
		YifuUser user = SecurityUtils.getUser();

		LambdaQueryWrapper<TPaymentInfo> wrapper = buildQueryWrapper(empIdCard, socialHouseId, fundHouseId,
				socialCreateMonth, socialPayMonth);

		List<TPaymentInfo> list = baseMapper.selectList(wrapper);
		List<String> idList = new ArrayList<>();
		boolean delFlag = false;
		if (Common.isNotNull(list)) {
			for (TPaymentInfo paymentInfo : list) {
				if ((!user.getId().equals(paymentInfo.getCreateBy()) &&
						!CommonConstants.ONE_STRING.equals(user.getId())) ||
						CommonConstants.ZERO_STRING.equals(paymentInfo.getPushStatus()) ||
						CommonConstants.ONE_STRING.equals(paymentInfo.getSalaryFundFlag()) ||
						CommonConstants.ONE_STRING.equals(paymentInfo.getSalarySocialFlag())) {
					delFlag = true;
				} else {
					idList.add(paymentInfo.getId());
				}
			}
		} else {
			return R.failed(CommonConstants.NO_DATA_TO_HANDLE);
		}
		if (Common.isNotNull(idList)) {
			baseMapper.deleteBatchIds(idList);
		}
		if (delFlag) {
			return R.ok(null, "存在不符合条件的数据(已推送至结算平台或非本人创建),禁止删除！");
		}
		return R.ok(null, "批量删除成功");
	}

	private LambdaQueryWrapper buildQueryWrapper(String empIdCard, String socialHouseId, String fundHouseId,
												 String socialCreateMonth, String socialPayMonth) {
		LambdaQueryWrapper<TPaymentInfo> wrapper = Wrappers.lambdaQuery();
		if (Common.isNotNull(empIdCard)) {
			wrapper.eq(TPaymentInfo::getEmpIdcard, empIdCard);
		}
		if (Common.isNotNull(socialHouseId)) {
			SysHouseHoldInfo info = sysHouseHoldInfoMapper.selectById(socialHouseId);
			if (Common.isNotNull(info)) {
				wrapper.eq(TPaymentInfo::getSocialHousehold, info.getName());
			}
		}
		if (Common.isNotNull(fundHouseId)) {
			SysHouseHoldInfo infoFund = sysHouseHoldInfoMapper.selectById(fundHouseId);
			if (Common.isNotNull(infoFund)) {
				wrapper.eq(TPaymentInfo::getProvidentHousehold, infoFund.getName());
			}
		}
		if (Common.isNotNull(socialCreateMonth)) {
			wrapper.eq(TPaymentInfo::getSocialCreateMonth, socialCreateMonth).or()
					.eq(TPaymentInfo::getProvidentCreateMonth, socialCreateMonth);
		}
		if (Common.isNotNull(socialPayMonth)) {
			wrapper.eq(TPaymentInfo::getSocialPayMonth, socialPayMonth).or()
					.eq(TPaymentInfo::getProvidentPayMonth, socialPayMonth);
		}
		return wrapper;
	}

	@Override
	public R<List<ErrorMessage>> importSocialDiy(InputStream inputStream, String random) {
		YifuUser user = SecurityUtils.getUser();
		List<ErrorMessage> errorMessageList = new ArrayList<>();
		ExcelUtil<TPaymentInfoVo> util1 = new ExcelUtil<>(TPaymentInfoVo.class);
		// 写法2：
		// 匿名内部类 不用额外写一个DemoDataListener
		// 这里 需要指定读用哪个class去读，然后读取第一个sheet 文件流会自动关闭
		try {
			EasyExcel.read(inputStream, TPaymentInfoVo.class, new ReadListener<TPaymentInfoVo>() {
				/**
				 * 单次缓存的数据量
				 */
				public static final int BATCH_COUNT = CommonConstants.BATCH_COUNT;
				//所有行数
				Integer rowNumber;
				/**
				 *临时存储
				 */
				private List<TPaymentInfoVo> cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);

				@Override
				public void invoke(TPaymentInfoVo data, AnalysisContext context) {
					ReadRowHolder readRowHolder = context.readRowHolder();
					// 获取总行数（含表头）
					rowNumber = context.readSheetHolder().getApproximateTotalRowNumber();
					Integer rowIndex = readRowHolder.getRowIndex();
					data.setRowIndex(rowIndex + 1);
					ErrorMessage errorMessage = util1.checkEntity(data, data.getRowIndex());
					if (Common.isNotNull(errorMessage)) {
						errorMessageList.add(errorMessage);
					} else {
						cachedDataList.add(data);
					}
					if (cachedDataList.size() >= BATCH_COUNT) {
						saveData();
						// 存储完成清理 list
						cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
					}
				}

				@Override
				public void doAfterAllAnalysed(AnalysisContext context) {
					saveData();
				}

				/**
				 * 加上存储数据库
				 */
				private void saveData() {
					log.info("{}条数据，开始存储数据库！", cachedDataList.size());
					importTPaymentSocialInfo(cachedDataList, errorMessageList, user, rowNumber);
					log.info("存储数据库成功！");
				}
			}).sheet().doRead();
		} catch (Exception e) {
			log.error(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR, e);
			return R.failed(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR);
		}
		return R.ok(errorMessageList);
	}

	private void importTPaymentSocialInfo(List<TPaymentInfoVo> list, List<ErrorMessage> errorMessageList,
										  YifuUser user, Integer rowNumber) {
		HashMap<String, String> areaMap = new HashMap<>();
		HashMap<String, String> areaMap2 = new HashMap<>();
		R<AreaVo> areaListR = upmsDaprUtils.getAreaListR();
		if (Common.isNotNull(areaListR)) {
			AreaVo areaList = areaListR.getData();
			if (null != areaList && !areaList.getSysAreaList().isEmpty()) {
				for (SysArea area : areaList.getSysAreaList()) {
					areaMap.put(Integer.toString(area.getId()), area.getAreaName());
					areaMap2.put(area.getAreaName() + CommonConstants.DOWN_LINE_STRING + (
							null == area.getParentId() ? "null" : (0 == area.getParentId() ? "null" : Integer.toString(
									area.getParentId()))), Integer.toString(area.getId()));
				}
			}
		}

		// 判断是否有相同的用户在导入社保费用 存在提示稍后重试
		String key = user.getId() + CommonConstants.DOWN_LINE_STRING + CommonConstants.PAYMENT_SOCIAL_IMPORT;
		if (redisUtil.exists(key)) {
			errorMessageList.add(new ErrorMessage(-1, "当前用户数据导入中，请稍后重试！"));
			redisUtil.remove(key);
		} else {
			redisUtil.set(key, user.getId(), 360L);

			// 导入前做队列空闲判断，防止队列不足出现数据丢失的场景
			if (CollUtil.isNotEmpty(list)) {
				int taskSize = list.size() / partSize + CommonConstants.ONE_INT;
				int residualCapacity = yfSocialImportThreadPoolExecutor.getResidualCapacity();
				if (taskSize > residualCapacity) {
					errorMessageList.add(new ErrorMessage(-1, MsgUtils.getMessage(ErrorCodes.SOCIALINFO_LIST_NUM_LARGE)));
				}else {
					// -----------------------------生成paymentInfoMap本段开始--------------------------------
					//已存在的档案数据
					List<String> monthList = Common.listObjectToStrList(list, ExcelAttributeConstants.SOCIAL_PAY_MONTH).stream().distinct().collect(Collectors.toList());
					//已存在社保缴费库数据  非删除状态
					List<TPaymentInfo> paymentInfos = baseMapper.selectListForPaymentImport(monthList, Common.listObjectToStrList(list, ExcelAttributeConstants.EMPIDCARD));
					//养老
					ConcurrentHashMap<String, TPaymentInfo> paymentInfoPensionMap = new ConcurrentHashMap<>();
					//大病救助金
					ConcurrentHashMap<String, TPaymentInfo> paymentInfoBigMap = new ConcurrentHashMap<>();
					//失业
					ConcurrentHashMap<String, TPaymentInfo> paymentInfoUnEmpMap = new ConcurrentHashMap<>();
					//生育
					ConcurrentHashMap<String, TPaymentInfo> paymentInfoBirMap = new ConcurrentHashMap<>();
					//工伤
					ConcurrentHashMap<String, TPaymentInfo> paymentInfoInjuryMap = new ConcurrentHashMap<>();
					//医保
					ConcurrentHashMap<String, TPaymentInfo> paymentInfoMedicalMap = new ConcurrentHashMap<>();
					if (Common.isNotNull(paymentInfos)) {
						for (TPaymentInfo info : paymentInfos) {
							if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getUnitPensionMoney()),
									BigDecimalUtils.isNullToZero(info.getPersonalPensionMoney())).compareTo(BigDecimal.ZERO) != 0) {
								paymentInfoPensionMap.put(info.getSocialPayAddr()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getEmpIdcard()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialPayMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialCreateMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ SocialConstants.YL
										, info);
							}
							if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getPersonalBigmailmentMoney()),
									BigDecimalUtils.isNullToZero(info.getUnitBigmailmentMoney())).compareTo(BigDecimal.ZERO) != 0) {
								paymentInfoBigMap.put(info.getSocialPayAddr()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getEmpIdcard()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialPayMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialCreateMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ SocialConstants.DB
										, info);
							}
							if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getUnitUnemploymentMoney()),
									BigDecimalUtils.isNullToZero(info.getPersonalUnemploymentMoney())).compareTo(BigDecimal.ZERO) != 0) {
								paymentInfoUnEmpMap.put(info.getSocialPayAddr()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getEmpIdcard()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialPayMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialCreateMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ SocialConstants.SY
										, info);
							}
							if (BigDecimalUtils.isNullToZero(info.getUnitBirthMoney()).compareTo(BigDecimal.ZERO) != 0) {
								paymentInfoBirMap.put(info.getSocialPayAddr()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getEmpIdcard()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialPayMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialCreateMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ SocialConstants.BIR
										, info);
							}
							if (BigDecimalUtils.isNullToZero(info.getUnitInjuryMoney()).compareTo(BigDecimal.ZERO) != 0) {
								paymentInfoInjuryMap.put(info.getSocialPayAddr()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getEmpIdcard()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialPayMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialCreateMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ SocialConstants.GS
										, info);
							}
							if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getUnitMedicalMoney()),
									BigDecimalUtils.isNullToZero(info.getPersonalMedicalMoney())).compareTo(BigDecimal.ZERO) != 0) {
								paymentInfoMedicalMap.put(info.getSocialPayAddr()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getEmpIdcard()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialPayMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialCreateMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ SocialConstants.YB
										, info);
							}
						}
					}
					// -----------------------------生成paymentInfoMap本段结束--------------------------------

					// -----------------------------线程池处理list，批量保存社保信息开始--------------------------------
					List<TPaymentInfoVo> tempList = new ArrayList<>();

				String importSuccessKey = user.getId() + CommonConstants.DOWN_LINE_STRING + CommonConstants.PAYMENT_SOCIAL_WAIT_EXPORT;
				List<CompletableFuture<List<ErrorMessage>>> completableFutureList = new ArrayList<>();

				// 创建一个数值格式化对象
				NumberFormat numberFormat = NumberFormat.getInstance();
				// 设置精确到小数点后2位
				numberFormat.setMaximumFractionDigits(2);
				String maerialRatio = "";
				String sumNumKey = user.getId() + CommonConstants.DOWN_LINE_STRING + "sum_key";
				Integer bfInt = (Integer) redisUtil.get(sumNumKey);
				if (Common.isNotNull(bfInt)) {
					if (rowNumber > bfInt + 1) {
						maerialRatio = numberFormat.format(((float) bfInt / (float) rowNumber) * 100);
						bfInt = bfInt + 100;
						redisUtil.set(sumNumKey, bfInt, 360L);
					} else {
						maerialRatio = "100";
						redisUtil.remove(sumNumKey);
					}
				} else {
					if (rowNumber >= 100) {
						maerialRatio = numberFormat.format(((float) 100 / (float) rowNumber) * 100);
						bfInt = 100;
						redisUtil.set(sumNumKey, bfInt, 360L);
					} else {
						maerialRatio = "100";
					}
				}
				redisUtil.set(importSuccessKey, maerialRatio, 360L);

					try {
						// 1.list.size()不足partSize，直接执行
						if (list.size() < partSize) {
							CompletableFuture<List<ErrorMessage>> listCompletableFuture = CompletableFuture.supplyAsync(() ->
									executeImportSocialList(user, list, areaMap, areaMap2,
											paymentInfoPensionMap, paymentInfoBigMap, paymentInfoBirMap,
											paymentInfoMedicalMap, paymentInfoUnEmpMap, paymentInfoInjuryMap,
											errorMessageList), yfSocialImportThreadPoolExecutor);
							completableFutureList.add(listCompletableFuture);
						}

						// 2.list.size()大于partSize，循环分批执行
						int lastIdx = 0;
						if (partSize <= list.size()) {
							// 处理第一个0位元素
							final List<TPaymentInfoVo> finalList = list.subList(0, 1);
							CompletableFuture<List<ErrorMessage>> listCompletableFuture = CompletableFuture.supplyAsync(() ->
									executeImportSocialList(user, finalList, areaMap, areaMap2,
											paymentInfoPensionMap, paymentInfoBigMap, paymentInfoBirMap,
											paymentInfoMedicalMap, paymentInfoUnEmpMap, paymentInfoInjuryMap,
											errorMessageList), yfSocialImportThreadPoolExecutor);
							completableFutureList.add(listCompletableFuture);

							lastIdx = 1;
							for (int i = 1; i < list.size(); i++) {
								// partSize数量的list为一个执行单元
								tempList.add(list.get(i));
								if (i % partSize == 0) {
									lastIdx = i;
									List<TPaymentInfoVo> finalTempList = tempList;
									CompletableFuture.supplyAsync(() ->
											executeImportSocialList(user, finalTempList, areaMap, areaMap2,
													paymentInfoPensionMap, paymentInfoBigMap, paymentInfoBirMap,
													paymentInfoMedicalMap, paymentInfoUnEmpMap, paymentInfoInjuryMap,
													errorMessageList), yfSocialImportThreadPoolExecutor);
									tempList = new ArrayList<>();
								}
							}
						}

						// 3.第2种方式执行完后，有余数的情况下，执行3
						if (lastIdx != 0) {
							tempList = new ArrayList<>();
							if (lastIdx == 1) {
								for (int i = lastIdx; i < list.size(); i++) {
									tempList.add(list.get(i));
								}
							} else {
								for (int i = lastIdx + 1; i < list.size(); i++) {
									tempList.add(list.get(i));
								}
							}

							List<TPaymentInfoVo> finalTempList = tempList;
							CompletableFuture<List<ErrorMessage>> listCompletableFuture = CompletableFuture.supplyAsync(() ->
									executeImportSocialList(user, finalTempList, areaMap, areaMap2,
											paymentInfoPensionMap, paymentInfoBigMap, paymentInfoBirMap,
											paymentInfoMedicalMap, paymentInfoUnEmpMap, paymentInfoInjuryMap,
											errorMessageList), yfSocialImportThreadPoolExecutor);
							completableFutureList.add(listCompletableFuture);
						}
						// 阻塞当前线程，等待所有的线程执行完毕
						boolean computeFlag;
						do {
							computeFlag = false;
							for (CompletableFuture<List<ErrorMessage>> listCompletableFuture : completableFutureList) {
								if (!listCompletableFuture.isDone()) {
									computeFlag = true;
								}
							}
						} while (computeFlag);

					} catch (Exception e) {
			 			log.error("社保缴费库数据批量导入异常：" + e);
						redisUtil.remove(key);
					}
				}
			}
			redisUtil.remove(key);
		}
	}

	/**
	 * 转换缴纳地址为省市县ID
	 **/
	private TPaymentInfoVo initAddress(String[] areaArray, HashMap<String, String> areaMap2, TPaymentInfoVo s) {
		if (null == areaArray || null == areaMap2 || null == s) {
			return s;
		}
		String temp;
		if (areaArray.length >= CommonConstants.TWO_INT) {
			temp = areaMap2.get(areaArray[0] + CommonConstants.DOWN_LINE_STRING + "null");
			if (Common.isNotNull(temp)) {
				s.setSocialProvince(temp);
			}
			temp = areaMap2.get(areaArray[1] + CommonConstants.DOWN_LINE_STRING + (null == s.getSocialProvince()
					? "null" : s.getSocialProvince()));
			if (Common.isNotNull(temp)) {
				s.setSocialCity(temp);
			}
			if (areaArray.length >= CommonConstants.THREE_INT) {
				temp = areaMap2.get(areaArray[2] + CommonConstants.DOWN_LINE_STRING + (null == s.getSocialCity()
						? "null" : s.getSocialCity()));
				if (Common.isNotNull(temp)) {
					s.setSocialTown(temp);
				}
			}
		}
		return s;
	}

	/**
	 * @param user
	 * @param list
	 * @param areaMap
	 * @param areaMap2
	 * @param paymentInfoPensionMap
	 * @description:
	 * @author: huyc
	 * @date: 2022/7/25
	 * @return:
	 */
	private List<ErrorMessage> executeImportSocialList(YifuUser user,
													   List<TPaymentInfoVo> list,
													   HashMap<String, String> areaMap,
													   HashMap<String, String> areaMap2,
													   ConcurrentHashMap<String, TPaymentInfo> paymentInfoPensionMap,
													   ConcurrentHashMap<String, TPaymentInfo> paymentInfoBigMap,
													   ConcurrentHashMap<String, TPaymentInfo> paymentInfoBirMap,
													   ConcurrentHashMap<String, TPaymentInfo> paymentInfoMedicalMap,
													   ConcurrentHashMap<String, TPaymentInfo> paymentInfoUnEmpMap,
													   ConcurrentHashMap<String, TPaymentInfo> paymentInfoInjuryMap,
													   List<ErrorMessage> errorMessageList) {
		if (Common.isNotNull(list)) {
			TPaymentInfo paymentInfo;
			TSocialFundInfo socialInfo;
			TSocialInfo tSocialInfo;
			String temp;
			int res;

			List<TSocialFundInfo> socialInfoList = socialFundInfoMapper.selectList(Wrappers.<TSocialFundInfo>query().lambda()
					.in(TSocialFundInfo::getEmpIdcard, Common.listObjectToStrList(list, ExcelAttributeConstants.EMPIDCARD)));

			//已存在的社保数据
			HashMap<String, TSocialFundInfo> socialMap = new HashMap<>();
			if (Common.isNotNull(socialInfoList)) {
				for (TSocialFundInfo tSocialInfo1 : socialInfoList) {
					socialMap.put(tSocialInfo1.getEmpIdcard()
							+ CommonConstants.DOWN_LINE_STRING + tSocialInfo1.getSocialProvince()
							+ CommonConstants.DOWN_LINE_STRING + tSocialInfo1.getSocialCity()
							+ CommonConstants.DOWN_LINE_STRING + (null == tSocialInfo1.getSocialTown()
							? "null" : tSocialInfo1.getSocialTown()), tSocialInfo1);
				}
			}

			String[] areaArray;

			for (TPaymentInfoVo infoVo : list) {
				if (Common.isNotNull(infoVo.getEmpIdcard())) {
					infoVo.setEmpIdcard(infoVo.getEmpIdcard().replace("x", "X"));
				}
				//导入校验
				if (!Common.isNotNull(infoVo.getSocialPayMonth())) {
					errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "社保缴纳月份不可为空！"));
					continue;
				}
				if (!Common.isNotNull(infoVo.getSocialCreateMonth())) {
					errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "社保生成月份不可为空！"));
					continue;
				}
				if (!Common.isNotNull(infoVo.getSocialPayAddr())) {
					errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "社保缴纳地不可为空！"));
					continue;
				}
				//无对应员工的社保数据
				//采用客服导入的地址
				areaArray = infoVo.getSocialPayAddr().split(CommonConstants.CENTER_SPLIT_LINE_STRING);
				infoVo = initAddress(areaArray, areaMap2, infoVo);
				socialInfo = socialMap.get(infoVo.getEmpIdcard()
						+ CommonConstants.DOWN_LINE_STRING + infoVo.getSocialProvince()
						+ CommonConstants.DOWN_LINE_STRING + infoVo.getSocialCity()
						+ CommonConstants.DOWN_LINE_STRING + (null == infoVo.getSocialTown()
						? "null" : infoVo.getSocialTown()));
				//对身份证与人员姓名的对应关系进行校验
				if (socialInfo != null && !socialInfo.getEmpName().equals(infoVo.getEmpName())) {
					errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "姓名与身份证信息不一致，请核实后再次尝试！"));
					continue;
				}
				if (socialInfo != null && socialInfo.getSocialStartDate() == null) {
					errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), infoVo.getEmpIdcard() + "的社保起缴日期为空！"));
					continue;
				}

				if (null == socialInfo) {
					errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "无对应员工" +
							infoVo.getEmpIdcard() + "的社保数据(请查验社保缴纳地)"));
					continue;
				}

				//查看缴纳月是否为空
				if (!Common.isNotNull(infoVo.getSocialPayMonth())) {
					errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "必填项校验失败：社保缴纳月份不可为空！"));
					continue;
				}

				//判断是否存在养老缴费数据
				if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(infoVo.getUnitPensionMoney()),
						BigDecimalUtils.isNullToZero(infoVo.getPersonalPensionMoney())).compareTo(BigDecimal.ZERO) != 0) {
					paymentInfo = paymentInfoPensionMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ SocialConstants.YL);

					//存在社保缴费数据
					if (null != paymentInfo && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitPensionMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalPensionMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(paymentInfo.getUnitPensionMoney()),
							BigDecimalUtils.isNullToZero(paymentInfo.getPersonalPensionMoney()))).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的养老缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在失业缴费数据
				if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(infoVo.getUnitUnemploymentMoney()),
						BigDecimalUtils.isNullToZero(infoVo.getPersonalUnemploymentMoney())).compareTo(BigDecimal.ZERO) != 0) {
					paymentInfo = paymentInfoUnEmpMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ SocialConstants.SY);
					//存在社保缴费数据
					if (null != paymentInfo && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitUnemploymentMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalUnemploymentMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(paymentInfo.getUnitUnemploymentMoney()),
							BigDecimalUtils.isNullToZero(paymentInfo.getPersonalUnemploymentMoney()))).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的失业缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在医保缴费数据
				if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(infoVo.getUnitMedicalMoney()),
						BigDecimalUtils.isNullToZero(infoVo.getPersonalMedicalMoney())).compareTo(BigDecimal.ZERO) != 0) {
					paymentInfo = paymentInfoMedicalMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ SocialConstants.YB);

					//存在社保缴费数据
					if (null != paymentInfo && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitMedicalMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalMedicalMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(paymentInfo.getUnitMedicalMoney()),
							BigDecimalUtils.isNullToZero(paymentInfo.getPersonalMedicalMoney()))).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的医保缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在医疗救助金缴费数据
				if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(infoVo.getPersonalBigmailmentMoney()),
						BigDecimalUtils.isNullToZero(infoVo.getUnitBigmailmentMoney())).compareTo(BigDecimal.ZERO) != 0) {
					paymentInfo = paymentInfoBigMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ SocialConstants.DB);
					//存在社保缴费数据
					if (null != paymentInfo && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitBigmailmentMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalBigmailmentMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(paymentInfo.getUnitBigmailmentMoney()),
							BigDecimalUtils.isNullToZero(paymentInfo.getPersonalBigmailmentMoney()))).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的医疗救助金缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在工伤缴费数据
				if (BigDecimalUtils.isNullToZero(infoVo.getUnitInjuryMoney()).compareTo(BigDecimal.ZERO) != 0) {
					paymentInfo = paymentInfoInjuryMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ SocialConstants.GS);
					//存在社保缴费数据
					if (null != paymentInfo && BigDecimalUtils.safeMultiply(BigDecimalUtils.isNullToZero(infoVo.getUnitInjuryMoney()),
							BigDecimalUtils.isNullToZero(paymentInfo.getUnitInjuryMoney())).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的单位工伤缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在生育缴费数据
				if (BigDecimalUtils.isNullToZero(infoVo.getUnitBirthMoney()).compareTo(BigDecimal.ZERO) != 0) {
					paymentInfo = paymentInfoBirMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ SocialConstants.BIR);
					//存在社保缴费数据
					if (null != paymentInfo && BigDecimalUtils.safeMultiply(BigDecimalUtils.isNullToZero(infoVo.getUnitBirthMoney()),
							BigDecimalUtils.isNullToZero(paymentInfo.getUnitBirthMoney())).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的单位生育缴费数据,请勿重复导入！"));
						continue;
					}
				}
				tSocialInfo = socialInfoMapper.selectOne(Wrappers.<TSocialInfo>query().lambda()
						.eq(TSocialInfo::getEmpIdcard, infoVo.getEmpIdcard()).groupBy(TSocialInfo::getCreateTime)
						.last(CommonConstants.LAST_ONE_SQL));

				paymentInfo = new TPaymentInfo();
				paymentInfo.setLockStatus(CommonConstants.ZERO_STRING);
				paymentInfo.setEmpId(socialInfo.getEmpId());
				paymentInfo.setEmpIdcard(socialInfo.getEmpIdcard());
				paymentInfo.setEmpName(socialInfo.getEmpName());
				paymentInfo.setSettleDomainId(socialInfo.getSettleDomain());
				paymentInfo.setSettleDomainName(socialInfo.getSettleDomainName());
				paymentInfo.setSettleDomainCode(socialInfo.getSettleDomainCode());
				paymentInfo.setUnitId(socialInfo.getUnitId());
				paymentInfo.setUnitName(socialInfo.getUnitName());
				if (Common.isNotNull(tSocialInfo)) {
					paymentInfo.setInauguralTeam(tSocialInfo.getInauguralTeam());
					paymentInfo.setEmpNo(tSocialInfo.getEmpNo());
				}
				paymentInfo.setSocialProvince(socialInfo.getSocialProvince());
				paymentInfo.setSocialCity(socialInfo.getSocialCity());
				paymentInfo.setSocialTown(socialInfo.getSocialTown());
				paymentInfo.setSocialHousehold(socialInfo.getSocialHouseholdName());
				paymentInfo.setSocialPayMonth(infoVo.getSocialPayMonth());

				if (null != paymentInfo.getSocialProvince()) {
					temp = areaMap.get(paymentInfo.getSocialProvince());
					if (Common.isNotNull(temp)) {
						paymentInfo.setSocialPayAddr(temp);
					}
				}
				if (null != paymentInfo.getSocialCity()) {
					temp = areaMap.get(paymentInfo.getSocialCity());
					if (Common.isNotNull(temp)) {
						paymentInfo.setSocialPayAddr(paymentInfo.getSocialPayAddr() + CommonConstants.CENTER_SPLIT_LINE_STRING + temp);
					}
				}
				if (null != paymentInfo.getSocialTown()) {
					temp = areaMap.get(paymentInfo.getSocialTown());
					if (Common.isNotNull(temp)) {
						paymentInfo.setSocialPayAddr(paymentInfo.getSocialPayAddr() + CommonConstants.CENTER_SPLIT_LINE_STRING + temp);
					}
				}
				paymentInfo.setSocialSecurityNo(infoVo.getSocialSecurityNo());
				paymentInfo.setSocialCreateMonth(infoVo.getSocialCreateMonth());
				paymentInfo.setUnitPensionMoney(infoVo.getUnitPensionMoney());
				paymentInfo.setUnitMedicalMoney(infoVo.getUnitMedicalMoney());
				paymentInfo.setUnitBirthMoney(null == infoVo.getUnitBirthMoney() ? BigDecimal.ZERO : infoVo.getUnitBirthMoney());
				paymentInfo.setUnitBigmailmentMoney(infoVo.getUnitBigmailmentMoney());
				paymentInfo.setUnitInjuryMoney(infoVo.getUnitInjuryMoney());
				paymentInfo.setUnitUnemploymentMoney(infoVo.getUnitUnemploymentMoney());
				paymentInfo.setPersonalBigmailmentMoney(infoVo.getPersonalBigmailmentMoney());
				paymentInfo.setPersonalUnemploymentMoney(infoVo.getPersonalUnemploymentMoney());
				paymentInfo.setPersonalPensionMoney(infoVo.getPersonalPensionMoney());
				paymentInfo.setPersonalMedicalMoney(null == infoVo.getPersonalMedicalMoney()
						? BigDecimal.ZERO : infoVo.getPersonalMedicalMoney());
				paymentInfo.setUnitPensionSet(infoVo.getUnitPensionSet());
				paymentInfo.setUnitPensionPer(infoVo.getUnitPensionPer());
				paymentInfo.setUnitMedicalSet(infoVo.getUnitMedicalSet());
				paymentInfo.setUnitMedicalPer(infoVo.getUnitMedicalPer());
				paymentInfo.setUnitBirthSet(null == infoVo.getUnitBirthSet() ? BigDecimal.ZERO : infoVo.getUnitBirthSet());
				paymentInfo.setUnitBirthPer(infoVo.getUnitBirthPer());
				paymentInfo.setUnitInjurySet(infoVo.getUnitInjurySet());
				paymentInfo.setUnitInjuryPer(infoVo.getUnitInjuryPer());
				paymentInfo.setUnitUnemploymentSet(infoVo.getUnitUnemploymentSet());
				paymentInfo.setUnitUnemploymentPer(infoVo.getUnitUnemploymentPer());
				paymentInfo.setUnitBigailmentPer(infoVo.getUnitBigailmentPer());
				paymentInfo.setPersonalPensionPer(infoVo.getPersonalPensionPer());
				paymentInfo.setPersonalMedicalPer(infoVo.getPersonalMedicalPer());
				paymentInfo.setPersonalUnemploymentPer(infoVo.getPersonalUnemploymentPer());
				paymentInfo.setPersonalBigailmentPer(infoVo.getPersonalBigailmentPer());
				paymentInfo.setCompanyAccrual(infoVo.getCompanyAccrual());
				paymentInfo.setPersonalAccrual(infoVo.getPersonalAccrual());
				paymentInfo.setUnitSocialSum(BigDecimalUtils.safeAdd(paymentInfo.getUnitPensionMoney()
						, paymentInfo.getUnitMedicalMoney(), paymentInfo.getUnitBirthMoney()
						, paymentInfo.getUnitInjuryMoney()
						, paymentInfo.getUnitUnemploymentMoney()
						, paymentInfo.getUnitBigmailmentMoney()
						, paymentInfo.getCompanyAccrual()));
				paymentInfo.setSocialSecurityPersonalSum(BigDecimalUtils.safeAdd(paymentInfo.getPersonalBigmailmentMoney()
						, paymentInfo.getPersonalPensionMoney()
						, paymentInfo.getPersonalMedicalMoney()
						, paymentInfo.getPersonalUnemploymentMoney()
						, paymentInfo.getPersonalAccrual()));
				paymentInfo.setSocialSum(BigDecimalUtils.safeAdd(
						paymentInfo.getUnitSocialSum(), paymentInfo.getSocialSecurityPersonalSum()));
				paymentInfo.setSumAll(paymentInfo.getSocialSum());
				paymentInfo.setCreateBy(user.getId());
				paymentInfo.setCreateName(user.getNickname());
				paymentInfo.setSocialId(UUID.randomUUID().toString());
				res = insertAndSTimestamp(paymentInfo);
				if (res < 0) {
					errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), infoVo.getEmpName() + "_缴费库保存失败！"));
				}
			}
		}
		return errorMessageList;
	}

	/**
	 * 拼接排序字段并插入
	 *
	 * @param entity
	 * @return
	 * @Author huyc
	 * @Date 2022-07-25
	 **/
	private int insertAndSTimestamp(TPaymentInfo entity) {
		if (Common.isNotNull(entity.getSocialCreateMonth()) && Common.isNotNull(entity.getSocialPayMonth())) {
			entity.setSortTime(entity.getSocialCreateMonth().concat(entity.getSocialPayMonth()).concat(
					String.valueOf(System.currentTimeMillis())));
		}
		return baseMapper.insert(entity);
	}

	@Override
	public R<List<ErrorMessage>> importSocialHeFeiDiy(InputStream inputStream, String random, String type) {
		YifuUser user = SecurityUtils.getUser();
		List<ErrorMessage> errorMessageList = new ArrayList<>();
		ExcelUtil<TPaymentHeFeiVo> util1 = new ExcelUtil<>(TPaymentHeFeiVo.class);
		// 写法2：
		// 匿名内部类 不用额外写一个DemoDataListener
		// 这里 需要指定读用哪个class去读，然后读取第一个sheet 文件流会自动关闭
		try {
			EasyExcel.read(inputStream, TPaymentHeFeiVo.class, new ReadListener<TPaymentHeFeiVo>() {
				/**
				 * 单次缓存的数据量
				 */
				public static final int BATCH_COUNT = CommonConstants.BATCH_COUNT;
				Integer rowNumber;
				/**
				 *临时存储
				 */
				private List<TPaymentHeFeiVo> cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);

				@Override
				public void invoke(TPaymentHeFeiVo data, AnalysisContext context) {
					// 获取总行数（含表头）
					rowNumber = context.readSheetHolder().getApproximateTotalRowNumber();

					ReadRowHolder readRowHolder = context.readRowHolder();
					Integer rowIndex = readRowHolder.getRowIndex();
					data.setRowIndex(rowIndex + 1);
					ErrorMessage errorMessage = util1.checkEntity(data, data.getRowIndex());
					if (Common.isNotNull(errorMessage)) {
						errorMessageList.add(errorMessage);
					} else {
						cachedDataList.add(data);
					}
					if (cachedDataList.size() >= BATCH_COUNT) {
						saveData();
						// 存储完成清理 list
						cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
					}
				}

				@Override
				public void doAfterAllAnalysed(AnalysisContext context) {
					saveData();
				}

				/**
				 * 加上存储数据库
				 */
				private void saveData() {
					log.info("{}条数据，开始存储数据库！", cachedDataList.size());
					importTPaymentSocialHeFei(cachedDataList, errorMessageList, user, type, rowNumber);
					log.info("存储数据库成功！");
				}
			}).sheet().doRead();
		} catch (Exception e) {
			log.error(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR, e);
			return R.failed(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR);
		}
		return R.ok(errorMessageList);
	}

	@Override
	public R<List<ErrorMessage>> batchImportPaymentFundInfo(InputStream inputStream) {
		List<ErrorMessage> errorMessageList = new ArrayList<>();
		ExcelUtil<TPaymentInfoVo> util1 = new ExcelUtil<>(TPaymentInfoVo.class);
		// 写法2：
		// 匿名内部类 不用额外写一个DemoDataListener
		// 这里 需要指定读用哪个class去读，然后读取第一个sheet 文件流会自动关闭
		try {
			EasyExcel.read(inputStream, TPaymentInfoVo.class, new ReadListener<TPaymentInfoVo>() {
				/**
				 * 单次缓存的数据量
				 */
				public static final int BATCH_COUNT = CommonConstants.BATCH_COUNT;
				/**
				 *临时存储
				 */
				private List<TPaymentInfoVo> cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);

				@Override
				public void invoke(TPaymentInfoVo data, AnalysisContext context) {
					ReadRowHolder readRowHolder = context.readRowHolder();
					Integer rowIndex = readRowHolder.getRowIndex();
					data.setRowIndex(rowIndex + 1);
					ErrorMessage errorMessage = util1.checkEntity(data, data.getRowIndex());
					if (Common.isNotNull(errorMessage)) {
						errorMessageList.add(errorMessage);
					} else {
						cachedDataList.add(data);
					}
					if (cachedDataList.size() >= BATCH_COUNT) {
						saveData();
						// 存储完成清理 list
						cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
					}
				}

				@Override
				public void doAfterAllAnalysed(AnalysisContext context) {
					saveData();
				}

				/**
				 * 加上存储数据库
				 */
				private void saveData() {
					log.info("{}条数据，开始存储数据库！", cachedDataList.size());
					batchSavePaymentFundInfo(cachedDataList, errorMessageList);
					log.info("存储数据库成功！");
				}
			}).sheet().doRead();
		} catch (Exception e) {
			log.error(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR, e);
			return R.failed(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR);
		}
		return R.ok(errorMessageList);
	}

	private void batchSavePaymentFundInfo(List<TPaymentInfoVo> list, List<ErrorMessage> errorMessageList) {

		HashMap<String, String> areaMap = new HashMap<>();
		R<AreaVo> areaListR = upmsDaprUtils.getAreaListR();
		if (Common.isNotNull(areaListR)) {
			AreaVo areaList = areaListR.getData();
			if (null != areaList && !areaList.getSysAreaList().isEmpty()) {
				for (SysArea area : areaList.getSysAreaList()) {
					areaMap.put(Integer.toString(area.getId()), area.getAreaName());
				}
			}
		}
		try {
			if (Common.isNotNull(list)) {
				TPaymentInfo paymentInfo = null;
				TSocialFundInfo fund;
				String temp;
				int res = -1;

				//获取身份证列表
				List<String> idcards = list.stream().map(TPaymentInfoVo::getEmpIdcard).collect(Collectors.toList());
				//已存在档案数据
				//已存在派增公积金数据
				List<TSocialFundInfo> fundList = socialFundInfoMapper.selectList(Wrappers.<TSocialFundInfo>query().lambda()
						.in(TSocialFundInfo::getEmpIdcard, Common.listObjectToStrList(list, ExcelAttributeConstants.EMPIDCARD)));
				HashMap<String, Object> fundMap = fundList.stream().collect(HashMap::new, (m, v) ->
						m.put(v.getEmpIdcard(), v), HashMap::putAll);

				List<String> monthList = list.stream().map(TPaymentInfoVo::getProvidentPayMonth).collect(Collectors.toList());

				//已存在社保缴费库数据  非删除状态
				List<TPaymentInfo> paymentInfos = baseMapper.selectListForPaymentImport1(monthList, idcards);
				//公积金唯一性检验条件：身份证编码+公积金缴纳月份
				HashMap<String, Object> paymentInfoMap = new HashMap<>();
				if (Common.isNotNull(paymentInfos)) {
					for (TPaymentInfo info : paymentInfos) {
						paymentInfoMap.put(info.getProvidentPayAddr()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getEmpIdcard()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getProvidentPayMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getProvidentCreateMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ BigDecimalUtils.safeAdd(info.getProvidentSum()).doubleValue()
								, info);
					}
				}
				String[] areaArray;

				for (TPaymentInfoVo infoVo : list) {
					if (Common.isNotNull(infoVo.getEmpIdcard())) {
						infoVo.setEmpIdcard(infoVo.getEmpIdcard().replace("x", "X"));
					}
					//检查数据规范性
					if (!Common.isNotNull(infoVo.getEmpIdcard())) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), infoVo.getEmpName()
								+ CommonConstants.DOWN_LINE_STRING + "员工身份证不可为空！"));
						continue;
					}
					if (!Common.isNotNull(infoVo.getProvidentPayMonth())) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), infoVo.getEmpName()
								+ CommonConstants.DOWN_LINE_STRING + "公积金缴纳月份不可为空！"));
						continue;
					}
					if (!Common.isNotNull(infoVo.getProvidentCreateMonth())) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), infoVo.getEmpName()
								+ CommonConstants.DOWN_LINE_STRING + "公积金生成月份不可为空！"));
						continue;
					}
					if (!Common.isNotNull(infoVo.getProvidentPercent())) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), infoVo.getEmpName()
								+ CommonConstants.DOWN_LINE_STRING + "公积金单边比例不可为空！"));
						continue;
					}
					if (!Common.isNotNull(infoVo.getUnitProvidentSet())) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), infoVo.getEmpName()
								+ CommonConstants.DOWN_LINE_STRING + "公积金单边基数不可为空！"));
						continue;
					}
					if (!Common.isNotNull(infoVo.getProvidentPayAddr())) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), infoVo.getEmpName()
								+ CommonConstants.DOWN_LINE_STRING + "公积金缴纳地不可为空！"));
						continue;
					}
					if (fundMap.size() > CommonConstants.ZERO_INT) {
						fund = (TSocialFundInfo) fundMap.get(infoVo.getEmpIdcard());
						//对身份证与人员姓名的对应关系进行校验
						if (null != fund && !fund.getEmpName().equals(infoVo.getEmpName())) {
							errorMessageList.add
									(new ErrorMessage(infoVo.getRowIndex(), "姓名与身份证信息不一致，请核实后再次尝试！"));
							continue;
						}
						areaArray = infoVo.getProvidentPayAddr().split(CommonConstants.CENTER_SPLIT_LINE_STRING);
						fund = checkAddress(areaArray, areaMap, fund);
						//无对应员工公积金数据
						if (null == fund) {
							errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "无对应员工" + infoVo.getEmpName() +
									CommonConstants.DOWN_LINE_STRING + infoVo.getEmpIdcard()
									+ "的公积金数据(请查验公积金缴纳地)！"));
							continue;
						}
						//查看是否有操作对应主体的权限
						if (!Common.isNotNull(infoVo.getProvidentPayMonth())) {
							errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), infoVo.getEmpName() +
									CommonConstants.DOWN_LINE_STRING + "必填项校验失败：公积金缴纳月份不可为空！"));
							continue;
						}
						//计算公积金合计，个人金额和单位金额一致
						infoVo.setProvidentSum(BigDecimalUtils.safeAdd(infoVo.getUnitProvidentSum(), infoVo.getUnitProvidentSum()));
						// 判重
						if (paymentInfoMap.size() > CommonConstants.ZERO_INT) {
							paymentInfo = (TPaymentInfo) paymentInfoMap.get(infoVo.getProvidentPayAddr()
									+ CommonConstants.DOWN_LINE_STRING
									+ infoVo.getEmpIdcard().trim()
									+ CommonConstants.DOWN_LINE_STRING
									+ infoVo.getProvidentPayMonth().trim()
									+ CommonConstants.DOWN_LINE_STRING
									+ infoVo.getProvidentCreateMonth().trim()
									+ CommonConstants.DOWN_LINE_STRING
									+ Math.round(BigDecimalUtils.safeAdd(infoVo.getProvidentSum()).doubleValue() * 100) / 100.0);
						}
						//存在公积金缴费数据
						if (null != paymentInfo && BigDecimalUtils.isNullToZero(paymentInfo.getProvidentSum()).compareTo(BigDecimal.ZERO) != 0) {

							//允许覆盖，但已核准表或工资结算或已锁定不允许覆盖
							errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "已存在对应员工身份证" +
									infoVo.getEmpName() + CommonConstants.DOWN_LINE_STRING + infoVo.getEmpIdcard()
									+ "公积金缴费数据，禁止覆盖！"));
							continue;
						}

						TProvidentFund tProvidentFund = providentFundMapper.selectOne(Wrappers.<TProvidentFund>query().lambda()
								.eq(TProvidentFund::getEmpIdcard, infoVo.getEmpIdcard()).groupBy(TProvidentFund::getCreateTime)
								.last(CommonConstants.LAST_ONE_SQL));
						paymentInfo = new TPaymentInfo();
						paymentInfo.setLockStatus(CommonConstants.ZERO_STRING);
						paymentInfo.setEmpId(fund.getEmpId());
						paymentInfo.setEmpIdcard(fund.getEmpIdcard());
						paymentInfo.setEmpName(fund.getEmpName());
						paymentInfo.setSettleDomainId(fund.getSettleDomainFund());
						paymentInfo.setSettleDomainName(fund.getSettleDomainNameFund());
						paymentInfo.setSettleDomainCode(fund.getSettleDomainCodeFund());
						paymentInfo.setUnitId(fund.getUnitIdFund());
						paymentInfo.setUnitName(fund.getUnitNameFund());

						if (Common.isNotNull(tProvidentFund)) {
							paymentInfo.setInauguralTeam(tProvidentFund.getInauguralTeam());
							paymentInfo.setEmpNo(tProvidentFund.getEmpNo());
						}
						paymentInfo.setProvidentPayMonth(infoVo.getProvidentPayMonth());
						paymentInfo.setFundProvince(fund.getFundProvince());
						paymentInfo.setFundCity(fund.getFundCity());
						paymentInfo.setFundTown(fund.getFundTown());
						paymentInfo.setProvidentHousehold(fund.getProvidentHouseholdName());
						if (null != paymentInfo.getFundProvince()) {
							temp = areaMap.get(paymentInfo.getFundProvince());
							if (Common.isNotNull(temp)) {
								paymentInfo.setProvidentPayAddr(temp);
							}
						}
						if (null != paymentInfo.getFundCity()) {
							temp = areaMap.get(paymentInfo.getFundCity());
							if (Common.isNotNull(temp)) {
								paymentInfo.setProvidentPayAddr(paymentInfo.getProvidentPayAddr()
										+ CommonConstants.CENTER_SPLIT_LINE_STRING + temp);
							}
						}
						if (null != paymentInfo.getFundTown()) {
							temp = areaMap.get(paymentInfo.getFundTown());
							if (Common.isNotNull(temp)) {
								paymentInfo.setProvidentPayAddr(paymentInfo.getProvidentPayAddr()
										+ CommonConstants.CENTER_SPLIT_LINE_STRING + temp);
							}
						}

						paymentInfo.setProvidentCreateMonth(infoVo.getProvidentCreateMonth());
						paymentInfo.setUnitProvidentSet(null == infoVo.getUnitProvidentSet() ? BigDecimal.ZERO : infoVo.getUnitProvidentSet());
						paymentInfo.setPersonalProidentSet(null == infoVo.getUnitProvidentSet() ? BigDecimal.ZERO : infoVo.getUnitProvidentSet());
						paymentInfo.setProvidentPercent(null == infoVo.getProvidentPercent() ? BigDecimal.ZERO : infoVo.getProvidentPercent());
						paymentInfo.setProvidentNo(infoVo.getProvidentNo());
						paymentInfo.setPersonalProvidentSum(null == infoVo.getUnitProvidentSum() ? BigDecimal.ZERO : infoVo.getUnitProvidentSum());
						paymentInfo.setUnitProvidentSum(null == infoVo.getUnitProvidentSum() ? BigDecimal.ZERO : infoVo.getUnitProvidentSum());
						paymentInfo.setProvidentSum(null == infoVo.getProvidentSum() ? BigDecimal.ZERO : infoVo.getProvidentSum());
						paymentInfo.setSumAll(paymentInfo.getProvidentSum());
						paymentInfo.setFundId(UUID.randomUUID().toString());
						res = insertAndSTimestamp(paymentInfo);
						if (res < 0) {
							errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), infoVo.getEmpName()
									+ "_缴费库保存失败！"));
							continue;
						}
						if (Common.isNotNull(paymentInfo.getId()) && Common.isNotNull(paymentInfo.getFundId())) {
							paymentInfoMap.put(paymentInfo.getProvidentPayAddr()
									+ CommonConstants.DOWN_LINE_STRING
									+ paymentInfo.getEmpIdcard().trim()
									+ CommonConstants.DOWN_LINE_STRING
									+ paymentInfo.getProvidentPayMonth().trim()
									+ CommonConstants.DOWN_LINE_STRING
									+ paymentInfo.getProvidentCreateMonth().trim()
									+ CommonConstants.DOWN_LINE_STRING
									+ BigDecimalUtils.safeAdd(paymentInfo.getProvidentSum()).doubleValue(), paymentInfo);
						}
					}
				}
			}
		} catch (Exception e) {
			log.error("数据批量导入异常：" + e);
		}
	}

	private void importTPaymentSocialHeFei(List<TPaymentHeFeiVo> list, List<ErrorMessage> errorMessageList,
										   YifuUser user, String type, Integer rowNumber) {

		HashMap<String, String> areaMap = new HashMap<>();
		HashMap<String, String> areaMap2 = new HashMap<>();
		R<AreaVo> areaListR = upmsDaprUtils.getAreaListR();
		if (Common.isNotNull(areaListR)) {
			AreaVo areaList = areaListR.getData();
			if (null != areaList && !areaList.getSysAreaList().isEmpty()) {
				for (SysArea area : areaList.getSysAreaList()) {
					areaMap.put(Integer.toString(area.getId()), area.getAreaName());
					areaMap2.put(area.getAreaName() + CommonConstants.DOWN_LINE_STRING + (null == area.getParentId() ?
							"null" : (0 == area.getParentId() ? "null" : Integer.toString(
							area.getParentId()))), Integer.toString(area.getId()));
				}
			}
		}

		// 将以下代码提取出来，使用paymentInfoMap提升性能，避免list多次循环查询数据库浪费性能
		// 导入前做队列空闲判断，防止队列不足出现数据丢失的场景
		if (CollUtil.isNotEmpty(list)) {
			int taskSize = list.size() / partSize + CommonConstants.ONE_INT;
			int residualCapacity = yfSocialImportThreadPoolExecutor.getResidualCapacity();
			if (taskSize > residualCapacity) {
				errorMessageList.add(new ErrorMessage(-1, MsgUtils.getMessage(ErrorCodes.SOCIALINFO_LIST_NUM_LARGE)));
			} else {

				// -----------------------------生成paymentInfoMap本段开始--------------------------------
				//已存在的档案数据
				List<String> monthList = Common.listObjectToStrList(list, ExcelAttributeConstants.SOCIAL_PAY_MONTH).stream().distinct().collect(Collectors.toList());
				//已存在社保缴费库数据  非删除状态
				List<TPaymentInfo> paymentInfos = baseMapper.selectListForPaymentImport(monthList,
						Common.listObjectToStrList(list, ExcelAttributeConstants.EMPIDCARD));
				//养老
				ConcurrentHashMap<String, TPaymentInfo> paymentInfoPensionMap = new ConcurrentHashMap<>();
				//大病救助金
				ConcurrentHashMap<String, TPaymentInfo> paymentInfoBigMap = new ConcurrentHashMap<>();
				//失业
				ConcurrentHashMap<String, TPaymentInfo> paymentInfoUnEmpMap = new ConcurrentHashMap<>();
				//工伤
				ConcurrentHashMap<String, TPaymentInfo> paymentInfoInjuryMap = new ConcurrentHashMap<>();
				//医保
				ConcurrentHashMap<String, TPaymentInfo> paymentInfoMedicalMap = new ConcurrentHashMap<>();
				if (Common.isNotNull(paymentInfos)) {
					for (TPaymentInfo info : paymentInfos) {

						if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getUnitPensionMoney()),
								BigDecimalUtils.isNullToZero(info.getPersonalPensionMoney())).compareTo(BigDecimal.ZERO) != 0) {
							paymentInfoPensionMap.put(info.getSocialPayAddr()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getEmpIdcard()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialPayMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialCreateMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ PaymentConstants.PENSION_RISK
									, info);
						}
						if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getUnitUnemploymentMoney()),
								BigDecimalUtils.isNullToZero(info.getPersonalUnemploymentMoney())).compareTo(BigDecimal.ZERO) != 0) {
							paymentInfoUnEmpMap.put(info.getSocialPayAddr()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getEmpIdcard()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialPayMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialCreateMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ PaymentConstants.UNEMPLOYEEMENT_RISK
									, info);
						}
						if (BigDecimalUtils.isNullToZero(info.getUnitInjuryMoney()).compareTo(BigDecimal.ZERO) != 0) {
							paymentInfoInjuryMap.put(info.getSocialPayAddr()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getEmpIdcard()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialPayMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialCreateMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ PaymentConstants.INJURY_RISK
									, info);
						}
						if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getUnitMedicalMoney()),
								BigDecimalUtils.isNullToZero(info.getPersonalMedicalMoney())).compareTo(BigDecimal.ZERO) != 0) {
							paymentInfoMedicalMap.put(info.getSocialPayAddr()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getEmpIdcard()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialPayMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialCreateMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ PaymentConstants.MEDICAL
									, info);
						}
						if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getPersonalBigmailmentMoney()),
								BigDecimalUtils.isNullToZero(info.getUnitBigmailmentMoney())).compareTo(BigDecimal.ZERO) != 0) {
							paymentInfoBigMap.put(info.getSocialPayAddr()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getEmpIdcard()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialPayMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialCreateMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ SocialConstants.DB
									, info);
						}
					}
				}
				// -----------------------------生成paymentInfoMap本段结束--------------------------------

				// -----------------------------线程池处理list，批量保存社保信息开始--------------------------------
				List<TPaymentHeFeiVo> tempList = new ArrayList<>();

				List<CompletableFuture<List<ErrorMessage>>> completableFutureList = new ArrayList<>();

				String importSuccessKey = user.getId() + CommonConstants.DOWN_LINE_STRING + CommonConstants.PAYMENT_SOCIAL_WAIT_EXPORT;

				// 创建一个数值格式化对象
				NumberFormat numberFormat = NumberFormat.getInstance();
				// 设置精确到小数点后2位
				numberFormat.setMaximumFractionDigits(2);
				String maerialRatio = "";
				String sumNumKey = user.getId() + CommonConstants.DOWN_LINE_STRING + "sum_key";
				Integer bfInt = (Integer) redisUtil.get(sumNumKey);
				if (Common.isNotNull(bfInt)) {
					if (rowNumber > bfInt + 1) {
						maerialRatio = numberFormat.format(((float) bfInt / (float) rowNumber) * 100);
						bfInt = bfInt + 100;
						redisUtil.set(sumNumKey, bfInt, 360L);
					} else {
						maerialRatio = "100";
						redisUtil.remove(sumNumKey);
					}
				} else {
					if (rowNumber >= 100) {
						maerialRatio = numberFormat.format(((float) 100 / (float) rowNumber) * 100);
						bfInt = 100;
						redisUtil.set(sumNumKey, bfInt, 360L);
					} else {
						maerialRatio = "100";
					}
				}
				redisUtil.set(importSuccessKey, maerialRatio, 360L);

				try {
					// 1.list.size()不足partSize，直接执行
					if (list.size() < partSize) {
						CompletableFuture<List<ErrorMessage>> listCompletableFuture = CompletableFuture.supplyAsync(()
										-> executeImportSocialListThree(user, list, areaMap, areaMap2,
										paymentInfoPensionMap, paymentInfoMedicalMap, paymentInfoUnEmpMap, paymentInfoInjuryMap,
										paymentInfoBigMap, type, errorMessageList),
								yfSocialImportThreadPoolExecutor);
						completableFutureList.add(listCompletableFuture);
					}

					// 2.list.size()大于partSize，循环分批执行
					int lastIdx = 0;
					if (partSize <= list.size()) {
						// 处理第一个0位元素
						final List<TPaymentHeFeiVo> finalList = list.subList(0, 1);
						CompletableFuture<List<ErrorMessage>> oneCompletableFuture = CompletableFuture.supplyAsync(()
								-> executeImportSocialListThree(user, finalList, areaMap,
								areaMap2, paymentInfoPensionMap, paymentInfoMedicalMap, paymentInfoUnEmpMap,
								paymentInfoInjuryMap, paymentInfoBigMap, type,
								errorMessageList), yfSocialImportThreadPoolExecutor);
						completableFutureList.add(oneCompletableFuture);
						lastIdx = 1;
						for (int i = 1; i < list.size(); i++) {
							// partSize数量的list为一个执行单元
							tempList.add(list.get(i));
							if (i % partSize == 0) {
								lastIdx = i;
								List<TPaymentHeFeiVo> finalTempList1 = tempList;
								CompletableFuture<List<ErrorMessage>> listCompletableFuture = CompletableFuture.supplyAsync(()
										-> executeImportSocialListThree(user, finalTempList1
										, areaMap, areaMap2, paymentInfoPensionMap, paymentInfoMedicalMap,
										paymentInfoUnEmpMap, paymentInfoInjuryMap, paymentInfoBigMap, type,
										errorMessageList), yfSocialImportThreadPoolExecutor);
								completableFutureList.add(listCompletableFuture);
								tempList = new ArrayList<>();
							}
						}
					}

					// 3.第2种方式执行完后，有余数的情况下，执行3
					if (lastIdx != 0) {
						tempList = new ArrayList<>();
						if (lastIdx == 1) {
							for (int i = lastIdx; i < list.size(); i++) {
								tempList.add(list.get(i));
							}
						} else {
							for (int i = lastIdx + 1; i < list.size(); i++) {
								tempList.add(list.get(i));
							}
						}

						List<TPaymentHeFeiVo> finalTempList = tempList;
						CompletableFuture<List<ErrorMessage>> listCompletableFuture = CompletableFuture.supplyAsync(()
										-> executeImportSocialListThree(user, finalTempList, areaMap,
										areaMap2, paymentInfoPensionMap, paymentInfoMedicalMap, paymentInfoUnEmpMap,
										paymentInfoInjuryMap, paymentInfoBigMap, type, errorMessageList)
								, yfSocialImportThreadPoolExecutor);
						completableFutureList.add(listCompletableFuture);
					}

					// 阻塞当前线程，等待所有的线程执行完毕
					boolean computeFlag;
					do {
						computeFlag = false;
						for (CompletableFuture<List<ErrorMessage>> listCompletableFuture : completableFutureList) {
							if (!listCompletableFuture.isDone()) {
								computeFlag = true;
							}
						}
					} while (computeFlag);

				} catch (Exception e) {
					log.error("社保缴费库数据批量导入异常：" + e);
				}
			}
		}
	}

	private List<ErrorMessage> executeImportSocialListThree(YifuUser user,
															List<TPaymentHeFeiVo> list,
															HashMap<String, String> areaMap,
															HashMap<String, String> areaMap2,
															ConcurrentHashMap<String, TPaymentInfo> paymentInfoPensionMap,
															ConcurrentHashMap<String, TPaymentInfo> paymentInfoMedicalMap,
															ConcurrentHashMap<String, TPaymentInfo> paymentInfoUnEmpMap,
															ConcurrentHashMap<String, TPaymentInfo> paymentInfoInjuryMap,
															ConcurrentHashMap<String, TPaymentInfo> paymentInfoBigMap,
															String type, List<ErrorMessage> errorMessageList) {
		if (Common.isNotNull(list)) {
			TPaymentInfo payExists;
			TSocialFundInfo socialInfo = null;
			TSocialInfo tSocialInfo;
			String temp;
			int res = -1;

			List<TSocialFundInfo> socialInfoList = socialFundInfoMapper.selectList(Wrappers.<TSocialFundInfo>query().lambda()
					.in(TSocialFundInfo::getEmpIdcard, Common.listObjectToStrList(list, ExcelAttributeConstants.EMPIDCARD)));

			//已存在的社保数据
			HashMap<String, TSocialFundInfo> socialMap = new HashMap<>();
			if (Common.isNotNull(socialInfoList)) {
				for (TSocialFundInfo tSocialInfo1 : socialInfoList) {
					socialMap.put(tSocialInfo1.getEmpIdcard()
							+ CommonConstants.DOWN_LINE_STRING + tSocialInfo1.getSocialProvince()
							+ CommonConstants.DOWN_LINE_STRING + tSocialInfo1.getSocialCity()
							+ CommonConstants.DOWN_LINE_STRING + (null == tSocialInfo1.getSocialTown()
							? "null" : tSocialInfo1.getSocialTown()), tSocialInfo1);
				}
			}

			String[] areaArray;

			for (TPaymentHeFeiVo infoVo : list) {
				if (Common.isNotNull(infoVo.getEmpIdcard())) {
					infoVo.setEmpIdcard(infoVo.getEmpIdcard().replace("x", "X"));
				}
				//导入校验
				if (socialThreeCheckBase(errorMessageList, infoVo, type)) {
					continue;
				}
				//无对应员工的社保数据
				if (socialMap.size() > CommonConstants.ZERO_INT) {
					//采用客服导入的地址
					areaArray = infoVo.getSocialPayAddr().split(CommonConstants.CENTER_SPLIT_LINE_STRING);
					infoVo = initAddressThree(areaArray, areaMap2, infoVo);
					socialInfo = socialMap.get(infoVo.getEmpIdcard()
							+ CommonConstants.DOWN_LINE_STRING + infoVo.getSocialProvince()
							+ CommonConstants.DOWN_LINE_STRING + infoVo.getSocialCity()
							+ CommonConstants.DOWN_LINE_STRING + (null == infoVo.getSocialTown() ? "null" : infoVo.getSocialTown()));

					//对身份证与人员姓名的对应关系进行校验
					if (socialInfo != null && !socialInfo.getEmpName().equals(infoVo.getEmpName())) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "姓名与身份证信息不一致，请核实后再次尝试！"));
						continue;
					}
					if (socialInfo != null && socialInfo.getSocialStartDate() == null) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), infoVo.getEmpIdcard() + "的社保起缴日期为空！"));
						continue;
					}
				}
				if (null == socialInfo) {
					errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "无对应员工" + infoVo.getEmpIdcard() +
							"的社保数据(请查验社保缴纳地)"));
					continue;
				}

				//查看缴纳月是否为空
				if (!Common.isNotNull(infoVo.getSocialPayMonth())) {
					errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "必填项校验失败：社保缴纳月份不可为空！"));
					continue;
				}

				//判断是否存在养老缴费数据
				if (PaymentConstants.PENSION_RISK.equals(infoVo.getRiskType())) {
					payExists = paymentInfoPensionMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ PaymentConstants.PENSION_RISK);
					//存在社保缴费数据
					if (null != payExists && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getPersonalMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getUnitMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(payExists.getUnitPensionMoney()),
							BigDecimalUtils.isNullToZero(payExists.getPersonalPensionMoney()))).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的养老缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在失业缴费数据
				if (PaymentConstants.UNEMPLOYEEMENT_RISK.equals(infoVo.getRiskType())) {
					payExists = paymentInfoUnEmpMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ PaymentConstants.UNEMPLOYEEMENT_RISK);
					//存在社保缴费数据
					if (null != payExists && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getPersonalMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getUnitMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(payExists.getUnitUnemploymentMoney()),
							BigDecimalUtils.isNullToZero(payExists.getPersonalUnemploymentMoney()))).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的失业缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在医保缴费数据
				if (CommonConstants.ONE_STRING.equals(type)) {
					payExists = paymentInfoMedicalMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ PaymentConstants.MEDICAL);

					//存在社保缴费数据
					if (null != payExists && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitMedicalMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalMedicalMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(payExists.getUnitMedicalMoney()),
							BigDecimalUtils.isNullToZero(payExists.getPersonalMedicalMoney()))).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的医保缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在工伤缴费数据
				if (PaymentConstants.INJURY_RISK.equals(infoVo.getRiskType())) {
					payExists = paymentInfoInjuryMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ PaymentConstants.INJURY_RISK);

					//存在社保缴费数据
					if (null != payExists && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
									BigDecimalUtils.isNullToZero(infoVo.getUnitMedicalMoney()),
									BigDecimalUtils.isNullToZero(infoVo.getPersonalMedicalMoney())),
							BigDecimalUtils.isNullToZero(payExists.getUnitInjuryMoney())).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的单位工伤缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在医疗救助金缴费数据
				if (CommonConstants.ONE_STRING.equals(type)) {
					payExists = paymentInfoBigMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ SocialConstants.DB);

					//存在社保缴费数据
					if (null != payExists && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitBigailmentMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalBigailmentMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(payExists.getUnitBigmailmentMoney()),
							BigDecimalUtils.isNullToZero(payExists.getPersonalBigmailmentMoney()))).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的医疗救助金缴费数据,请勿重复导入！"));
						continue;
					}
				}

				tSocialInfo = socialInfoMapper.selectOne(Wrappers.<TSocialInfo>query().lambda()
						.eq(TSocialInfo::getEmpIdcard, infoVo.getEmpIdcard()).groupBy(TSocialInfo::getCreateTime)
						.last(CommonConstants.LAST_ONE_SQL));

				payExists = new TPaymentInfo();
				payExists.setLockStatus(CommonConstants.ZERO_STRING);
				payExists.setEmpId(socialInfo.getEmpId());
				payExists.setEmpIdcard(socialInfo.getEmpIdcard());
				payExists.setEmpName(socialInfo.getEmpName());
				payExists.setSettleDomainId(socialInfo.getSettleDomain());
				payExists.setSettleDomainName(socialInfo.getSettleDomainName());
				payExists.setSettleDomainCode(socialInfo.getSettleDomainCode());
				payExists.setUnitId(socialInfo.getUnitId());
				payExists.setUnitName(socialInfo.getUnitName());
				if (Common.isNotNull(tSocialInfo)) {
					payExists.setInauguralTeam(tSocialInfo.getInauguralTeam());
					payExists.setEmpNo(tSocialInfo.getEmpNo());
				}

				payExists.setSocialProvince(socialInfo.getSocialProvince());
				payExists.setSocialCity(socialInfo.getSocialCity());
				payExists.setSocialTown(socialInfo.getSocialTown());

				payExists.setSocialHousehold(socialInfo.getSocialHouseholdName());
				payExists.setSocialPayMonth(infoVo.getSocialPayMonth());

				if (null != payExists.getSocialProvince()) {
					temp = areaMap.get(payExists.getSocialProvince());
					if (Common.isNotNull(temp)) {
						payExists.setSocialPayAddr(temp);
					}
				}
				if (null != payExists.getSocialCity()) {
					temp = areaMap.get(payExists.getSocialCity());
					if (Common.isNotNull(temp)) {
						payExists.setSocialPayAddr(payExists.getSocialPayAddr() + CommonConstants.CENTER_SPLIT_LINE_STRING + temp);
					}
				}
				if (null != payExists.getSocialTown()) {
					temp = areaMap.get(payExists.getSocialTown());
					if (Common.isNotNull(temp)) {
						payExists.setSocialPayAddr(payExists.getSocialPayAddr() + CommonConstants.CENTER_SPLIT_LINE_STRING + temp);
					}
				}
				payExists.setSocialSecurityNo(infoVo.getSocialSecurityNo());
				payExists.setSocialCreateMonth(infoVo.getSocialCreateMonth());
				if (PaymentConstants.PENSION_RISK.equals(infoVo.getRiskType())) {
					payExists.setUnitPensionMoney(infoVo.getUnitMoney());
					payExists.setUnitPensionSet(infoVo.getUnitSet());
					payExists.setPersonalPensionMoney(infoVo.getPersonalMoney());
					payExists.setUnitSocialSum(BigDecimalUtils.safeAdd(payExists.getUnitPensionMoney()
							, payExists.getUnitSocialSum()));
					payExists.setSocialSecurityPersonalSum(BigDecimalUtils.safeAdd(payExists.getPersonalPensionMoney()
							, payExists.getSocialSecurityPersonalSum()));
				}
				if (PaymentConstants.UNEMPLOYEEMENT_RISK.equals(infoVo.getRiskType())) {
					payExists.setUnitUnemploymentMoney(infoVo.getUnitMoney());
					payExists.setPersonalUnemploymentMoney(infoVo.getPersonalMoney());
					payExists.setUnitUnemploymentSet(infoVo.getUnitSet());
					payExists.setUnitSocialSum(BigDecimalUtils.safeAdd(payExists.getUnitUnemploymentMoney()
							, payExists.getUnitSocialSum()));
					payExists.setSocialSecurityPersonalSum(BigDecimalUtils.safeAdd(payExists.getPersonalUnemploymentMoney()
							, payExists.getSocialSecurityPersonalSum()));
				}
				if (PaymentConstants.INJURY_RISK.equals(infoVo.getRiskType())) {
					payExists.setUnitInjuryMoney(infoVo.getUnitMoney());
					payExists.setUnitInjurySet(infoVo.getUnitSet());
					payExists.setUnitSocialSum(BigDecimalUtils.safeAdd(payExists.getUnitInjuryMoney()
							, payExists.getUnitSocialSum()));
				}
				if (CommonConstants.ONE_STRING.equals(type)) {
					payExists.setUnitMedicalMoney(infoVo.getUnitMedicalMoney());
					payExists.setPersonalMedicalMoney(infoVo.getPersonalMedicalMoney());
					payExists.setUnitBigmailmentMoney(infoVo.getUnitBigailmentMoney());
					payExists.setUnitMedicalSet(infoVo.getMedicalSet());
					payExists.setPersonalBigmailmentMoney(infoVo.getPersonalBigailmentMoney());
					payExists.setSocialSecurityNo(infoVo.getSocialSecurityNo());

					payExists.setUnitSocialSum(BigDecimalUtils.safeAdd(payExists.getUnitMedicalMoney()
							, payExists.getUnitBigmailmentMoney()
							, payExists.getUnitSocialSum()));
					payExists.setSocialSecurityPersonalSum(BigDecimalUtils.safeAdd(payExists.getPersonalMedicalMoney()
							, payExists.getPersonalBigmailmentMoney()
							, payExists.getSocialSecurityPersonalSum()));
				}
				payExists.setSocialSum(BigDecimalUtils.safeAdd(payExists.getUnitSocialSum(), payExists.getSocialSecurityPersonalSum()));
				payExists.setSumAll(payExists.getSocialSum());
				payExists.setCreateBy(user.getId());
				payExists.setCreateName(user.getNickname());
				payExists.setSocialId(UUID.randomUUID().toString());

				res = insertAndSTimestamp(payExists);
				if (res < 0) {
					errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), infoVo.getEmpIdcard() + "_缴费库保存失败！"));
				}
			}
		}
		return errorMessageList;
	}

	/**
	 * 导入校验
	 **/
	private boolean socialThreeCheckBase(List<ErrorMessage> errorMessageList, TPaymentHeFeiVo
			infoVo, String type) {
		if (!Common.isNotNull(infoVo.getSocialPayMonth())) {
			errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "社保缴纳月份不可为空！"));
			return true;
		}
		if (!Common.isNotNull(infoVo.getSocialCreateMonth())) {
			errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "社保生成月份不可为空！"));
			return true;
		}
		if (!Common.isNotNull(infoVo.getSocialPayAddr())) {
			errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "社保缴纳地不可为空！"));
			return true;
		}
		if (CommonConstants.ZERO_STRING.equals(type) && !PaymentConstants.PENSION_RISK.equals(infoVo.getRiskType())
				&& !PaymentConstants.UNEMPLOYEEMENT_RISK.equals(infoVo.getRiskType())
				&& !PaymentConstants.INJURY_RISK.equals(infoVo.getRiskType())) {
			errorMessageList.add(new ErrorMessage(infoVo.getRowIndex(), "无相关险种！"));
			return true;
		}
		return false;
	}

	/**
	 * 转换缴纳地址为省市县ID
	 **/
	private TPaymentHeFeiVo initAddressThree(String[] areaArray, HashMap<String, String> areaMap2, TPaymentHeFeiVo s) {
		if (null == areaArray || null == areaMap2 || null == s) {
			return s;
		}
		String temp;
		if (areaArray.length >= CommonConstants.TWO_INT) {
			temp = areaMap2.get(areaArray[0] + CommonConstants.DOWN_LINE_STRING + "null");
			if (Common.isNotNull(temp)) {
				s.setSocialProvince(Integer.valueOf(temp));
			}
			temp = areaMap2.get(areaArray[1] + CommonConstants.DOWN_LINE_STRING + (null == s.getSocialProvince()
					? "null" : Integer.toString(s.getSocialProvince())));
			if (Common.isNotNull(temp)) {
				s.setSocialCity(Integer.valueOf(temp));
			}
			if (areaArray.length >= CommonConstants.THREE_INT) {
				temp = areaMap2.get(areaArray[2] + CommonConstants.DOWN_LINE_STRING + (null == s.getSocialCity()
						? "null" : Integer.toString(s.getSocialCity())));
				if (Common.isNotNull(temp)) {
					s.setSocialTown(Integer.valueOf(temp));
				}
			}
		}
		return s;
	}

	//比对缴纳地是否一致
	private TSocialFundInfo checkAddress(String[] areaArray, HashMap<String, String> areaMap, TSocialFundInfo s) {
		if (null == areaArray || null == areaMap || null == s) {
			return null;
		}
		if (areaArray.length >= CommonConstants.TWO_INT) {
			if (null != s.getFundProvince()) {
				if (areaArray[0].equals(areaMap.get(s.getFundProvince()))) {
					if (null != s.getFundCity()) {
						if (areaArray[1].equals(areaMap.get(s.getFundCity()))) {
							if (areaArray.length >= CommonConstants.THREE_INT) {
								if (null != s.getFundTown() && areaArray[CommonConstants.TWO_INT].equals(
										areaMap.get(s.getFundTown()))) {
									return s;
								}
							} else {
								if (null == s.getFundTown()) {
									return s;
								}
							}
						}
					} else {
						return null;
					}
				}

			} else {
				return null;
			}

		} else if (areaArray.length == 1) {
			if (null != s.getFundProvince() && null == s.getFundCity()) {
				if (areaArray[0].equals(areaMap.get(s.getFundProvince()))) {
					return s;
				}
			} else {
				return null;
			}
		}
		return null;
	}

	/**
	 * 薪资获取缴费库
	 *
	 * @Author hgw
	 * @Date 2022-8-10 18:06:13
	 **/
	@Override
	public TPaymentVo selectTPaymentBySalaryVo(TPaymentBySalaryVo tPaymentBySalaryVo) {
		List<TPaymentBySalaryVo> list = baseMapper.selectTPaymentBySalaryVo(tPaymentBySalaryVo);
		TPaymentVo vo = new TPaymentVo();
		vo.setPaymentList(list);
		return vo;
	}

	@Override
	public int updatePaymentSocialStatusToSettle(List<String> idList) {
		if (idList != null && !idList.isEmpty()) {
			return baseMapper.updatePaymentSocialStatusByIdList(idList, CommonConstants.ONE_STRING);
		}
		return 0;
	}

	@Override
	public int updatePaymentSocialStatusToNoSettle(List<String> idList) {
		if (idList != null && !idList.isEmpty()) {
			return baseMapper.updatePaymentSocialStatusByIdList(idList, CommonConstants.ZERO_STRING);
		}
		return 0;
	}

	@Override
	public int updatePaymentFundStatusToSettle(List<String> idList) {
		if (idList != null && !idList.isEmpty()) {
			return baseMapper.updatePaymentFundStatusByIdList(idList, CommonConstants.ONE_STRING);
		}
		return 0;
	}

	@Override
	public int updatePaymentFundStatusToNoSettle(List<String> idList) {
		if (idList != null && !idList.isEmpty()) {
			return baseMapper.updatePaymentFundStatusByIdList(idList, CommonConstants.ZERO_STRING);
		}
		return 0;
	}

	@Override
	public void updatePaymentSocialAndFound(UpdateSocialFoundVo infoVo) {
		if (Common.isNotNull(infoVo)) {
			baseMapper.updatePaymentSocialAndFound(infoVo);
		}
	}

	@Override
	public void createPaymentSocialInfo() {
		//获取所有未推送的社保实缴明细数据
		List<TPaymentInfo> unPushInfo = baseMapper.selectList(Wrappers.<TPaymentInfo>query().lambda()
				.eq(TPaymentInfo::getPushStatus, CommonConstants.ONE_STRING)
				.isNotNull(TPaymentInfo::getSocialId));
		if (Common.isNotNull(unPushInfo)) {
			//推送数据封装并推送
			initEkpPushSocialParam(unPushInfo);
		}
	}

	@Override
	public void createPaymentFundInfo() {
		//获取所有未推送的公积金实缴明细数据
		List<TPaymentInfo> unPushInfo = baseMapper.selectList(Wrappers.<TPaymentInfo>query().lambda()
				.eq(TPaymentInfo::getPushStatus, CommonConstants.ONE_STRING)
				.isNotNull(TPaymentInfo::getFundId));
		if (Common.isNotNull(unPushInfo)) {
			//推送数据封装并推送
			initEkpPushFundParam(unPushInfo);
		}
	}

	@Override
	public void pushPaymentSocialFundInfo() {
		YifuUser user = SecurityUtils.getUser();
		//手动推送未推送的社保公积金明细数据
		createPaymentSocialInfoReal(user);
		createPaymentFundInfoReal(user);
		//推送社保公积金收入数据
		createPaymentInfoIncomeReal(user);
		createPaymentFundIncomeReal(user);
	}

	@Override
	public void createPaymentInfoIncome() {
		//判断缴费库中社保合计和本次导入合计相加是否为0，为0则不生成收入
		List<TPaymentInfo> sumList = baseMapper.selectList(Wrappers.<TPaymentInfo>query().lambda()
				.between(TPaymentInfo::getCreateTime, LocalDateTimeUtils.getThatDayStartTime(LocalDateTime.now().plusDays(-1)),
						LocalDateTimeUtils.getDayStart(LocalDateTime.now()))
				.isNotNull(TPaymentInfo::getSocialId));
		if (Common.isNotNull(sumList)) {
			//生成收入
			createIncomeInfo(sumList, CommonConstants.ONE_STRING);
		}
	}

	@Override
	public void createPaymentFundIncome() {
		List<TPaymentInfo> sumList = baseMapper.selectList(Wrappers.<TPaymentInfo>query().lambda()
				.between(TPaymentInfo::getCreateTime, LocalDateTimeUtils.getThatDayStartTime(LocalDateTime.now().plusDays(-1)),
						LocalDateTimeUtils.getDayStart(LocalDateTime.now()))
				.isNotNull(TPaymentInfo::getFundId));
		if (Common.isNotNull(sumList)) {
			//生成公积金收入
			createIncomeInfo(sumList, CommonConstants.TWO_STRING);
		}
	}

	public void createPaymentSocialInfoReal(YifuUser user) {
		//获取所有未推送的社保实缴明细数据
		List<TPaymentInfo> unPushInfo = baseMapper.selectList(Wrappers.<TPaymentInfo>query().lambda()
				.eq(TPaymentInfo::getCreateBy, user.getId())
				.eq(TPaymentInfo::getPushStatus, CommonConstants.ONE_STRING)
				.isNotNull(TPaymentInfo::getSocialId));
		if (Common.isNotNull(unPushInfo)) {
			//推送数据封装并推送
			initEkpPushSocialParam(unPushInfo);
		}
	}

	public void createPaymentFundInfoReal(YifuUser user) {
		//获取所有未推送的公积金实缴明细数据
		List<TPaymentInfo> unPushInfo = baseMapper.selectList(Wrappers.<TPaymentInfo>query().lambda()
				.eq(TPaymentInfo::getCreateBy, user.getId())
				.eq(TPaymentInfo::getPushStatus, CommonConstants.ONE_STRING)
				.isNotNull(TPaymentInfo::getFundId));
		if (Common.isNotNull(unPushInfo)) {
			//推送数据封装并推送
			initEkpPushFundParam(unPushInfo);
		}
	}

	public void createPaymentInfoIncomeReal(YifuUser user) {
		//判断缴费库中社保合计和本次导入合计相加是否为0，为0则不生成收入
		List<TPaymentInfo> sumList = baseMapper.selectList(Wrappers.<TPaymentInfo>query().lambda()
				.eq(TPaymentInfo::getCreateBy, user.getId())
				.eq(TPaymentInfo::getIncomeStatus, CommonConstants.ONE_STRING)
				.isNotNull(TPaymentInfo::getSocialId));
		if (Common.isNotNull(sumList)) {
			//生成收入
			createIncomeInfo(sumList, CommonConstants.ONE_STRING);
		}
	}

	public void createPaymentFundIncomeReal(YifuUser user) {
		List<TPaymentInfo> sumList = baseMapper.selectList(Wrappers.<TPaymentInfo>query().lambda()
				.eq(TPaymentInfo::getCreateBy, user.getId())
				.eq(TPaymentInfo::getIncomeStatus, CommonConstants.ONE_STRING)
				.isNotNull(TPaymentInfo::getFundId));
		if (Common.isNotNull(sumList)) {
			//生成公积金收入
			createIncomeInfo(sumList, CommonConstants.TWO_STRING);
		}
	}

	@Override
	public TPaymentVo getPaymentSocialAndFound(TPaymentInfo info) {
		List<TPaymentInfo> sumList = baseMapper.selectList(Wrappers.<TPaymentInfo>query().lambda()
				.eq(TPaymentInfo::getEmpIdcard, info.getEmpIdcard())
				.eq(TPaymentInfo::getSettleDomainId, info.getSettleDomainId())
				.eq(TPaymentInfo::getSocialCreateMonth, "202212"));
		TPaymentVo paymentVo = new TPaymentVo();
		paymentVo.setPaymentInfoList(sumList);
		return paymentVo;
	}

	public void initEkpPushSocialParam(List<TPaymentInfo> unPushInfo) {
		List<String> pushList = new ArrayList<>();
		Map<String, Integer> map = new HashMap<>();
		Map<String, String> idMap = new HashMap<>();
		List<TSettleDomainSelectVo> settleDomainR;
		R<TSettleDomainListVo> listVo;
		for (TPaymentInfo library : unPushInfo) {

			//获取项目信息
			TSettleDomain settleDomain = new TSettleDomain();
			listVo = archivesDaprUtil.selectSettleDomainSelectVoById(library.getSettleDomainId());
			if (Common.isNotNull(listVo)) {
				TSettleDomainListVo tSettleDomainListVo = listVo.getData();
				if (Common.isNotNull(tSettleDomainListVo) && Common.isNotEmpty(tSettleDomainListVo.getListSelectVO())) {
					settleDomainR = tSettleDomainListVo.getListSelectVO();
					for (TSettleDomainSelectVo vo : settleDomainR) {
						BeanUtils.copyProperties(vo, settleDomain);
					}
				}
			}
			EkpPushSocialParam socialParam = new EkpPushSocialParam();
			//员工姓名
			socialParam.setFd_3adfe8c79989d4(library.getEmpName());
			//员工身份证
			socialParam.setFd_3adfe8c7e4cf7a(library.getEmpIdcard());
			//单位养老金额
			socialParam.setFd_3af9ec80a9de7a(CommonConstants.EMPTY_STRING);
			//单位医疗金额
			socialParam.setFd_3af9eba5899c90(CommonConstants.EMPTY_STRING);
			//单位工伤金额
			socialParam.setFd_3af9eba684f592(CommonConstants.EMPTY_STRING);
			//单位失业金额
			socialParam.setFd_3af9eba5f6e19e(CommonConstants.EMPTY_STRING);
			//单位生育金额
			socialParam.setFd_3af9eba71c0138(CommonConstants.EMPTY_STRING);
			//单位大病金额
			socialParam.setFd_3af9eba863c0ee(CommonConstants.EMPTY_STRING);
			//预估个人养老
			socialParam.setFd_3af9ebbd791662(CommonConstants.EMPTY_STRING);
			//预估个人医疗
			socialParam.setFd_3af9ebbdd9797e(CommonConstants.EMPTY_STRING);
			//预估单位合计
			socialParam.setFd_3adfeb4e8064a8(CommonConstants.EMPTY_STRING);
			//个人社保合计
			socialParam.setFd_3adfeb52a4d2e2(CommonConstants.EMPTY_STRING);
			//预估个人大病救助
			socialParam.setFd_3af9ebbf3e8be2(CommonConstants.EMPTY_STRING);
			//预估个人失业
			socialParam.setFd_3af9ebbe29ce1c(CommonConstants.EMPTY_STRING);
			//结算状态
			// hgw2022-9-30 12:03:05根据倩倩的需求，改为默认空，未结算
			socialParam.setFd_3add9ea428879a(CommonConstants.SALARY_UNFLAG);
			//社保缴纳月份
			if (Common.isNotNull(library.getSocialPayMonth())) {
				socialParam.setFd_3adfe8cf632700(dateStringInsert(library.getSocialPayMonth()));
			} else {
				socialParam.setFd_3adfe8cf632700(CommonConstants.EMPTY_STRING);
			}
			//社保生成月份
			if (Common.isNotNull(library.getSocialCreateMonth())) {
				socialParam.setFd_3adfe8cb96c41e(dateStringInsert(library.getSocialCreateMonth()));
			} else {
				socialParam.setFd_3adfe8cb96c41e(CommonConstants.EMPTY_STRING);
			}
			//订单类型
			socialParam.setFd_3add9dd7833db8(SocialConstants.DIFF_TYPE_THR);
			//是否有预估
			if (Common.isNotNull(settleDomain.getSocialType()) &&
					CommonConstants.ONE_STRING.equals(settleDomain.getSocialType())) {
				socialParam.setFd_3add9de0be85e4(CommonConstants.IS_TRUE);
			} else {
				socialParam.setFd_3add9de0be85e4(CommonConstants.IS_FALSE);
			}
			//与工资合并结算
			socialParam.setFd_3add9e1a670144(CommonConstants.IS_FALSE);
			//项目编码
			socialParam.setFd_3adfe8c70d3fd4(library.getSettleDomainCode());
			//项目名称
			socialParam.setFd_3adfe8c8468e54(library.getSettleDomainName());
			//单号
			socialParam.setFd_3adfe95c169c48(CommonConstants.EMPTY_STRING);
			//客户编码
			if (Common.isNotNull(settleDomain.getCustomerNo())) {
				socialParam.setFd_3adfe8c73cb5a4(settleDomain.getCustomerNo());
			} else {
				socialParam.setFd_3adfe8c73cb5a4(CommonConstants.EMPTY_STRING);
			}
			//是否为BPO业务
			if (Common.isNotNull(settleDomain.getBpoFlag())) {
				socialParam.setFd_3b178dfcf9e3e6(settleDomain.getBpoFlag());
			} else {
				socialParam.setFd_3b178dfcf9e3e6(CommonConstants.EMPTY_STRING);
			}
			//客户名称
			if (Common.isNotNull(library.getUnitName())) {
				socialParam.setFd_3adfe8c81a0e42(library.getUnitName());
			} else {
				socialParam.setFd_3adfe8c81a0e42(CommonConstants.EMPTY_STRING);
			}
			//社保户
			if (Common.isNotNull(library.getSocialHousehold())) {
				socialParam.setFd_3aeafa25916e82(library.getSocialHousehold());
			} else {
				socialParam.setFd_3aeafa25916e82(CommonConstants.EMPTY_STRING);
			}
			//结算月份
			socialParam.setFd_3adfe8cff746bc(CommonConstants.EMPTY_STRING);
			//单位差异
			socialParam.setFd_3adfeb53c70f72(CommonConstants.EMPTY_STRING);
			//个人差异
			socialParam.setFd_3adfeb5413fb44(CommonConstants.EMPTY_STRING);
			//应收
			socialParam.setFd_3adfeb7b624f06(CommonConstants.EMPTY_STRING);
			//收款状态
			socialParam.setFd_3add9eaeed2560(CommonConstants.EMPTY_STRING);
			//结算单号
			socialParam.setFd_3adfeb830523b6(CommonConstants.EMPTY_STRING);
			//收款单号
			socialParam.setFd_3adfeb8489e6c2(CommonConstants.EMPTY_STRING);
			//应支出
			socialParam.setFd_3adfeb7bd97464(CommonConstants.EMPTY_STRING);
			//支出结算状态
			socialParam.setFd_3add9edfbc6f7e(CommonConstants.EMPTY_STRING);
			//付款状态
			socialParam.setFd_3add9eed23894a(CommonConstants.EMPTY_STRING);
			//支出缴纳单号
			socialParam.setFd_3adfeb83a704c8(CommonConstants.EMPTY_STRING);
			//实缴单位生育
			if (Common.isNotNull(library.getUnitBirthMoney())) {
				socialParam.setFd_3af9ee3afb34c2(library.getUnitBirthMoney().toString());
			} else {
				socialParam.setFd_3af9ee3afb34c2(CommonConstants.EMPTY_STRING);
			}
			//付款单号
			socialParam.setFd_3adfeb84175f28(CommonConstants.EMPTY_STRING);
			//实缴个人合计
			if (Common.isNotNull(library.getSocialSecurityPersonalSum())) {
				socialParam.setFd_3af9ee3cb6d4fa(library.getSocialSecurityPersonalSum().toString());
			} else {
				socialParam.setFd_3af9ee3cb6d4fa(CommonConstants.EMPTY_STRING);
			}
			//预估合计
			socialParam.setFd_3af9ed7e813b86(CommonConstants.EMPTY_STRING);
			//实缴单位合计
			if (Common.isNotNull(library.getUnitSocialSum())) {
				socialParam.setFd_3af9ee3c0bf286(library.getUnitSocialSum().toString());
			} else {
				socialParam.setFd_3af9ee3c0bf286(CommonConstants.EMPTY_STRING);
			}
			//实缴个人补缴利息
			if (Common.isNotNull(library.getPersonalAccrual())) {
				socialParam.setFd_3af9ee3d634946(library.getPersonalAccrual().toString());
			} else {
				socialParam.setFd_3af9ee3d634946(CommonConstants.EMPTY_STRING);
			}
			//实缴单位医疗
			if (Common.isNotNull(library.getUnitMedicalMoney())) {
				socialParam.setFd_3af9ee39dea6a8(library.getUnitMedicalMoney().toString());
			} else {
				socialParam.setFd_3af9ee39dea6a8(CommonConstants.EMPTY_STRING);
			}
			//预估个人补缴利息
			socialParam.setFd_3af9ebbecc4aa8(CommonConstants.EMPTY_STRING);
			//预估单位补缴利息
			socialParam.setFd_3af9eba7c3da5e(CommonConstants.EMPTY_STRING);
			//实缴单位养老
			if (Common.isNotNull(library.getUnitPensionMoney())) {
				socialParam.setFd_3af9ee3938170a(library.getUnitPensionMoney().toString());
			} else {
				socialParam.setFd_3af9ee3938170a(CommonConstants.EMPTY_STRING);
			}
			//实缴个人失业
			if (Common.isNotNull(library.getPersonalUnemploymentMoney())) {
				socialParam.setFd_3af9ee3db44d96(library.getPersonalUnemploymentMoney().toString());
			} else {
				socialParam.setFd_3af9ee3db44d96(CommonConstants.EMPTY_STRING);
			}
			//实缴单位补缴利息
			if (Common.isNotNull(library.getCompanyAccrual())) {
				socialParam.setFd_3af9ee3b5ddae8(library.getCompanyAccrual().toString());
			} else {
				socialParam.setFd_3af9ee3b5ddae8(CommonConstants.EMPTY_STRING);
			}
			//实缴单位大病救助
			if (Common.isNotNull(library.getUnitBigmailmentMoney())) {
				socialParam.setFd_3af9ee3ba76f54(library.getUnitBigmailmentMoney().toString());
			} else {
				socialParam.setFd_3af9ee3ba76f54(CommonConstants.EMPTY_STRING);
			}
			//实缴单位工伤
			if (Common.isNotNull(library.getUnitInjuryMoney())) {
				socialParam.setFd_3af9ee3aa9c84a(library.getUnitInjuryMoney().toString());
			} else {
				socialParam.setFd_3af9ee3aa9c84a(CommonConstants.EMPTY_STRING);
			}
			//实缴合计
			if (Common.isNotNull(library.getSocialSum())) {
				socialParam.setFd_3af9ee3c6bfc74(library.getSocialSum().toString());
			} else {
				socialParam.setFd_3af9ee3c6bfc74(CommonConstants.EMPTY_STRING);
			}
			//实缴个人医疗
			if (Common.isNotNull(library.getPersonalMedicalMoney())) {
				socialParam.setFd_3af9ee3e066d48(library.getPersonalMedicalMoney().toString());
			} else {
				socialParam.setFd_3af9ee3e066d48(CommonConstants.EMPTY_STRING);
			}
			//实缴单位失业
			if (Common.isNotNull(library.getUnitUnemploymentMoney())) {
				socialParam.setFd_3af9ee3a46b7e6(library.getUnitUnemploymentMoney().toString());
			} else {
				socialParam.setFd_3af9ee3a46b7e6(CommonConstants.EMPTY_STRING);
			}
			//实缴个人养老
			if (Common.isNotNull(library.getPersonalPensionMoney())) {
				socialParam.setFd_3af9ee3e513962(library.getPersonalPensionMoney().toString());
			} else {
				socialParam.setFd_3af9ee3e513962(CommonConstants.EMPTY_STRING);
			}
			//实缴个人大病救助
			if (Common.isNotNull(library.getPersonalBigmailmentMoney())) {
				socialParam.setFd_3af9ee3d0ba3b6(library.getPersonalBigmailmentMoney().toString());
			} else {
				socialParam.setFd_3af9ee3d0ba3b6(CommonConstants.EMPTY_STRING);
			}
			//我司到款单位
			socialParam.setFd_3b01953871b8be(CommonConstants.EMPTY_STRING);
			//社保id
			socialParam.setFd_3b0afbe1f94a08(library.getId());

			String body = ekpSocialUtil.sendToEKP(socialParam);
			if (Common.isNotNull(body) && body.length() == 32) {
				//更新推送状态为已推送的列表
				pushList.add(library.getId());
				if (pushList.size() >= CommonConstants.FIVES_INT) {
					baseMapper.updatePushStatus(pushList);
					pushList.clear();
				}
			} else {
				if (map.get(body) > 0) {
					int i = map.get(body) + 1;
					idMap.put(body, library.getId());
					map.put(body, i);
					//单个异常超过十次，保存异常内容
					if (i >= 10) {
						baseMapper.updatePushStatus(pushList);
						for (Map.Entry<String, Integer> entry : map.entrySet()) {
							TSendEkpError error = new TSendEkpError();
							error.setCreateTime(new Date());
							error.setCreateDay(DateUtil.getThisDay());
							error.setType(CommonConstants.THREE_STRING);
							error.setLinkId(library.getId());
							error.setTitle(entry.getKey());
							error.setNums(entry.getValue());
							tSendEkpErrorService.save(error);
						}
						break;
					}
				} else {
					map.put(body, 1);
					idMap.put(body, library.getId());
				}
			}
		}
		for (Map.Entry<String,Integer> entry : map.entrySet()) {
			TSendEkpError error = new TSendEkpError();
			error.setCreateTime(new Date());
			error.setCreateDay(DateUtil.getThisDay());
			error.setType(CommonConstants.THREE_STRING);
			error.setLinkId(idMap.get(entry.getKey()));
			error.setTitle(entry.getKey());
			error.setNums(entry.getValue());
			tSendEkpErrorService.save(error);
		}
		//更新推送状态
		if (Common.isNotNull(pushList)) {
			baseMapper.updatePushStatus(pushList);
		}
	}

	public void initEkpPushFundParam(List<TPaymentInfo> unPushInfo) {
		List<String> pushList = new ArrayList<>();
		Map<String, Integer> map = new HashMap<>();
		Map<String, String> idMap = new HashMap<>();
		List<TSettleDomainSelectVo> settleDomainR;
		R<TSettleDomainListVo> listVo;
		for (TPaymentInfo library : unPushInfo) {
			//获取项目信息
			TSettleDomain settleDomain = new TSettleDomain();
			listVo = archivesDaprUtil.selectSettleDomainSelectVoById(library.getSettleDomainId());
			if (Common.isNotNull(listVo)) {
				TSettleDomainListVo tSettleDomainListVo = listVo.getData();
				if (Common.isNotNull(tSettleDomainListVo) && Common.isNotEmpty(tSettleDomainListVo.getListSelectVO())) {
					settleDomainR = tSettleDomainListVo.getListSelectVO();
					for (TSettleDomainSelectVo vo : settleDomainR) {
						BeanUtils.copyProperties(vo, settleDomain);
					}
				}
			}
			EkpPushFundParam fundParam = new EkpPushFundParam();
			//员工姓名
			fundParam.setFd_3adfe8c79989d4(library.getEmpName());
			//员工身份证
			fundParam.setFd_3adfe8c7e4cf7a(library.getEmpIdcard());
			//预估单位代缴
			fundParam.setFd_3adfeb4e8064a8(CommonConstants.EMPTY_STRING);
			//预估个人代缴
			fundParam.setFd_3adfeb52a4d2e2(CommonConstants.EMPTY_STRING);
			//缴纳月份
			if (Common.isNotNull(library.getProvidentPayMonth())) {
				fundParam.setFd_3adfe8cf632700(dateStringInsert(library.getProvidentPayMonth()));
			} else {
				fundParam.setFd_3adfe8cf632700(CommonConstants.EMPTY_STRING);
			}
			//生成月份
			if (Common.isNotNull(library.getProvidentCreateMonth())) {
				fundParam.setFd_3adfe8cb96c41e(dateStringInsert(library.getProvidentCreateMonth()));
			} else {
				fundParam.setFd_3adfe8cb96c41e(CommonConstants.EMPTY_STRING);
			}
			//结算状态
			// hgw2022-9-30 12:03:48根绝倩倩需求变更
			fundParam.setFd_3add9ea428879a(CommonConstants.SALARY_UNFLAG);
			//订单类型
			fundParam.setFd_3add9dd7833db8(SocialConstants.DIFF_TYPE_THR);
			//是否有预估
			if (Common.isNotNull(settleDomain.getFundType()) &&
					CommonConstants.ONE_STRING.equals(settleDomain.getFundType())) {
				fundParam.setFd_3add9de0be85e4(CommonConstants.IS_TRUE);
			} else {
				fundParam.setFd_3add9de0be85e4(CommonConstants.IS_FALSE);
			}
			//与工资合并结算
			fundParam.setFd_3add9e1a670144(CommonConstants.IS_FALSE);
			//项目编码
			fundParam.setFd_3adfe8c70d3fd4(library.getSettleDomainCode());
			//项目名称
			fundParam.setFd_3adfe8c8468e54(library.getSettleDomainName());
			//单号
			fundParam.setFd_3adfe95c169c48(CommonConstants.EMPTY_STRING);
			//客户编码
			if (Common.isNotNull(settleDomain.getCustomerNo())) {
				fundParam.setFd_3adfe8c73cb5a4(settleDomain.getCustomerNo());
			} else {
				fundParam.setFd_3adfe8c73cb5a4(CommonConstants.EMPTY_STRING);
			}
			//是否为BPO业务
			if (Common.isNotNull(settleDomain.getBpoFlag())) {
				fundParam.setFd_3b178ea361cabe(settleDomain.getBpoFlag());
			} else {
				fundParam.setFd_3b178ea361cabe(CommonConstants.EMPTY_STRING);
			}
			//单位代缴
			if (Common.isNotNull(library.getUnitProvidentSum())) {
				fundParam.setFd_3adfeb52fbe966(library.getUnitProvidentSum().toString());
			} else {
				fundParam.setFd_3adfeb52fbe966(CommonConstants.EMPTY_STRING);
			}
			//个人代缴
			if (Common.isNotNull(library.getPersonalProvidentSum())) {
				fundParam.setFd_3adfeb5366dd82(library.getPersonalProvidentSum().toString());
			} else {
				fundParam.setFd_3adfeb5366dd82(CommonConstants.EMPTY_STRING);
			}
			//客户名称
			fundParam.setFd_3adfe8c81a0e42(library.getUnitName());
			//公积金账户
			if (Common.isNotNull(library.getProvidentHousehold())) {
				fundParam.setFd_3aeafa8cc144bc(library.getProvidentHousehold());
			} else {
				fundParam.setFd_3aeafa8cc144bc(CommonConstants.EMPTY_STRING);
			}
			//结算月份
			fundParam.setFd_3adfe8cff746bc(CommonConstants.EMPTY_STRING);
			//单位差异
			fundParam.setFd_3adfeb53c70f72(CommonConstants.EMPTY_STRING);
			//个人差异
			fundParam.setFd_3adfeb5413fb44(CommonConstants.EMPTY_STRING);
			//应收
			fundParam.setFd_3adfeb7b624f06(CommonConstants.EMPTY_STRING);
			//收款状态
			fundParam.setFd_3add9eaeed2560(CommonConstants.EMPTY_STRING);
			//结算单号
			fundParam.setFd_3adfeb830523b6(CommonConstants.EMPTY_STRING);
			//收款单号
			fundParam.setFd_3adfeb8489e6c2(CommonConstants.EMPTY_STRING);
			//应支出
			fundParam.setFd_3adfeb7bd97464(CommonConstants.EMPTY_STRING);
			//支出结算状态
			fundParam.setFd_3add9edfbc6f7e(CommonConstants.EMPTY_STRING);
			//付款状态
			fundParam.setFd_3add9eed23894a(CommonConstants.EMPTY_STRING);
			//支出缴纳单号
			fundParam.setFd_3adfeb83a704c8(CommonConstants.EMPTY_STRING);
			//付款单号
			fundParam.setFd_3adfeb84175f28(CommonConstants.EMPTY_STRING);
			//我司到款单位
			fundParam.setFd_3b019a2e9bfdd6(CommonConstants.EMPTY_STRING);
			//公积金id
			fundParam.setFd_3b0afbaf10df2c(library.getId());

			String body = ekpFundUtil.sendToEKP(fundParam);
			if (Common.isNotNull(body) && body.length() == 32) {
				//更新推送状态为已推送的列表
				pushList.add(library.getId());
				if (pushList.size() >= CommonConstants.FIVES_INT) {
					baseMapper.updatePushStatus(pushList);
					pushList.clear();
				}
			} else {
				if (map.get(body) > 0) {
					int i = map.get(body) + 1;
					map.put(body, i);
					idMap.put(body, library.getId());
					//单个异常超过十次，保存异常内容
					if (i >= 10) {
						baseMapper.updatePushStatus(pushList);
						for (Map.Entry<String, Integer> entry : map.entrySet()) {
							TSendEkpError error = new TSendEkpError();
							error.setCreateTime(new Date());
							error.setCreateDay(DateUtil.getThisDay());
							error.setType(CommonConstants.THREE_STRING);
							error.setLinkId(library.getId());
							error.setTitle(entry.getKey());
							error.setNums(entry.getValue());
							tSendEkpErrorService.save(error);
						}
						break;
					}
				} else {
					map.put(body, 1);
					idMap.put(body, library.getId());
				}
			}
		}
		for (Map.Entry<String,Integer> entry : map.entrySet()) {
			TSendEkpError error = new TSendEkpError();
			error.setCreateTime(new Date());
			error.setCreateDay(DateUtil.getThisDay());
			error.setType(CommonConstants.THREE_STRING);
			error.setLinkId(idMap.get(entry.getKey()));
			error.setTitle(entry.getKey());
			error.setNums(entry.getValue());
			tSendEkpErrorService.save(error);
		}
		//更新推送状态
		if (Common.isNotNull(pushList)) {
			baseMapper.updatePushStatus(pushList);
		}
	}

	public void createIncomeInfo(List<TPaymentInfo> updateList, String socialFundFlag) {
		List<TIncomeDetail> detailList = new ArrayList<>();
		for (TPaymentInfo paymentInfo : updateList) {
			boolean exitFlag = false;
			List<TIncomeDetail> exitIncome;
			if (CommonConstants.ONE_STRING.equals(socialFundFlag)) {
				exitIncome = detailMapper.selectList(Wrappers.<TIncomeDetail>query().lambda()
						.eq(TIncomeDetail::getEmpIdcard, paymentInfo.getEmpIdcard())
						.eq(TIncomeDetail::getPayMonth, paymentInfo.getSocialPayMonth())
						.eq(TIncomeDetail::getDeptId, paymentInfo.getSettleDomainId())
						.eq(TIncomeDetail::getSourceType, CommonConstants.ONE_STRING));
			} else {
				exitIncome = detailMapper.selectList(Wrappers.<TIncomeDetail>query().lambda()
						.eq(TIncomeDetail::getEmpIdcard, paymentInfo.getEmpIdcard())
						.eq(TIncomeDetail::getPayMonth, paymentInfo.getProvidentPayMonth())
						.eq(TIncomeDetail::getDeptId, paymentInfo.getSettleDomainId())
						.eq(TIncomeDetail::getSourceType, CommonConstants.TWO_STRING));
			}
			if (Common.isNotNull(exitIncome)) {
				BigDecimal sumMoney = BigDecimal.ZERO;
				for (TIncomeDetail income : exitIncome) {
					sumMoney = BigDecimalUtils.safeAdd(income.getMoney(), sumMoney);
					if (paymentInfo.getId().equals(income.getSourceId())) {
						exitFlag = true;
					}
				}
				if (exitFlag) {
					continue;
				}
				if (sumMoney.compareTo(BigDecimal.ZERO) > 0) {
					exitFlag = true;
				}
			}

			//获取项目信息
			TSettleDomain settleDomain = new TSettleDomain();
			List<TSettleDomainSelectVo> settleDomainR;
			R<TSettleDomainListVo> listVo;
			listVo = archivesDaprUtil.selectSettleDomainSelectVoById(paymentInfo.getSettleDomainId());
			if (Common.isNotNull(listVo)) {
				TSettleDomainListVo tSettleDomainListVo = listVo.getData();
				if (Common.isNotNull(tSettleDomainListVo) && Common.isNotEmpty(tSettleDomainListVo.getListSelectVO())) {
					settleDomainR = tSettleDomainListVo.getListSelectVO();
					for (TSettleDomainSelectVo vo : settleDomainR) {
						BeanUtils.copyProperties(vo, settleDomain);
					}
				}
			}

			int isSum = 0;
			if (Common.isNotNull(settleDomain)) {
				// 含有社保，则计算收入
				if (Common.isNotNull(settleDomain.getManageServerItem()) && ((settleDomain.getManageServerItem().contains(CommonConstants.ONE_STRING)
						&& CommonConstants.ONE_STRING.equals(socialFundFlag)) || (settleDomain.getManageServerItem().contains(CommonConstants.TWO_STRING)
						&& CommonConstants.TWO_STRING.equals(socialFundFlag))) && CommonConstants.ZERO_STRING.equals(settleDomain.getManagementTag())) {
					//预估模式
					if (CommonConstants.ONE_STRING.equals(settleDomain.getMrSettleType())) {
						//预估模式只有按人次和人数收费
						if (!exitFlag) {
							createIncomeInsurance(paymentInfo, settleDomain, CommonConstants.ONE_STRING,
									settleDomain.getManagementFee().toString(), settleDomain.getManagementType(),
									settleDomain.getManagementFee(), socialFundFlag, detailList);
						}
					} else {
						BigDecimal gMoney;
						if (CommonConstants.TWO_STRING.equals(settleDomain.getManagementType())) {
							gMoney = settleDomain.getManagementFee();
						} else if (CommonConstants.THREE_STRING.equals(settleDomain.getManagementType())) {
							gMoney = settleDomain.getManagementFee();
						} else {
							isSum = 1;
							if (CommonConstants.ONE_STRING.equals(socialFundFlag)) {
								gMoney = BigDecimalUtils.safeMultiply(paymentInfo.getSocialSum(),
										settleDomain.getManagementFee().divide(new BigDecimal("100"),
												CommonConstants.FIVE_INT, RoundingMode.HALF_UP));
							} else {
								gMoney = BigDecimalUtils.safeMultiply(paymentInfo.getProvidentSum(),
										settleDomain.getManagementFee().divide(new BigDecimal("100"),
												CommonConstants.FIVE_INT, RoundingMode.HALF_UP));
							}
						}
						if (!exitFlag || isSum == 1) {
							createIncomeInsurance(paymentInfo, settleDomain, CommonConstants.ONE_STRING,
									settleDomain.getManagementFee().toString(), settleDomain.getManagementType(),
									gMoney, socialFundFlag, detailList);
						}
					}
				}
				if (Common.isNotNull(settleDomain.getRiskServerItem()) && ((settleDomain.getRiskServerItem().contains(CommonConstants.ONE_STRING)
						&& CommonConstants.ONE_STRING.equals(socialFundFlag)) || (settleDomain.getRiskServerItem().contains(CommonConstants.TWO_STRING)
						&& CommonConstants.TWO_STRING.equals(socialFundFlag))) && CommonConstants.ZERO_STRING.equals(settleDomain.getRiskFundTag())) {
					//预估模式
					if (CommonConstants.ONE_STRING.equals(settleDomain.getMrSettleType())) {
						if (!exitFlag) {
							createIncomeInsurance(paymentInfo, settleDomain, CommonConstants.TWO_STRING,
									settleDomain.getRiskFundFee().toString(), settleDomain.getRiskFundType(),
									settleDomain.getRiskFundFee(), socialFundFlag, detailList);
						}
					} else {
						if (CommonConstants.ZERO_STRING.equals(settleDomain.getRiskFundTag())) {
							BigDecimal money;
							if (CommonConstants.TWO_STRING.equals(settleDomain.getRiskFundType())) {
								money = settleDomain.getRiskFundFee();
							} else if (CommonConstants.THREE_STRING.equals(settleDomain.getRiskFundType())) {
								money = settleDomain.getRiskFundFee();
							} else {
								isSum = 2;
								if (CommonConstants.ONE_STRING.equals(socialFundFlag)) {
									money = BigDecimalUtils.safeMultiply(paymentInfo.getSocialSum(),
											settleDomain.getRiskFundFee().divide(new BigDecimal("100"),
													CommonConstants.FIVE_INT, RoundingMode.HALF_UP));
								} else {
									money = BigDecimalUtils.safeMultiply(paymentInfo.getProvidentSum(),
											settleDomain.getRiskFundFee().divide(new BigDecimal("100"),
													CommonConstants.FIVE_INT, RoundingMode.HALF_UP));
								}
							}
							if (!exitFlag || isSum == 2) {
								createIncomeInsurance(paymentInfo, settleDomain, CommonConstants.TWO_STRING,
										settleDomain.getRiskFundFee().toString(), settleDomain.getRiskFundType(),
										money, socialFundFlag, detailList);
							}
						}
					}
				}
			}
		}
		incomeService.saveBathDetail(detailList);
	}

	public void createIncomeInsurance(TPaymentInfo library, TSettleDomain settleDomain, String feeType,
									  String charges, String feeMode, BigDecimal money, String sourceType,
									  List<TIncomeDetail> detailList) {
		//生成收入数据
		TIncomeDetail detail = new TIncomeDetail();
		detail.setCreateTime(DateUtil.getCurrentDateTime());
		detail.setDeptName(settleDomain.getDepartName());
		detail.setDeptNo(settleDomain.getDepartNo());
		detail.setDeptId(settleDomain.getId());
		detail.setEmpIdcard(library.getEmpIdcard());
		detail.setEmpName(library.getEmpName());
		detail.setUnitNo(settleDomain.getCustomerNo());
		detail.setUnitId(settleDomain.getCustomerId());
		detail.setUnitName(settleDomain.getCustomerName());
		detail.setDataCreateMonth(DateUtil.addMonth(0));
		detail.setSourceId(library.getId());
		detail.setSourceType(sourceType);
		if (CommonConstants.ONE_STRING.equals(sourceType)) {
			detail.setCreateMonth(library.getSocialCreateMonth());
			detail.setPayMonth(library.getSocialPayMonth());
		} else {
			detail.setCreateMonth(library.getProvidentCreateMonth());
			detail.setPayMonth(library.getProvidentPayMonth());
		}
		detail.setMoney(money);
		detail.setFeeType(feeType);
		detail.setFeeMode(feeMode);
		detail.setCharges(charges);
		detail.setMrSettleType(settleDomain.getMrSettleType());
		detail.setId(CommonConstants.NULL);
		detail.setRedData(CommonConstants.ZERO_STRING);
		detailList.add(detail);
	}

	public String dateStringInsert(String month) {
		StringBuilder sb = new StringBuilder(month);
		sb.insert(4, "-");
		return sb.toString();
	}
}
