/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialfundHouseRes;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TSocialfundHouseResMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.TSocialfundHouseResService;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 社保公积金户权限配置表
 *
 * @author huyc
 * @date 2022-11-02 09:13:07
 */
@Log4j2
@Service
public class TSocialfundHouseResServiceImpl extends ServiceImpl<TSocialfundHouseResMapper, TSocialfundHouseRes> implements TSocialfundHouseResService {
    /**
     * 社保公积金户权限配置表简单分页查询
     * @param tSocialfundHouseRes 社保公积金户权限配置表
     * @return
     */
    @Override
    public IPage<TSocialfundHouseRes> getTSocialfundHouseResPage(Page<TSocialfundHouseRes> page, TSocialfundHouseRes tSocialfundHouseRes){
        return baseMapper.getTSocialfundHouseResPage(page,tSocialfundHouseRes);
    }
	/**
     * 社保公积金户权限配置表批量导出
     * @param searchVo 社保公积金户权限配置表
     * @return
     */
    @Override
    public List<TSocialfundHouseRes> getexportList(TSocialfundHouseRes searchVo) {
		if (!Common.isNotNull(searchVo.getHouseNameType())) {
			searchVo.setAuthType(CommonConstants.ZERO_STRING);
		} else if (CommonConstants.ZERO_STRING.equals(searchVo.getHouseNameType())){
			searchVo.setAuthType(CommonConstants.ONE_STRING);
		}
        return baseMapper.getexportList(searchVo);
    }

	@Override
	public R saveSocialAuth(TSocialfundHouseRes searchVo) {
		LambdaQueryWrapper<TSocialfundHouseRes> wrapper = new LambdaQueryWrapper<>();
		if (Common.isNotNull(searchVo.getSocialHousehold())) {
			wrapper.eq(TSocialfundHouseRes::getSocialHousehold, searchVo.getSocialHousehold());
		}
		if (Common.isNotNull(searchVo.getFundHousehold())){
			wrapper.eq(TSocialfundHouseRes::getFundHousehold,searchVo.getFundHousehold());
		}
		if (Common.isNotNull(searchVo.getUserId())){
			wrapper.eq(TSocialfundHouseRes::getUserId,searchVo.getUserId());
		}
		if (Common.isNotNull(searchVo.getAuthType())){
			wrapper.eq(TSocialfundHouseRes::getAuthType,searchVo.getAuthType());
		}
		TSocialfundHouseRes socialfundHouseRes = baseMapper.selectOne(wrapper);
		if (Common.isNotNull(socialfundHouseRes)) {
			String errorMessage;
			if (CommonConstants.ZERO_STRING.equals(searchVo.getAuthType())) {
				errorMessage = "请勿重复添加审核人员";
			} else {
				errorMessage = "请勿重复添加办理人员";
			}
			return R.failed(errorMessage);
		} else {
			baseMapper.insert(searchVo);
			return R.ok();
		}
	}
}
