/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDict;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 字典表 Mapper 接口
 * </p>
 *
 * @author lengleng
 * @since 2017-11-19
 */
@Mapper
public interface SysDictMapper extends BaseMapper<SysDict> {
	/**
	 * @Author fxj
	 * @Description 获取字典类型及字典项值的父级字典项名称
	 * @Date 10:22 2022/6/21
	**/
	String getParentDicLabelById(@Param("type")String type,@Param("value")String value);
	/**
	 * @Author fxj
	 * @Description 获取type 对应的子字典项数目
	 * @Date 10:21 2022/6/21
	**/
	int  selectChildDictItemCount(@Param("parentItemType")String parentItemType, @Param("parentId")String parentId);
}
