/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.yifu.cloud.plus.v1.yifu.admin.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysArea;
import com.yifu.cloud.plus.v1.yifu.admin.mapper.SysAreaMapper;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysAreaService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 字典项
 *
 * @author hgw
 * @date 2022-6-22 19:40:43
 */
@Service
public class SysAreaServiceImpl extends ServiceImpl<SysAreaMapper, SysArea> implements SysAreaService {

	@Override
	public R<Map<String, String>> getAreaToId() {
		Map<String, String> resultMap = this.getStringMapMap(true);
		return R.ok(resultMap);
	}

	@Override
	public R<Map<String, String>> getAreaToName() {
		Map<String, String> resultMap = this.getStringMapMap(false);
		return R.ok(resultMap);
	}

	@Override
	public List<SysArea> getAllArea() {
		return baseMapper.selectList(Wrappers.<SysArea>query().lambda());
	}

	private Map<String, String> getStringMapMap(boolean type) {
		List<SysArea> allList = baseMapper.selectList(Wrappers.<SysArea>query().lambda()
				.eq(SysArea::getStatus, CommonConstants.ZERO_INT));
		Map<String, String> resultMap = new HashMap<>();
		doAssemble(allList, resultMap, type);
		return resultMap;
	}

	/**
	 * @Description: 组装
	 * @Author: hgw
	 * @Date: 2022/6/22 18:12
	 * @return: void
	 **/
	private void doAssemble(List<SysArea> allList, Map<String, String> resultMap, boolean type) {
		if (Common.isNotNull(allList)) {
			for (SysArea item : allList) {
				if (type) {
					resultMap.put(String.valueOf(item.getId()), item.getAreaName());
				} else {
					resultMap.put(item.getAreaName(), String.valueOf(item.getId()));
				}
			}
		}
	}

}
