/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpContactInfo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmpContactInfoSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 
 *
 * @author fxj
 * @date 2024-06-17 14:29:11
 */
public interface TEmpContactInfoService extends IService<TEmpContactInfo> {
    /**
     * 简单分页查询
     * @param tEmpContactInfo 
     * @return
     */
    IPage<TEmpContactInfo> getTEmpContactInfoPage(Page<TEmpContactInfo> page, TEmpContactInfoSearchVo tEmpContactInfo);

    R<List<ErrorMessage>> importDiy(InputStream inputStream);

    void listExport(HttpServletResponse response, TEmpContactInfoSearchVo searchVo);

    List<TEmpContactInfo> noPageDiy(TEmpContactInfoSearchVo searchVo);
	
	/**
	 * @Description: 获取紧急联系人
	 * @Author: hgw
	 * @Date: 2024/10/17 19:40
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpContactInfo>
	 **/
	List<TEmpContactInfo> getContactByDeptId(String deptId);

	// 根据身份证获取
	List<TEmpContactInfo> getContactByIdCardList(List<String> idList);

	TEmpContactInfo getByEmpId(String empId);
}
