package com.yifu.cloud.plus.v1.business.util;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import org.apache.commons.lang.StringUtils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

/**
 * @description: hro b端通用方法
 * @author: wangweiguo
 * @date: 2021/8/16
 */
public class BusinessCommonUtils {

    /**
     * 格式化标签id
     *
     * @param employeeTags 标签字符串，英文逗号分割
     * @return: java.lang.String
     * @author: wangweiguo
     * @date: 2021/8/19
     */
    public static String formatLabelId(String employeeTags) {
        // 标签id格式化处理
        String[] tags = StringUtils.split(employeeTags, ",");
        List<String> tagList = new ArrayList<>();
        if (null != tags) {
            for (String tag : tags) {
                tagList.add(String.format(CommonConstants.TAG_FROMAT, Integer.valueOf(tag)));
            }
        }
        return StringUtils.join(tagList, ",");
    }

    /**
     * 根据当前月份获取上个月份
     *
     * @param curMonth 当前月份，格式yyyyMM
     * @return String lastMonth 返回上个月份的字符串格式yyyyMM
     * @author: wangweiguo
     * @date: 2021-09-06
     */
    public static String getLastMonthByCurMonth(String curMonth) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        LocalDate lastSalaryDate = LocalDate.parse(curMonth + "01", dateTimeFormatter).plusMonths(-1L);
        return String.format(lastSalaryDate.getYear() + "%02d", lastSalaryDate.getMonthValue());
    }

}
