package com.yifu.cloud.plus.v1.job.service.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.job.entity.SysScheduleJob;
import com.yifu.cloud.plus.v1.job.mapper.SysScheduleJobMapper;
import com.yifu.cloud.plus.v1.job.service.SysScheduleJobService;
import com.yifu.cloud.plus.v1.job.util.ScheduleStatus;
import com.yifu.cloud.plus.v1.job.util.ScheduleUtils;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.Date;
import java.util.List;

/**
 * @Author fxj
 * @Description 
 * @Date 11:37 2022/6/15
 * @Param 
 * @return 
**/
@Service
public class SysScheduleJobServiceImpl extends ServiceImpl<SysScheduleJobMapper, SysScheduleJob> implements SysScheduleJobService {

    @Autowired
    private Scheduler scheduler;

    /**
     * 项目启动时，初始化定时器
     */
    @PostConstruct
    public void init() {
        List<SysScheduleJob> scheduleJobList = this.list(new QueryWrapper<>());
        for (SysScheduleJob scheduleJob : scheduleJobList) {
            CronTrigger cronTrigger = ScheduleUtils.getCronTrigger(scheduler, scheduleJob.getJobId());
            //如果不存在，则创建
            if (cronTrigger == null) {
                ScheduleUtils.createScheduleJob(scheduler, scheduleJob);
            } else {
                ScheduleUtils.updateScheduleJob(scheduler, scheduleJob);
            }
        }
    }

    /**
     * 简单分页查询
     *
     * @param sysScheduleJob
     * @return
     */
    @Override
    public IPage<SysScheduleJob> getSysScheduleJobPage(Page<SysScheduleJob> page, SysScheduleJob sysScheduleJob) {
        return baseMapper.getSysScheduleJobPage(page, sysScheduleJob);
    }

    /**
     * @Author fxj
     * @Description  运行定时任务
     * @Date 11:37 2022/6/15
     * @Param
     * @return
    **/
    @Override
    public void run(String[] jobIds) {
        for (String jobId : jobIds) {
            SysScheduleJob scheduleJob = new SysScheduleJob();
            scheduleJob.setJobId(jobId);
            QueryWrapper<SysScheduleJob> queryWrapper = new QueryWrapper<>();
            queryWrapper.setEntity(scheduleJob);
            scheduleJob = this.getOne(queryWrapper);
            scheduleJob.setStatus(String.valueOf(ScheduleStatus.NORMAL.getValue()));
            this.updateById(scheduleJob);
            ScheduleUtils.run(scheduler, scheduleJob);
        }
    }

    /**
     * @param jobIds
     * @Author: wangan
     * @Date: 2019/8/12
     * @Description: 暂停定时任务
     * @return: void
     **/
    @Override
    public void pause(String[] jobIds) {
        for (String jobId : jobIds) {
            ScheduleUtils.pauseJob(scheduler, jobId);
        }
        updateBatch(jobIds, ScheduleStatus.PAUSE.getValue());
    }

    /**
     * @param jobIds
     * @Author: wangan
     * @Date: 2019/8/12
     * @Description: 恢复定时任务
     * @return: void
     **/
    @Override
    public void resume(String[] jobIds) {
        for (String jobId : jobIds) {
            ScheduleUtils.resumeJob(scheduler, jobId);
        }
        updateBatch(jobIds, ScheduleStatus.NORMAL.getValue());
    }

    private void updateBatch(String[] jobIds, int value) {
        for (String jobId : jobIds) {
            SysScheduleJob scheduleJob = new SysScheduleJob();
            scheduleJob.setJobId(jobId);
            QueryWrapper<SysScheduleJob> queryWrapper = new QueryWrapper<>();
            queryWrapper.setEntity(scheduleJob);
            scheduleJob = this.getOne(queryWrapper);
            scheduleJob.setStatus(String.valueOf(value));
            this.updateById(scheduleJob);
            updateSysScheduleJob(jobId, value);
        }
    }

    /**
     * @param scheduleJob
     * @Author: wangan
     * @Date: 2019/8/12
     * @Description: 新建定时任务
     * @return: void
     **/
    public void saveSysScheduleJob(SysScheduleJob scheduleJob) {
        scheduleJob.setCreatetime(DateUtil.format(new Date(), DatePattern.NORM_DATETIME_MS_PATTERN));
        scheduleJob.setStatus(String.valueOf(ScheduleStatus.NORMAL.getValue()));
        this.save(scheduleJob);
        ScheduleUtils.createScheduleJob(scheduler, scheduleJob);
    }

    /**
     * @param scheduleJob
     * @Author: wangan
     * @Date: 2019/8/12
     * @Description: 更新定时任务
     * @return: void
     **/
    public void updateSysScheduleJob(SysScheduleJob scheduleJob) {
        ScheduleUtils.updateScheduleJob(scheduler, scheduleJob);
        QueryWrapper<SysScheduleJob> wrapper = new QueryWrapper<SysScheduleJob>();
        wrapper.eq("ID", scheduleJob.getId());
        this.updateById(scheduleJob);
    }

    /**
     * @param jobIds
     * @Author: wangan
     * @Date: 2019/8/12
     * @Description: 删除定时任务
     * @return: void
     **/
    public void deleteSysScheduleJob(String jobIds) {
        ScheduleUtils.deleteScheduleJob(scheduler, jobIds);
        QueryWrapper<SysScheduleJob> wrapper = new QueryWrapper<SysScheduleJob>();
        wrapper.eq("JOB_ID", jobIds);
        this.remove(wrapper);
    }

    public int updateSysScheduleJob(String jobIds, int status) {
        SysScheduleJob scheduleJob = new SysScheduleJob();
        scheduleJob.setJobId(jobIds);
        QueryWrapper<SysScheduleJob> queryWrapper = new QueryWrapper<SysScheduleJob>();
        queryWrapper.setEntity(scheduleJob);
        scheduleJob = this.getOne(queryWrapper);
        scheduleJob.setStatus(String.valueOf(status));
        this.updateById(scheduleJob);
        ScheduleUtils.updateScheduleJob(scheduler, scheduleJob);
        return 0;
    }

}
