package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author wangweiguo
 * @Description BusinessEmployeeExtendVO
 * @Date 21:15 2021/8/17
 **/
@Getter
@Setter
@ToString
public class BusinessEmployeeExtendVO implements Serializable {

    /**
     * 主键
     */
    private String id;

    /**
     * 员工姓名
     */
    private String empName;
    /**
     * 身份证号码
     */
    private String empIdcard;

    /**
     * 部门名称
     */
    private String departName;

    /**
     * 部门id
     */
    private Integer departId;


    /**
     * 部门编码 对应部门实体中的TreeLogo
     */
    private String departCode;

    /**
     * b端岗位
     */
    private String businessPost;

    /**
     * b端员工工号
     */
    private String businessTelecomNumber;

    /**
     * 标签，字典值（英文逗号分割）
     */
    private String employeeTags;

    /**
     * 第一学历和专业
     */
    private String firstDegreeAndMajor;

    /**
     * 第一学历院校
     */
    private String firstDegreeGraduateSchool;

    /**
     * 最高学历和专业
     */
    private String highestDegreeAndMajor;

    /**
     * 最高学历院校
     */
    private String highestDegreeGraduateSchool;

    /**
     * 联系方式
     */
    private String contactInfo;

    /**
     * 档案所在地
     */
    private String archivesAddr;

    /**
     * 0在职 1离职 3 临时
     */
    private String businessWorkingStatus;


    /**
     * B端维护的离职时间
     */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	private LocalDateTime businessLeaveDate;

    /**
     * B端维护的入职时间
     */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime businessEnjoinDate;

    /**
     * B端维护的离职原因
     */
    private String businessLeaveReason;

    /**
     * 0未删除 1已删除
     */
    @TableLogic
    private String deleteFlag;

    /**
     * 证件类型
     */
    private String documentType;
}
