package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TMinSalary;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.Set;

/**
 * @author wzb
 * @description 导出列表
 * @date 2023-05-05 11:41:21
 */

@Data
public class TMinSalaryExportVo  {

	private static final long serialVersionUID = 1L;


	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "id")
	private String id;
	/**
	 * 省
	 */
	@ExcelAttribute(name = "省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "省")
	private Integer province;
	/**
	 * 市
	 */
	@ExcelAttribute(name = "市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "市")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer city;
	/**
	 * 县
	 */
	@ExcelAttribute(name = "县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "县")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer town;
	/**
	 * 最低工资标准
	 */
	@NotBlank(message = "最低工资标准不能为空")
	@Length(max = 11, message = "最低工资标准不能超过11个字符")
	@ExcelAttribute(name = "最低工资标准", isNotEmpty = true, errorInfo = "最低工资标准不能为空", maxLength = 11)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "最低工资标准")
	private String salaryBase;
	/**
	 * 1.启用 2.停用
	 */
	@NotNull(message = "1.启用 2.停用不能为空")
	@ExcelAttribute(name = "1.启用 2.停用", isNotEmpty = true, errorInfo = "1.启用 2.停用不能为空" ,readConverterExp = "1=启用,1=派遣,2=停用不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "1.启用 2.停用")
	private Integer status;




}
