package com.yifu.cloud.plus.v1.csp.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 入离职登记表
 *
 * @author huych
 * @date 2025-02-25 14:48:11
 */
@Data
public class EmployeeRegistrationVo extends RowIndex implements Serializable {

	/**
	 * 员工姓名
	 */
	@NotBlank(message = "员工姓名 不能为空")
	@Length(max = 20, message = "员工姓名 不能超过20个字符")
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, errorInfo = "员工姓名不能为空", maxLength = 20)
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String employeeName;

	/**
	 * 身份证号
	 */
	@NotBlank(message = "身份证号不能为空")
	@Length(max = 18, message = "身份证号不能超过18个字符")
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, errorInfo = "身份证号不能为空", maxLength = 18)
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;

	/**
	 * 员工手机号
	 */
	@NotBlank(message = "员工手机号 不能为空")
	@Length(max = 11, message = "员工手机号不能超过11个字符")
	@ExcelAttribute(name = "员工手机号", isNotEmpty = true, errorInfo = "员工手机号不能为空", maxLength = 11)
	@Schema(description = "员工手机号")
	@ExcelProperty("员工手机号")
	private String empPhone;

	/**
	 * 岗位
	 */
	@Length(max = 50, message = "岗位不能超过50个字符")
	@NotBlank(message = "岗位不能为空")
	@ExcelAttribute(name = "岗位", maxLength = 50, isNotEmpty = true, errorInfo = "岗位不能为空")
	@Schema(description = "岗位")
	@ExcelProperty("岗位")
	private String position;

	/**
	 * 反馈类型 1入职 2离职
	 */
	@NotBlank(message = "登记类型不能为空")
	@ExcelAttribute(name = "登记类型", readConverterExp = "1=入职,2=离职", isNotEmpty = true, errorInfo = "登记类型不能为空")
	@Schema(description = "登记类型")
	@ExcelProperty("登记类型")
	private String feedbackType;

	/**
	 * 入/离职日期
	 */
	@NotBlank(message = "入/离职日期不能为空")
	@ExcelAttribute(name = "入/离职日期", isNotEmpty = true, errorInfo = "入/离职日期不能为空", isDate = true)
	@Schema(description = "入/离职日期")
	@ExcelProperty("入/离职日期")
	private Date joinLeaveDate;


}
