package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSpecialDeducationSum;

import java.util.List;
import java.util.Map;

/**
 * @Author fxj
 * @Description 专项扣除
 * @Date 13:14 2022/8/6
 * @Param
 * @return
**/
public interface TSpecialDeducationSumService extends IService<TSpecialDeducationSum> {

     /**
      * 简单分页查询
      *
      * @param tSpecialDeducationSum
      * @return
      */
     IPage<TSpecialDeducationSum> getTSpecialDeducationSumPage(Page<TSpecialDeducationSum> page, TSpecialDeducationSum tSpecialDeducationSum);

     /**
      * @param tSpecialDeducationSum
      * @Description: 查找专项信息
      * @Author: hgw
      * @Date: 2019/9/30 16:19
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSpecialDeducationSum>
      **/
     List<TSpecialDeducationSum> getTSpecialDeducationSumList(TSpecialDeducationSum tSpecialDeducationSum);

     /**
      * @param yearMonth    年月
      * @param idNumber     身份证
      * @param invoiceTitle 封面抬头
      * @Description:
      * @Author: hgw
      * @Date: 2019/9/30 17:23
      * @return: com.yifu.cloud.v1.hrms.api.entity.TSpecialDeducationSum
      **/
     TSpecialDeducationSum getTSpecialDeducationSum(String yearMonth, String idNumber, String invoiceTitle);

     /**
      * @param yearMonth    年月
      * @param idCardList     身份证
      * @Description: 工资查询所需的全部list，组装Map来使用
      * @Author: hgw
      * @Date: 2019/9/30 17:23
      * @return: com.yifu.cloud.v1.hrms.api.entity.TSpecialDeducationSum
      **/
     Map<String, TSpecialDeducationSum> getTSpecialDeducationSumMap(String yearMonth, List<String> idCardList);

     /**
      * @param yearMonth    年月
      * @param invoiceTitle 申报单位
      * @Description: 删除专项扣除
      * @Author: hgw
      * @Date: 2020/4/1 15:12
      * @return: int
      **/
     int deleteByUnitAndMonth(String yearMonth, String invoiceTitle);

     /**
      * @param sdsList
      * @Description: 保存专项
      * @Author: hgw
      * @Date: 2019/10/14 14:48
      * @return: com.yifu.cloud.v1.common.core.util.R
      **/
     R<List<ErrorMessage>> uploadSds(List<TSpecialDeducationSum> sdsList);


}
