/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.Past;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 项目档案表excel导出对应的实体
 *
 * @author huyc
 * @date 2022-06-23 10:54:40
 */
@Data
@ColumnWidth(15)
public class EmployeeProjectExportParamVO extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 档案员工类型（字典值，0外包1派遣2代理）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="档案员工类型")
	@ExcelAttribute(name = "档案员工类型",isDataId = true,dataType = ExcelAttributeConstants.EMP_NATRUE)
	private String proEmpNatrue;

	/**
	 * 员工姓名
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="员工姓名")
	private String empName;

	/**
	 * 身份证号码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="身份证号")
	private String empIdcard;

	/**
	 * 员工主码（系统自动生成：ZM+年月日+5位数字）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="员工主码")
	private String empCode;

	/**
	 * 身份证有效期起
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "身份证开始日期")
	@DateTimeFormat("yyyy-MM-dd")
	private Date validityStart;

	/**
	 * 身份证有效期止
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "身份证截止日期")
	@DateTimeFormat("yyyy-MM-dd")
	private Date validityEnd;

	/**
	 * 婚姻状况
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "婚姻状况")
	@ExcelAttribute(name = "婚姻状况", isDataId = true,dataType = ExcelAttributeConstants.EMP_MARRIED)
	private String empMarriStatus;

	/**
	 * 民族
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "民族")
	@ExcelAttribute(name = "民族", isDataId = true,dataType = ExcelAttributeConstants.EMP_NATIONAL)
	private String empNational;

	/**
	 * 政治面貌
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "政治面貌")
	@ExcelAttribute(name = "政治面貌", isDataId = true,dataType = ExcelAttributeConstants.EMP_POLITICAL)
	private String politicalStatus;

	/**
	 * 手机号码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "手机号码")
	private String empPhone;

	/**
	 * 邮箱
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "邮箱")
	private String empEmail;

	/**
	 * 身份证-省
	 */
	@ExcelAttribute(name = "户籍所在省", isArea = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "户籍所在省")
	private String idProvince;

	/**
	 * 身份证-市
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "户籍所在市")
	@ExcelAttribute(name = "户籍所在市",  isArea = true, parentField = "idProvince")
	private String idCity;

	/**
	 * 身份证-县
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "户籍所在县")
	@ExcelAttribute(name = "户籍所在县",  isArea = true, parentField = "idCity")
	private String idTown;

	/**
	 * 户口性质
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "户口性质")
	@ExcelAttribute(name = "户口性质", isDataId = true,dataType = ExcelAttributeConstants.EMP_REGISTYPE)
	private String empRegisType;

	/**
	 * 档案-省
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "档案所在省")
	@ExcelAttribute(name = "档案所在省", isArea = true)
	private String fileProvince;

	/**
	 * 档案-市
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "档案所在市")
	@ExcelAttribute(name = "档案所在市", isArea = true, parentField = "fileProvince")
	private String fileCity;

	/**
	 * 档案-县
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "档案所在县")
	@ExcelAttribute(name = "档案所在县", isArea = true, parentField = "fileCity")
	private String fileTown;

	/**
	 * 是否大专及以上（0否1是）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "是否大专及以上")
	@ExcelAttribute(name = "是否大专及以上", readConverterExp = "0=否,1=是")
	private String isCollege;

	/**
	 * 最高学历（字典值）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "最高学历")
	@ExcelAttribute(name = "最高学历", isDataId = true,dataType = ExcelAttributeConstants.EDUCATION)
	private String hignEducation;

	/**
	 * 学校
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "学校")
	private String school;

	/**
	 * 专业
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "专业")
	private String major;

	/**
	 * 入学时间
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "入学时间")
	@DateTimeFormat("yyyy-MM-dd")
	private LocalDateTime admissionDate;

	/**
	 * 毕业时间
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "毕业时间")
	@DateTimeFormat("yyyy-MM-dd")
	private LocalDateTime gradutionDate;

	/**
	 * 备注
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "档案备注")
	private String remark;

	/**
	 * 人员档案来源（字典：4人员档案新建、5项目档案新建、1社保/公积金、3商险、2薪酬）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "人员档案来源")
	@ExcelAttribute(name = "人员档案来源", readConverterExp = "1=社保公积金,2=薪酬,3=商险,4=人员档案新建")
	private String fileSource;

	/**
	 * 人员档案状态（0草稿、1已审核）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "人员档案状态")
	@ExcelAttribute(name = "人员档案状态", readConverterExp = "0=草稿,1=已审核")
	private String proStatus;

	/**
	 * 创建者-姓名
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "人员档案创建人")
	private String proCreateName;

	/**
	 * 创建时间
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "人员档案创建时间")
	@DateTimeFormat("yyyy-MM-dd")
	private LocalDateTime proCreateTime;


	/**
	 * 开户行
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="开户行")
	private String bankName;

	/**
	 * 支行
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="支行")
	private String bankSubName;

	/**
	 * 银行卡号
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="银行卡号")
	private String bankNo;

	/**
	 * 项目编码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="项目编码")
	private String deptNo;

	/**
	 * 合同类型（字典值）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="合同类型")
	@ExcelAttribute(name = "合同类型", isDataId = true,dataType = ExcelAttributeConstants.PERSONNEL_TYPE)
	private String contractType;

	/**
	 * 工时制
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="工时制")
	@ExcelAttribute(name = "工时制", isDataId = true,dataType = ExcelAttributeConstants.WORKING_HOURS)
	private String workingHours;

	/**
	 * 就职岗位
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="就职岗位")
	private String post;

	/**
	 * 入职日期
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="入职日期")
	@DateTimeFormat("yyyy-MM-dd")
	@Past
	private Date enjoinDate;

	/**
	 * 试用期（单位月）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="试用期")
	private String tryPeriod;

	/**
	 * 项目员工类型
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="项目员工类型")
	@ExcelAttribute(name = "项目员工类型", isDataId = true,dataType = ExcelAttributeConstants.EMP_NATRUE)
	private String empNatrue;

	/**
	 * 员工编码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="员工编码")
	private String empNo;

	/**
	 * 客户名称
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="客户名称")
	private String unitName;

	/**
	 * 客户编码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="客户编码")
	private String unitNo;

	/**
	 * 项目名称
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="项目名称")
	private String deptName;

	/**
	 * 员工合同状态（字典）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="合同状态")
	@ExcelAttribute(name = "合同状态", isDataId = true,dataType = ExcelAttributeConstants.PERSONNEL_STATE)
	private String contractStatus;

	/**
	 * 业务类型一级分类
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="业务类型一级分类")
	@ExcelAttribute(name = "业务类型一级分类", isDataId = true,dataType = ExcelAttributeConstants.CUSTOMER_BUSSINESS_PARENT)
	private String businessPrimaryType;

	/**
	 * 业务类型二级分类
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="业务类型二级分类")
	@ExcelAttribute(name = "业务类型二级分类", isDataId = true,dataType = ExcelAttributeConstants.CUSTOMER_BUSSINESS_TYPE)
	private String businessSecondType;

	/**
	 * 业务类型三级分类
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="业务类型三级分类")
	@ExcelAttribute(name = "业务类型三级分类", isDataId = true,dataType = ExcelAttributeConstants.CUSTOMER_BUSSINESS_SUB_TYPE)
	private String businessThirdType;

	/**
	 * 商险状态（字典）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="商险状态")
	@ExcelAttribute(name = "商险状态", isDataId = true,dataType = ExcelAttributeConstants.COMMERCIAL_SATTE)
	private String insuranceStatus;

	/**
	 * 社保状态（字典）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="社保状态")
	@ExcelAttribute(name = "社保状态", isDataId = true,dataType = ExcelAttributeConstants.SOCIAL_ECURITY_STATE)
	private String socialStatus;

	/**
	 * 公积金状态（字典）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="公积金状态")
	@ExcelAttribute(name = "公积金状态", isDataId = true,dataType = ExcelAttributeConstants.FUND_STATUS)
	private String fundStatus;

	/**
	 * 近3个月发薪（0否；1是）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="近3个月发薪")
	@ExcelAttribute(name = "近3个月发薪", readConverterExp = "0=无,1=是,2=否")
	private String salaryStatus;

	/**
	 * 项目档案来源（字典：4人员档案新建、5项目档案新建、1社保/公积金、3商险、2薪酬）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="项目档案来源")
	@ExcelAttribute(name = "项目档案来源", isDataId = true,dataType = ExcelAttributeConstants.PROJECT_EMP_SOURCE)
	private String projectSource;

	/**
	 * 项目档案状态（0草稿、1已审核）
	 */
	@ExcelAttribute(name ="项目档案状态", readConverterExp = "0=草稿,1=已审核")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="项目档案状态")
	private String status;

	/**
	 * 项目档案状态
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="项目档案状态")
	@ExcelAttribute(name = "项目档案状态")
	private String projectStatusReplace;

	/**
	 * 社保-省
	 */
	@ExcelAttribute(name ="社保所在省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="社保所在省")
	private String socialProvince;

	/**
	 * 社保-市
	 */
	@ExcelAttribute(name ="社保所在市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="社保所在市")
	private String socialCity;

	/**
	 * 社保-县
	 */
	@ExcelAttribute(name ="社保所在县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="社保所在县")
	private String socialTown;

	private String[] socialStatusArray;

	private String[] fundStatusArray;

	private String[] insuranceStatusArray;

	private String[] contractStatusArray;

	private String[] empNatureArray;

	private List<String> idList;

	/**
	 * @Author fxj
	 * 查询数据起
	 **/
	private int limitStart;
	/**
	 * @Author fxj
	 * 查询数据止
	 **/
	private int limitEnd;

	/**
	 * 导出IDS
	 */
	@Schema(description = "导出IDS")
	private String ids;

	private List<String> exportFields;
}
