package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TSettleDomain;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @program: master
 * @description: 分页展示包装类
 * @author: pwang
 * @create: 2019-09-02 11:40
 **/
@Tag(name = "结算主体表分页包装类")
@Data
public class TSettleDomainVo extends TSettleDomain implements Serializable {
    /**
     *客户名称
     **/
    @Schema(description = "客户编码", name = "customerCode")
    //非本表字段
    @TableField(exist = false)
    private String customerCode;

    /**
     *客户名称
     **/
    @Schema(description = "客户名称", name = "customerName")
    //非本表字段
    @TableField(exist = false)
    private String customerName;
    /**
     *客户id
     **/
    //非本表字段
    @TableField(exist = false)
    private String customerId;
    /**
     * 归属服务公司Id（乙方）
     */
    @Schema(description = "归属服务公司Id（合同属性）", name = "businessSubject")
    //非本表字段
    @TableField(exist = false)
    private String businessSubject;
    /**
     * 归属服务公司名称
     */
    @Schema(description = "归属服务公司名称（合同属性）", name = "businessSubject")
    //非本表字段
    @TableField(exist = false)
    private String businessSubjectName;
    /**
     *合同名称
     **/
    //非本表字段
    @TableField(exist = false)
    private String contractName;

    //业务类型
    @TableField(exist = false)
    @Schema(description = "业务类型")
    private String businessType;

    //业务类型细分
    @TableField(exist = false)
    @Schema(description = "业务细分")
    private String businessSub;

    @TableField(exist = false)
    @Schema(description = "创建月(需求变更查FIRST_PASS_TIME)")
    private String createMonth;

    /**************************************结算主体改造新增字段2021-03-17 开始*********************************************/
    @Schema(description = "业务类型分类", name = "businessPrimaryType")
    private String businessPrimaryType;


    @Schema(description = "业务类型二级分类", name = "businessSecondType")
    private String businessSecondType;

    @Schema(description = "业务类型三级分类", name = "businessThirdType")
    private String businessThirdType;

    /**
     * 0：人事；1：非人事
     */
    @Schema(description = "0：人事；1：非人事", name = "type")
    private Integer type;
    /**************************************结算主体改造新增字段2021-03-17 结束********************************************/

    /**************************************结算主体改造可先不关联合同2021-05-17 开始********************************************/
    /**
     * 创建类型：0 合同之后 1 合同之前
     */
    @Schema(description = "创建类型：0:合同之后 1:合同之前", name = "createType")
    private String createType;

    /**
     * 关联合同：0是1否
     */
    @Schema(description = "关联合同：0是1否", name = "relateFlag")
    private String relateFlag;

    /**
     * 异常说明
     */
    @Schema(description = "异常说明", name = "exceptionRemark")
    private String exceptionRemark;
    /**************************************结算主体改造可先不关联合同2021-05-17 结算主体改造新增字段2021-03-17 结束****************/

    /**
     * B端 传参  客户ID
     */
    @TableField(exist = false)
    private List<String> customerIds;

    /**
     * B端 传参  结算主体ID
     */
    @TableField(exist = false)
    private List<String> settleDomainIds;

}
