/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.pig4cloud.plugin.excel.vo.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCustomerInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpChangeInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TSettleDomain;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmpChangeInfoVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.springframework.validation.BindingResult;

import java.util.List;

/**
 * 档案划转日志表
 *
 * @author fxj
 * @date 2022-06-18 09:39:46
 */
public interface TEmpChangeInfoService extends IService<TEmpChangeInfo> {

	/**
	 * @Author huyc
	 * @Description  档案划转
	 * @Date 2022/6/22
	 **/
	R changeEmpProArc(TEmpChangeInfo tEmpChangeInfo);

	/**
	 * @Author huyc
	 * @Description  批量化转员工档案
	 * @Date 2022/6/22
	 **/
	R<List<ErrorMessage>> batchChangeArc(List<TEmpChangeInfoVO> excelVOList, BindingResult bindingResult);

	/**
	 * 获取所有项目名称
	 * @return R
	 * @Author huyc
	 * @Date 2022-06-22
	 * @param customerName
	 */
	R<List<TSettleDomain>> getAllDept(String customerName);

	/**
	 * 获取所有单位名称
	 * @return R
	 * @Author huyc
	 * @Date 2022-06-22
	 * @param customerName
	 */
	R<List<TCustomerInfo>> getAllUint(String customerName);

	IPage<TSettleDomain> getAllDeptPage(Page page, String deptName, String nameOrNo, String customerId,String flag);
}
