package com.yifu.cloud.plus.v1.yifu.auth.config;

import org.jasig.cas.client.authentication.AuthenticationFilter;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.session.SingleSignOutHttpSessionListener;
import org.jasig.cas.client.util.HttpServletRequestWrapperFilter;
import org.jasig.cas.client.validation.Cas30ProxyReceivingTicketValidationFilter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

import java.util.*;

@Configuration
@Component
public class CASAutoConfig {

    /**
	 * SingleSignOutHttpSessionListener 添加监听器
	 * 用于单点退出，该过滤器用于实现单点登出功能，可选配置
	 *
	 * @author licancan
	 * @param
	 * @return {@link ServletListenerRegistrationBean<EventListener>}
	 */
	@Bean
	public ServletListenerRegistrationBean<EventListener> singleSignOutListenerRegistration() {
		ServletListenerRegistrationBean<EventListener> registrationBean = new ServletListenerRegistrationBean<EventListener>();
		registrationBean.setListener(new SingleSignOutHttpSessionListener());
		registrationBean.setOrder(1);
		return registrationBean;
	}

	/**
	 * SingleSignOutFilter 登出过滤器
	 * 该过滤器用于实现单点登出功能，可选配置
	 *
	 * @author licancan
	 * @param
	 * @return {@link FilterRegistrationBean}
	 */
	@Bean
	public FilterRegistrationBean filterSingleRegistration() {
		FilterRegistrationBean registration = new FilterRegistrationBean();
		registration.setFilter(new SingleSignOutFilter());
		// 设定匹配的路径
		registration.addUrlPatterns("/*");
		Map<String, String> initParameters = new HashMap();
		initParameters.put("casServerUrlPrefix", CASproperties.CAS_SERVER_LOGIN_PATH);
		registration.setInitParameters(initParameters);
		// 设定加载的顺序
		registration.setOrder(2);
		return registration;
	}

	/**
	 * AuthenticationFilter 授权过滤器
	 *
	 * @author licancan
	 * @param
	 * @return {@link FilterRegistrationBean}
	 */
	@Bean
	public FilterRegistrationBean filterAuthenticationRegistration() {

		FilterRegistrationBean registration = new FilterRegistrationBean();
		Map<String, String> initParameters = new HashMap();

		registration.setFilter(new AuthenticationFilter());
		//registration.addUrlPatterns("*.html");
		initParameters.put("casServerLoginUrl", CASproperties.CAS_SERVER_PATH);
		initParameters.put("serverName", CASproperties.CLIENT_SERVER_NAME);

		// 不拦截的请求
		initParameters.put("ignorePattern", "^.*[.](js|css|gif|png|zip)$");

		// 表示过滤所有
		initParameters.put("ignoreUrlPatternType", "com.yifu.cloud.plus.v1.yifu.auth.filter.SimpleUrlPatternMatcherStrategy");

		registration.setInitParameters(initParameters);
		// 设定加载的顺序
		registration.setOrder(3);
		return registration;
	}


	/**
	 * Cas30ProxyReceivingTicketValidationFilter 验证过滤器
	 * 该过滤器负责对Ticket的校验工作，必须启用它
	 *
	 * @author licancan
	 * @param
	 * @return {@link FilterRegistrationBean}
	 */
	@Bean
	public FilterRegistrationBean filterValidationRegistration() {
		FilterRegistrationBean registration = new FilterRegistrationBean();
		registration.setFilter(new Cas30ProxyReceivingTicketValidationFilter());
		// 设定匹配的路径
		//registration.addUrlPatterns("*.html");
		Map<String, String> initParameters = new HashMap();
		initParameters.put("casServerUrlPrefix", CASproperties.CAS_SERVER_PATH);
		initParameters.put("serverName", CASproperties.CLIENT_SERVER_NAME);

		// 是否对serviceUrl进行编码，默认true：设置false可以在302对URL跳转时取消显示;jsessionid=xxx的字符串
		// 观察CommonUtils.constructServiceUrl方法可以看到
		//initParameters.put("encodeServiceUrl", "false");
		registration.setInitParameters(initParameters);
		// 设定加载的顺序
		registration.setOrder(4);
		return registration;
	}

	/**
	 * 该过滤器用于单点登录功能 ，对HttpServletRequest请求包装， 可通过HttpServletRequest的getRemoteUser()方法获得登录用户的登录名
	 * @return
	 */
	@Bean
	public FilterRegistrationBean casHttpServletRequestWrapperFilter(){
		FilterRegistrationBean authenticationFilter = new FilterRegistrationBean();
		authenticationFilter.setFilter(new HttpServletRequestWrapperFilter());
		authenticationFilter.setOrder(5);
		List<String> urlPatterns = new ArrayList<>();
		urlPatterns.add("/*");
		authenticationFilter.setUrlPatterns(urlPatterns);
		return authenticationFilter;
	}

	/**
	 * HttpServletRequestWrapperFilter wraper过滤器
	 * 该过滤器负责实现HttpServletRequest请求的包裹，
	 * 比如允许开发者通过HttpServletRequest的getRemoteUser()方法获得SSO登录用户的登录名，可选配置。
	 *
	 * @author licancan
	 * @param
	 * @return {@link FilterRegistrationBean}
	 */
	@Bean
	public FilterRegistrationBean filterWrapperRegistration() {
		FilterRegistrationBean registration = new FilterRegistrationBean();
		registration.setFilter(new HttpServletRequestWrapperFilter());
		// 设定匹配的路径
		registration.addUrlPatterns("/*");
		// 设定加载的顺序
		registration.setOrder(6);
		return registration;
	}
}
