/*
 * Copyright 1999-2018 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.yifu.cloud.plus.v1.yifu.auth.controller;

import com.yifu.cloud.plus.v1.yifu.auth.config.CASproperties;
import com.yifu.cloud.plus.v1.yifu.auth.util.LoginUtils;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.logging.Logger;

/**
 * @author huyc
 * @since 1.6.0
 */
@RequiredArgsConstructor
@RestController
@RequestMapping("/auth")
public class AuthController {

	private static final Logger LOG = Logger.getLogger(AuthController.class.getName());

	@PostMapping("/login")
	public String login(HttpServletRequest request, String username, String password) {
		return null;
	}

	@PostMapping(value = "/logout")
	public void logout(HttpServletRequest request) {
		request.getSession().invalidate();
	}

	@PostMapping(value = "/check")
	public String check(HttpServletRequest request, String username, String password) {
		String st = LoginUtils.getTicket(CASproperties.CAS_SERVER_LOGOUT_PATH,username,password,CASproperties.CLIENT_LOGIN_PAGE);
		LOG.info(st);
		return st;
	}
}
