package com.yifu.cloud.plus.v1.yifu.auth.filter;

import org.jasig.cas.client.authentication.UrlPatternMatcherStrategy;

import java.util.Arrays;
import java.util.List;

public class SimpleUrlPatternMatcherStrategy implements UrlPatternMatcherStrategy {

	/**
	 * 判断是否匹配这个字符串
	 *
	 * @author licancan
	 * @param url 用户请求的连接
	 * @return {@link boolean}  true:不拦截 false:必须得登录了
	 */
	@Override
	public boolean matches(String url) {
		List<String> list = Arrays.asList(
				"/login",
				"/restLogin"
		);
		String name = url.substring(url.lastIndexOf("/"));

		// String url = "http://127.0.0.1:8082/login?service=http%3A%2F%2F127.0.0.1%3A8082%2Fb";
		// 为了防止出现匹配中，忽略了后续参数的URL，出现比如：/login?service=http%3A%2F%2F127.0.0.1%3A8082%2Fb 现象
		// 这种现象，会导致重定向过多异常，所以，不管什么url，只取出请求的最终 /login 即可

		if (name.indexOf("?") != -1) {
			name = name.substring(0, name.indexOf("?"));
		}
		boolean result = list.contains(name);
		if (!result) {
			System.out.println("拦截URL：" + url);
		}
		return result;
	}

	/**
	 * 正则表达式的规则，这个地方可以是web传递过来的
	 *
	 * @author licancan
	 * @param pattern
	 * @return void
	 */
	@Override
	public void setPattern(String pattern) {
		System.out.println(11111);
	}
}
